/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.apache.log4j.Logger;

public class HTMLTransferHandler
extends TransferHandler
implements UIResource {
    private static Logger logger = Logger.getLogger(HTMLTransferHandler.class);
    private TransferHandler th;
    private Position startPosition;
    private Position endPosition;

    public HTMLTransferHandler(TransferHandler th) {
        this.th = th;
    }

    public int getSourceActions(JComponent c) {
        return this.th.getSourceActions(c);
    }

    protected void exportDone(JComponent source, Transferable data, int action) {
        JTextComponent textComponent = (JTextComponent)source;
        if (!textComponent.isEditable()) {
            return;
        }
        if (this.startPosition != null && this.endPosition != null && action != 1) {
            try {
                ((JTextComponent)source).getDocument().remove(this.startPosition.getOffset(), this.endPosition.getOffset() - this.startPosition.getOffset());
            }
            catch (BadLocationException e) {
                logger.error((Object)e);
            }
        }
    }

    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        JTextComponent textComponent = (JTextComponent)comp;
        String selectedText = textComponent.getSelectedText();
        if (selectedText != null && selectedText.length() > 0) {
            if ((action & 3) > 0) {
                StringSelection contents = new StringSelection(selectedText);
                clip.setContents(contents, null);
                super.exportToClipboard(comp, clip, action);
            }
            if ((action & 2) > 0) {
                textComponent.replaceSelection(null);
            }
        }
    }

    protected Transferable createTransferable(JComponent c) {
        JTextComponent textComponent = (JTextComponent)c;
        this.startPosition = null;
        this.endPosition = null;
        StringSelection contents = new StringSelection(((JTextComponent)c).getSelectedText());
        try {
            this.startPosition = textComponent.getDocument().createPosition(textComponent.getSelectionStart());
            this.endPosition = textComponent.getDocument().createPosition(textComponent.getSelectionEnd());
        }
        catch (BadLocationException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return contents;
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        return this.th.canImport(comp, transferFlavors);
    }

    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        this.th.exportAsDrag(comp, e, action);
    }

    public Icon getVisualRepresentation(Transferable t) {
        return this.th.getVisualRepresentation(t);
    }

    public boolean importData(JComponent comp, Transferable theTransferable) {
        try {
            JTextComponent textComponent = (JTextComponent)comp;
            if (!textComponent.isEditable()) {
                return false;
            }
            if (theTransferable.isDataFlavorSupported(GWFlavors.uriListFlavor)) {
                Window window;
                String path = (String)theTransferable.getTransferData(GWFlavors.uriListFlavor);
                List<File> fileList = Utils.getFileList(path);
                if (fileList.size() != 0 && (window = SwingUtilities.getWindowAncestor(comp)) instanceof FrameCompose) {
                    FrameCompose frameCompose = (FrameCompose)window;
                    frameCompose.getItemEdit().getController().processCommand(new Command(760, fileList));
                    return true;
                }
            } else if (theTransferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String textToDrop = (String)theTransferable.getTransferData(DataFlavor.stringFlavor);
                if (OS.isMacOS()) {
                    textToDrop = textToDrop.replaceAll("\r", "\n");
                }
                if (textToDrop != null) {
                    textComponent.replaceSelection(textToDrop);
                    return true;
                }
            }
        }
        catch (UnsupportedFlavorException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }
}

