/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.HTMLTextPane;
import java.awt.FontMetrics;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.html.InlineView;
import org.apache.log4j.Logger;

public class MyInlineView
extends InlineView {
    private static Logger logger = Logger.getLogger(MyInlineView.class);
    private JEditorPane editor;

    public MyInlineView(Element elem, JEditorPane theEditor) {
        super(elem);
        this.editor = theEditor;
    }

    private static boolean isDivider(char ch) {
        return ch == '%' || ch == '?';
    }

    public int getBreakWeight(int axis, float pos, float len) {
        try {
            return super.getBreakWeight(axis, pos, len);
        }
        catch (RuntimeException e) {
            logger.error((Object)e, (Throwable)e);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (MyInlineView.this.editor instanceof HTMLTextPane) {
                        HTMLTextPane pane = (HTMLTextPane)MyInlineView.this.editor;
                        pane.clear();
                    }
                }
            });
            throw e;
        }
    }

    protected int getBreakSpot(int p0, int p1) {
        return this.getBreakSpotUseWhitespace(p0, p1);
    }

    private int getBreakSpotUseWhitespace(int p0, int p1) {
        Segment s = this.getText(p0, p1);
        char ch = s.last();
        while (ch != '\uffff') {
            if (Character.isWhitespace(ch) || Character.isSpaceChar(ch) || MyInlineView.isDivider(ch)) {
                return s.getIndex() - s.getBeginIndex() + p0 + 1;
            }
            ch = s.previous();
        }
        return -1;
    }

    private String getString(int p0, int p1) {
        Segment text = new Segment();
        try {
            Document doc = this.getDocument();
            doc.getText(p0, p1 - p0, text);
        }
        catch (BadLocationException bl) {
            // empty catch block
        }
        return text.toString();
    }

    public int getFirstBreak(int p0) {
        String s = this.getString(p0, this.getEndOffset());
        char[] chars = s.toCharArray();
        int index = p0;
        FontMetrics fontMetrics = this.getFontMetrics();
        for (char ch : chars) {
            if (Character.isWhitespace(ch) || Character.isSpaceChar(ch)) {
                return index + fontMetrics.charWidth(' ');
            }
            index += fontMetrics.charWidth(ch);
        }
        return index;
    }
}

