/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.InvisibleView;
import com.appframework.components.htmleditor.MyImageView;
import com.appframework.components.htmleditor.MyInlineView;
import com.appframework.components.htmleditor.MyParagraphView;
import javax.swing.JEditorPane;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;

public class StyledHTMLFactory
extends HTMLEditorKit.HTMLFactory {
    private JEditorPane editor;

    public View create(Element elem) {
        Object o = elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (o instanceof HTML.Tag) {
            HTML.Tag kind = (HTML.Tag)o;
            if (kind == HTML.Tag.CONTENT) {
                return new MyInlineView(elem, this.editor);
            }
            if (kind == HTML.Tag.IMG) {
                return new MyImageView(elem);
            }
            if (kind == HTML.Tag.COMMENT) {
                return new InvisibleView(elem);
            }
            if (kind instanceof HTML.UnknownTag) {
                return new InvisibleView(elem);
            }
            if (kind == HTML.Tag.TITLE || kind == HTML.Tag.META || kind == HTML.Tag.LINK || kind == HTML.Tag.STYLE || kind == HTML.Tag.SCRIPT || kind == HTML.Tag.AREA || kind == HTML.Tag.MAP || kind == HTML.Tag.PARAM || kind == HTML.Tag.APPLET) {
                return new InvisibleView(elem);
            }
            if (kind == HTML.Tag.IMPLIED) {
                String ws = (String)elem.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                if (ws != null && ws.equals("pre")) {
                    return super.create(elem);
                }
                return new MyParagraphView(elem);
            }
        }
        return super.create(elem);
    }

    public void setEditor(JEditorPane theEditorPane) {
        this.editor = theEditorPane;
    }

    public void removeEditor() {
        this.editor = null;
    }
}

