/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.components.htmleditor;

import com.appframework.components.htmleditor.GWMozillaBrowserCanvas;
import com.appframework.components.htmleditor.ProxyConfiguration;
import com.appframework.components.htmleditor.SimpleHTMLViewer;
import com.appframework.components.htmleditor.hyperlink.HTMLUtils;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.printing.preview.PrintUtils;
import com.webrenderer.swing.IMozillaBrowserCanvas;
import com.webrenderer.swing.ProxySetting;
import com.webrenderer.swing.dom.IElement;
import com.webrenderer.swing.dom.IElementCollection;
import com.webrenderer.swing.event.BrowserAdapter;
import com.webrenderer.swing.event.BrowserEvent;
import com.webrenderer.swing.event.BrowserListener;
import com.webrenderer.swing.event.KeyListener;
import com.webrenderer.swing.event.MouseListener;
import com.webrenderer.swing.event.NetworkListener;
import com.webrenderer.swing.event.WindowEvent;
import com.webrenderer.swing.event.WindowListener;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JPanel;
import javax.swing.text.html.CSS;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappedMozillaBrowser
extends JPanel
implements GWMozillaBrowserCanvas,
SimpleHTMLViewer {
    private static Logger logger = Logger.getLogger(WrappedMozillaBrowser.class);
    protected IMozillaBrowserCanvas browser;
    private BlockPopupListener blockPopupListener = null;
    private List<BrowserListener> browserListeners = new ArrayList<BrowserListener>();
    private List<MouseListener> mouseListeners = new ArrayList<MouseListener>();
    private List<WindowListener> windowListeners = new ArrayList<WindowListener>();
    private List<KeyListener> keyListeners = new ArrayList<KeyListener>();
    private List<NetworkListener> networkListeners = new ArrayList<NetworkListener>();

    WrappedMozillaBrowser(IMozillaBrowserCanvas browser) {
        this.browser = browser;
        this.buildUI();
    }

    protected void buildUI() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.browser.getComponent());
    }

    @Override
    public boolean findInPage(String s, boolean b, boolean b1, boolean b2) {
        return this.browser.findInPage(s, b, b1, b2);
    }

    @Override
    public void copy() {
        this.browser.copy();
    }

    @Override
    public void selectAll() {
        this.browser.selectAll();
    }

    @Override
    public void loadURL(String s) {
        this.browser.loadURL(s);
    }

    @Override
    public void loadURL(URL url) {
        this.browser.loadURL(url);
    }

    @Override
    public void loadHTML(String s, String s1) {
        this.browser.loadHTML(s, s1);
    }

    @Override
    public void loadHTML(byte[] bytes, String s) {
        this.browser.loadHTML(bytes, s);
    }

    public void loadHTML(InputStream inputStream, String s) {
        this.browser.loadHTML(inputStream, s);
    }

    public void loadURL(int i, String s, byte[] bytes, String s1, String s2) {
        this.browser.loadURL(i, s, bytes, s1, s2);
    }

    @Override
    public void addBrowserListener(BrowserListener browserListener) {
        this.browser.addBrowserListener(browserListener);
        this.browserListeners.add(browserListener);
    }

    @Override
    public void removeBrowserListener(BrowserListener browserListener) {
        this.browser.removeBrowserListener(browserListener);
        this.browserListeners.remove(browserListener);
    }

    public Collection<BrowserListener> getBrowserListeners() {
        return new HashSet<BrowserListener>(this.browserListeners);
    }

    @Override
    public void addWindowListener(WindowListener windowListener) {
        this.browser.addWindowListener(windowListener);
        this.windowListeners.add(windowListener);
    }

    @Override
    public void removeWindowListener(WindowListener windowListener) {
        this.browser.removeWindowListener(windowListener);
        this.windowListeners.remove(windowListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.browser.addMouseListener(mouseListener);
        this.mouseListeners.add(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.browser.removeMouseListener(mouseListener);
        this.mouseListeners.remove(mouseListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.browser.addKeyListener(keyListener);
        this.keyListeners.add(keyListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.browser.removeKeyListener(keyListener);
        this.keyListeners.remove(keyListener);
    }

    @Override
    public void addNetworkListener(NetworkListener networkListener) {
        this.browser.addNetworkListener(networkListener);
        this.networkListeners.add(networkListener);
    }

    @Override
    public void removeNetworkListener(NetworkListener networkListener) {
        this.browser.removeNetworkListener(networkListener);
        this.networkListeners.remove(networkListener);
    }

    @Override
    public synchronized void addFocusListener(FocusListener l) {
        assert (false) : "this method should not be called on this object";
        super.addFocusListener(l);
    }

    public void setPreferredSize(int i, int i1) {
        this.browser.setPreferredSize(i, i1);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.browser.getComponent().getPreferredSize();
    }

    @Override
    public String getSelectedText() {
        return this.browser.getSelectedText();
    }

    @Override
    public void grabFocus() {
        this.browser.getComponent().requestFocus();
    }

    @Override
    public void increaseTextZoom() {
        this.browser.increaseTextZoom();
    }

    @Override
    public void decreaseTextZoom() {
        this.browser.decreaseTextZoom();
    }

    @Override
    public void setBrowserFont(Font theFont) {
        IElementCollection allElements = this.browser.getDocument().getAll();
        for (int i = 0; i < allElements.length(); ++i) {
            IElement element = allElements.item(i);
            if (!element.getTagName().equalsIgnoreCase("BODY")) continue;
            element.setAttribute("style", (Object)HTMLUtils.getCSSFontStyleFromFont(element.getAttribute("style", 0L), theFont), 0L);
            break;
        }
    }

    @Override
    public void setMargins(int theLeftMargin, int theTopMargin, int theRightMargin, int theBottomMargin) {
        IElementCollection allElements = this.browser.getDocument().getAll();
        for (int i = 0; i < allElements.length(); ++i) {
            IElement element = allElements.item(i);
            if (!element.getTagName().equalsIgnoreCase("BODY")) continue;
            String css = element.getAttribute("style", 0L);
            css = HTMLUtils.checkAndUpdateMarginAttribute(css, CSS.Attribute.MARGIN_LEFT, theLeftMargin);
            css = HTMLUtils.checkAndUpdateMarginAttribute(css, CSS.Attribute.MARGIN_RIGHT, theRightMargin);
            css = HTMLUtils.checkAndUpdateMarginAttribute(css, CSS.Attribute.MARGIN_TOP, theTopMargin);
            css = HTMLUtils.checkAndUpdateMarginAttribute(css, CSS.Attribute.MARGIN_BOTTOM, theBottomMargin);
            element.setAttribute("style", (Object)css, 0L);
            break;
        }
    }

    public String getSource() {
        return this.browser.getDocument().getDocumentSource();
    }

    @Override
    public void setPage(URL theURL) {
        this.browser.loadURL(theURL);
    }

    @Override
    public void setStyledText(String theStyledText) {
        this.browser.loadHTML(theStyledText, "");
    }

    @Override
    public void clear() {
        this.browser.loadHTML("", "");
    }

    public IMozillaBrowserCanvas getBrowser() {
        return this.browser;
    }

    @Override
    public void reload() {
        this.browser.reload(1);
    }

    @Override
    public boolean canGoBack() {
        return this.browser.canGoBack();
    }

    @Override
    public boolean canGoForward() {
        return this.browser.canGoForward();
    }

    @Override
    public void goBack() {
        if (!this.canGoBack()) {
            throw new IllegalStateException("can not go back");
        }
        this.browser.goBack();
    }

    @Override
    public void goForward() {
        if (!this.canGoForward()) {
            throw new IllegalStateException("can not go forward");
        }
        this.browser.goForward();
    }

    @Override
    public boolean isJavascriptEnabled() {
        return this.browser.getJavascriptEnabled();
    }

    @Override
    public void setJavascriptEnabled(boolean enabled) {
        this.browser.setJavascriptEnabled(enabled);
    }

    @Override
    public void print(boolean showPrintSetupDialog) {
        if (showPrintSetupDialog) {
            HashPrintRequestAttributeSet attributeSet = new HashPrintRequestAttributeSet(OptionManager.getInstance().getPrintingOptions().getPrintAttributeSet());
            boolean printConfirmed = PrintUtils.showPrintDialog(null, attributeSet, true);
            if (!printConfirmed) {
                return;
            }
            this.browser.setPrintRequestAttributeSet((PrintRequestAttributeSet)attributeSet);
        }
        this.browser.print(2);
    }

    @Override
    public void setProxyConfiguration(ProxyConfiguration configuration) {
        if (configuration.isProxyEnabled()) {
            this.browser.enableProxy();
            if (configuration.isProxyAutoConfigured()) {
                this.browser.autoconfigureProxy(configuration.getProxyAutoConfigurationUrl());
            } else {
                ProxySetting proxySetting = new ProxySetting(31, configuration.getProxyManualConfigurationServer(), configuration.getProxyManualConfigurationPort());
                this.browser.setProxyProtocol(proxySetting);
                List<String> bypassAddresses = configuration.getProxyBypassAddressList();
                StringBuilder bypassAddressesBuilder = new StringBuilder();
                boolean firstElement = true;
                for (String address : bypassAddresses) {
                    if (!firstElement) {
                        bypassAddressesBuilder.append(',');
                    }
                    bypassAddressesBuilder.append(address);
                    firstElement = false;
                }
                logger.debug((Object)("addresses: " + bypassAddressesBuilder.toString()));
                this.browser.setProxyBypasses(bypassAddressesBuilder.toString());
            }
        } else {
            this.browser.disableProxy();
        }
    }

    public void enableImages(boolean enable) {
        this.browser.enableImageLoading(enable);
    }

    @Override
    public void release() {
        this.removeAll();
        for (BrowserListener browserListener : new ArrayList<BrowserListener>(this.browserListeners)) {
            this.removeBrowserListener(browserListener);
        }
        for (MouseListener mouseListener : new ArrayList<MouseListener>(this.mouseListeners)) {
            this.removeMouseListener(mouseListener);
        }
        for (WindowListener windowListener : new ArrayList<WindowListener>(this.windowListeners)) {
            this.removeWindowListener(windowListener);
        }
        for (KeyListener keyListener : new ArrayList<KeyListener>(this.keyListeners)) {
            this.removeKeyListener(keyListener);
        }
        for (NetworkListener networkListener : new ArrayList<NetworkListener>(this.networkListeners)) {
            this.removeNetworkListener(networkListener);
        }
        assert (this.browserListeners.isEmpty());
        assert (this.mouseListeners.isEmpty());
        assert (this.windowListeners.isEmpty());
        assert (this.keyListeners.isEmpty());
        assert (this.networkListeners.isEmpty());
    }

    @Override
    public void setLoadPopupWindowInBrowser(boolean flag) {
        boolean currentState;
        boolean bl = currentState = this.blockPopupListener != null;
        if (flag == currentState) {
            return;
        }
        if (flag) {
            this.blockPopupListener = new BlockPopupListener();
            this.addBrowserListener(this.blockPopupListener);
            this.addWindowListener(this.blockPopupListener);
        } else {
            this.removeBrowserListener(this.blockPopupListener);
            this.removeWindowListener(this.blockPopupListener);
            this.blockPopupListener = null;
        }
    }

    private class BlockPopupListener
    extends BrowserAdapter
    implements BrowserListener,
    WindowListener {
        private String lastSelectedLink = null;

        private BlockPopupListener() {
        }

        public void onLinkChange(BrowserEvent event) {
            this.lastSelectedLink = event.getLink();
        }

        public void onNewWindow(WindowEvent event) {
            event.getPopupBrowser().destroy();
            if (this.lastSelectedLink != null) {
                WrappedMozillaBrowser.this.loadURL(this.lastSelectedLink);
            }
        }

        public void onWindowDestroy(WindowEvent event) {
        }

        public void onWindowResize(WindowEvent event) {
        }
    }
}

