/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.event;

import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.event.LevelEventHandler;
import com.appframework.level.Level;
import java.util.HashMap;

public class AppEventManager {
    private static final String ERROR_LISTENER_NOT_CONTAIN = "Listener is not contain in AppEventManager";
    private HashMap<Level, LevelEventHandler> handlers = new HashMap();
    private static AppEventManager instance;

    protected AppEventManager() {
    }

    public static AppEventManager getInstance() {
        if (instance == null) {
            instance = new AppEventManager();
        }
        return instance;
    }

    public void addListener(Level theLevel, Integer theEventID, AppEventListener theListener) {
        if (this.handlers.containsKey(theLevel)) {
            this.getLevelEventHandler(theLevel).add(theEventID, theListener);
        } else {
            LevelEventHandler handler = new LevelEventHandler();
            handler.add(theEventID, theListener);
            this.handlers.put(theLevel, handler);
        }
    }

    public void removeListener(Level theLevel, Integer theEventID, AppEventListener theListener) {
        if (this.contains(theLevel, theEventID, theListener)) {
            LevelEventHandler handler = this.getLevelEventHandler(theLevel);
            handler.remove(theEventID, theListener);
            if (handler.isEmpty()) {
                this.handlers.remove(theLevel);
            }
        } else {
            throw new IllegalArgumentException(ERROR_LISTENER_NOT_CONTAIN);
        }
    }

    private boolean contains(Level theLevel, Integer theEventID, AppEventListener theListener) {
        boolean ret = false;
        if (this.handlers.containsKey(theLevel)) {
            ret = this.getLevelEventHandler(theLevel).contains(theEventID, theListener);
        }
        return ret;
    }

    public void processEvent(AppEvent theEvent) {
        Level level = theEvent.getLevel();
        if (this.handlers.containsKey(level)) {
            this.getLevelEventHandler(level).process(theEvent);
        }
    }

    private LevelEventHandler getLevelEventHandler(Level theLevel) {
        return this.handlers.get(theLevel);
    }

    public void processGlobalEvent(AppEvent event) {
        Level[] levels;
        for (Level level : levels = this.handlers.keySet().toArray(new Level[this.handlers.keySet().size()])) {
            LevelEventHandler handler = this.handlers.get(level);
            if (handler == null) continue;
            handler.process(event);
        }
    }

    public void release(Level theLevel) {
        this.handlers.remove(theLevel);
    }

    public int getListenersCount() {
        int result = 0;
        for (LevelEventHandler handler : this.handlers.values()) {
            if (handler == null) continue;
            result += handler.getListenersCount();
        }
        return result;
    }
}

