/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.listener;

import com.appframework.listener.ListenerType;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ListenerManager {
    private static Logger logger = Logger.getLogger(ListenerManager.class);
    private static int DEFAULT_CRITICAL_CAPICITY = 100000;
    private List<Entry> entries = new ArrayList<Entry>();
    private int criticalCapicity;

    public ListenerManager(int criticalCapicity) {
        this.criticalCapicity = criticalCapicity;
    }

    public ListenerManager() {
        this(DEFAULT_CRITICAL_CAPICITY);
    }

    public synchronized void addListener(Object target, Object listener, ListenerType listenerType) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (listenerType == null) {
            throw new IllegalArgumentException("listenerType is null");
        }
        try {
            target.getClass().getMethod("add" + listenerType.getName(), listenerType.getListenerClass()).invoke(target, listener);
        }
        catch (Exception e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        this.putListener(target, listener, listenerType);
    }

    public synchronized void putListener(Object target, Object listener, ListenerType listenerType) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        if (listenerType == null) {
            throw new IllegalArgumentException("listenerType is null");
        }
        this.entries.add(new Entry<Object, Object>(target, listener, listenerType));
        if (this.entries.size() > this.criticalCapicity) {
            logger.debug((Object)"critical capicity reached > removing invalid entries");
            this.removeInvalidEntries();
        }
    }

    public synchronized void clean() {
        logger.debug((Object)("cleaning, size: " + this.entries.size()));
        for (Entry entry : this.entries) {
            if (!entry.isValid()) continue;
            try {
                entry.getTarget().getClass().getMethod("remove" + entry.listenerType.getName(), entry.listenerType.getListenerClass()).invoke(entry.getTarget(), entry.getListener());
            }
            catch (Exception e) {
                logger.error((Object)("Exception while removing entry: " + entry));
                throw new IllegalArgumentException(e);
            }
        }
        this.entries.clear();
    }

    private synchronized void removeInvalidEntries() {
        logger.debug((Object)("size: " + this.entries.size()));
        Iterator<Entry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().isValid()) continue;
            iterator.remove();
        }
        logger.debug((Object)("size: " + this.entries.size()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<T, L> {
        private WeakReference<T> target;
        private WeakReference<L> listener;
        private ListenerType listenerType;
        private static int nextInstanceId = 0;
        private int instanceId = nextInstanceId++;

        Entry(T target, L listener, ListenerType listenerType) {
            this.target = new WeakReference<T>(target);
            this.listener = new WeakReference<L>(listener);
            this.listenerType = listenerType;
        }

        T getTarget() {
            return this.target.get();
        }

        L getListener() {
            return (L)this.listener.get();
        }

        boolean isValid() {
            return this.getTarget() != null && this.getListener() != null;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                return ((Entry)obj).instanceId == this.instanceId;
            }
            return false;
        }

        public int hashCode() {
            return this.instanceId;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Entry [");
            builder.append(this.target.get());
            builder.append(", ");
            builder.append(this.listener.get());
            builder.append(", ");
            builder.append((Object)this.listenerType);
            builder.append(']');
            return builder.toString();
        }
    }
}

