/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import org.apache.log4j.Logger;

public final class Assertions {
    public static void assertIllegalState(String theMessage) {
        throw new IllegalStateException("Assertion failed. " + theMessage);
    }

    public static void assertIllegalArgument(String theMessage) {
        throw new IllegalArgumentException("Assertion failed. " + theMessage);
    }

    public static void assertNotNull(Object theObject, String theMessage) {
        if (theObject == null) {
            throw new IllegalArgumentException("Assertion failed. " + theMessage);
        }
    }

    public static void assertNotNull(Object theObject, String theMessage, Logger theLogger) {
        if (theObject == null) {
            theLogger.error((Object)("Assertion failed. " + theMessage));
            throw new IllegalArgumentException("Assertion failed. " + theMessage);
        }
    }

    public static final void assertNonZeroLengthArray(Object[] theArray, String theMessage) {
        Assertions.assertNotNull(theArray, "Array parameter is null");
        if (theArray.length == 0) {
            throw new IllegalArgumentException("Assertion failed. " + theMessage);
        }
    }

    public static final void assertNonZeroLengthString(String theString, String theMessage) {
        Assertions.assertNotNull(theString, "String parameter is null");
        if (theString.length() == 0) {
            throw new IllegalArgumentException("Assertion failed. " + theMessage);
        }
    }

    public static final void assertNonZeroLengthString(String theString, String theMessage, Logger logger) {
        Assertions.assertNotNull(theString, "String parameter is null");
        if (theString.length() == 0) {
            logger.error((Object)("Assertion failed. " + theMessage));
            throw new IllegalArgumentException("Assertion failed. " + theMessage);
        }
    }

    public static final void assertClass(Object theObject, Class theClass, Logger logger) {
        if (!theClass.isInstance(theObject)) {
            String errorMessage = "Assertion failed. Illegal argument class type";
            logger.error((Object)errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void assertIllegalMethodAccess() {
        throw new IllegalStateException("Illegall method access");
    }
}

