/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import com.novell.gw.jclient.application.options.mailto.CommandLineOptions;
import java.io.File;
import org.apache.log4j.Logger;

public class CommandLineUtils {
    private static Logger logger = Logger.getLogger(CommandLineUtils.class);
    private static final String OPEN_EML_FILE_PARAMETER = "-eml";

    private static boolean isBooleanOption(String arg) {
        return arg != null && (arg.equalsIgnoreCase("on") || arg.equalsIgnoreCase("off") || arg.equalsIgnoreCase("false") || arg.equalsIgnoreCase("true") || arg.equalsIgnoreCase("yes") || arg.equalsIgnoreCase("no") || arg.equals("1") || arg.equals("0"));
    }

    private static String getBooleanOption(String arg) {
        if (CommandLineUtils.isBooleanOption(arg)) {
            return arg;
        }
        return null;
    }

    public static CommandLineOptions processCommandLineArgs(String[] args) {
        CommandLineOptions options = CommandLineOptions.getOptions();
        int n = args == null ? -1 : args.length;
        for (int i = 0; i < n; ++i) {
            int index;
            logger.debug((Object)("param [" + i + "] = " + args[i]));
            String val = args[i];
            String small = val.toLowerCase();
            if (val.equals(OPEN_EML_FILE_PARAMETER) && i + 1 < args.length) {
                options.addFileToOpen(new File(args[++i]));
                continue;
            }
            if (val.startsWith("-aa=")) {
                index = val.indexOf(61);
                options.setAAFontsEnabled(CommandLineUtils.getBooleanOption(val.substring(index + 1)));
                continue;
            }
            if (val.startsWith("-r=") || val.startsWith("--rmi=")) {
                index = val.indexOf(61);
                options.setRmiEnabled(CommandLineUtils.getBooleanOption(val.substring(index + 1)));
                continue;
            }
            if (val.startsWith("-wr=")) {
                index = val.indexOf(61);
                options.setWREnabled(CommandLineUtils.getBooleanOption(val.substring(index + 1)));
                continue;
            }
            if (val.equals("-h") || val.equals("--help")) {
                options.setHelp(true);
                continue;
            }
            if (small.startsWith("--mailto:") || small.startsWith("-mailto:") || small.startsWith("mailto:")) {
                options.setMailTo(val.substring(small.indexOf("mailto:")));
                continue;
            }
            if (val.equals("-notify")) {
                options.setNotifier(true);
                continue;
            }
            options.addFileToOpen(new File(val));
        }
        return options;
    }
}

