/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import org.apache.log4j.Logger;

public class UnfocusedWindowVetoableChangeListener
implements VetoableChangeListener {
    private static Logger logger = Logger.getLogger(UnfocusedWindowVetoableChangeListener.class);
    private static final String FOCUSED_WINDOW_PROPERTY = "focusedWindow";
    private Window newWindow;
    private Window focusedWindow;
    private int stage = 0;

    public UnfocusedWindowVetoableChangeListener(Window newWindow) {
        if (newWindow == null) {
            throw new IllegalArgumentException("newDialog is null");
        }
        this.newWindow = newWindow;
        this.focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (!FOCUSED_WINDOW_PROPERTY.equals(evt.getPropertyName())) {
            return;
        }
        logger.debug((Object)("focus tries to move from " + (evt.getOldValue() == null ? null : evt.getOldValue().getClass().getSimpleName()) + " to " + (evt.getNewValue() == null ? null : evt.getNewValue().getClass().getSimpleName())));
        if (this.stage == 0) {
            if (evt.getOldValue() == this.focusedWindow) {
                ++this.stage;
                logger.debug((Object)"stage 0 > 1");
                throw new PropertyVetoException("do not allow newWindow to steal focus", evt);
            }
        } else if (this.stage <= 1 && evt.getNewValue() == this.newWindow) {
            ++this.stage;
            this.newWindow = null;
            this.focusedWindow = null;
            logger.debug((Object)"stage 1 > 2");
            throw new PropertyVetoException("do not allow newWindow to steal focus", evt);
        }
    }
}

