/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.utils.wait;

import com.appframework.utils.wait.DelayTimer;
import com.appframework.utils.wait.DispatchedEvent;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;

class CursorManager {
    private final DelayTimer waitTimer;
    private final Stack dispatchedEvents = new Stack();
    private boolean needsCleanup;

    public CursorManager(DelayTimer waitTimer) {
        this.waitTimer = waitTimer;
    }

    private void cleanUp() {
        if (((DispatchedEvent)this.dispatchedEvents.peek()).resetCursor()) {
            this.clearQueueOfInputEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearQueueOfInputEvents() {
        EventQueue q;
        EventQueue eventQueue = q = Toolkit.getDefaultToolkit().getSystemEventQueue();
        synchronized (eventQueue) {
            ArrayList nonInputEvents = CursorManager.gatherNonInputEvents(q);
            Iterator it = nonInputEvents.iterator();
            while (it.hasNext()) {
                q.postEvent((AWTEvent)it.next());
            }
        }
    }

    private static ArrayList gatherNonInputEvents(EventQueue systemQueue) {
        ArrayList<AWTEvent> events = new ArrayList<AWTEvent>();
        while (systemQueue.peekEvent() != null) {
            try {
                AWTEvent nextEvent = systemQueue.getNextEvent();
                if (nextEvent instanceof InputEvent) continue;
                events.add(nextEvent);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        return events;
    }

    public void push(Object source) {
        if (this.needsCleanup) {
            this.waitTimer.stopTimer();
            this.cleanUp();
        }
        this.dispatchedEvents.push(new DispatchedEvent(source));
        this.needsCleanup = true;
    }

    public void pop() {
        this.cleanUp();
        this.dispatchedEvents.pop();
        if (!this.dispatchedEvents.isEmpty()) {
            this.waitTimer.startTimer();
        } else {
            this.needsCleanup = false;
        }
    }

    public void setCursor() {
        ((DispatchedEvent)this.dispatchedEvents.peek()).setCursor();
    }
}

