/*
 * Decompiled with CFR 0.152.
 */
package com.appframework.weak;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakList<E> {
    private ReferenceQueue<E> referenceQueue = new ReferenceQueue();
    private List<WeakEntry<E>> entriesList = new ArrayList<WeakEntry<E>>();

    public int size() {
        this.removeStaleEntries();
        return this.entriesList.size();
    }

    public boolean add(E object) {
        if (object == null) {
            throw new IllegalArgumentException("object is null");
        }
        this.removeStaleEntries();
        WeakEntry<E> entry = new WeakEntry<E>(object, this.referenceQueue);
        this.entriesList.add(entry);
        return true;
    }

    public E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Illegal index " + index);
        }
        this.removeStaleEntries();
        E result = index >= this.entriesList.size() ? null : (E)this.entriesList.get(index).get();
        return result;
    }

    public boolean isEmpty() {
        this.removeStaleEntries();
        return this.entriesList.isEmpty();
    }

    public Object[] toArray() {
        this.removeStaleEntries();
        WeakEntry[] weakEntries = this.entriesList.toArray(new WeakEntry[this.entriesList.size()]);
        Object[] objects = new Object[weakEntries.length];
        for (int i = 0; i < weakEntries.length; ++i) {
            objects[i] = weakEntries[i].get();
        }
        return objects;
    }

    private void removeStaleEntries() {
        WeakEntry entry;
        while ((entry = (WeakEntry)this.referenceQueue.poll()) != null) {
            this.entriesList.remove(entry);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WeakEntry<E>
    extends WeakReference<E> {
        private static int nextInstanceId = Integer.MIN_VALUE;
        private int instanceId = nextInstanceId++;

        public WeakEntry(E referent, ReferenceQueue<E> q) {
            super(referent, q);
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return this.instanceId;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getSimpleName());
            builder.append("[ referent: ");
            builder.append(this.get());
            builder.append(", ID: ");
            builder.append(this.instanceId);
            builder.append(']');
            return builder.toString();
        }
    }
}

