/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl;

import com.novell.gw.engine.ItemList;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.engine.ItemListListener;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.api.APIInternal;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IItem;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IItemListListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;

public class ItemListImpl
implements IItemList,
IItemListListener {
    private static Logger logger = Logger.getLogger(ItemListImpl.class);
    private final List<IItemListListener> listeners = new ArrayList<IItemListListener>();
    private final ItemList itemList;

    @APIInternal
    protected ItemListImpl(ItemList itemList) {
        if (itemList == null) {
            throw new IllegalArgumentException("item list is null");
        }
        this.itemList = itemList;
        this.itemList.addItemListListener((ItemListListener)this);
    }

    @APIInternal
    public ItemList getNativeItemList() {
        return this.itemList;
    }

    public void addItemListListener(IItemListListener listener) {
        this.listeners.add(listener);
    }

    public void removeItemListListener(IItemListListener l) {
        this.listeners.remove(l);
    }

    public void sort(int sortField, boolean ascending) {
        logger.debug((Object)("SORTING   sortField: " + sortField + ";  ascending: " + ascending));
        this.itemList.sort(sortField, ascending);
        logger.debug((Object)("SORTED   sortField: " + this.itemList.getSortField() + ";  ascending: " + this.itemList.isSortAscending()));
    }

    public void sort(int sortField, boolean ascending, boolean sortTasklist) {
        logger.debug((Object)("SORTING   sortField: " + sortField + ";  ascending: " + ascending + "; sortTasklist: " + sortTasklist));
        this.itemList.sort(sortField, ascending, sortTasklist);
        logger.debug((Object)("SORTED   sortField: " + this.itemList.getSortField() + ";  ascending: " + this.itemList.isSortAscending()));
    }

    public int getSortField() {
        return this.itemList.getSortField();
    }

    public boolean isSortAscending() {
        return this.itemList.isSortAscending();
    }

    public int getDisplayItemCount() {
        return this.itemList.getDisplayItemCount();
    }

    public int getSize() {
        return this.itemList.getSize();
    }

    public int getFirstUnreadItemIndex(boolean isQuickViewerOn) {
        return this.itemList.getFirstUnreadItemIndex(isQuickViewerOn);
    }

    public IItem getItemAt(int index) {
        return APIWrapperManager.getItem(this.itemList.getItemAt(index));
    }

    public TransferItems getTransferItems(int[] indices) {
        return this.itemList.getTransferItems(indices);
    }

    public boolean setSelection(IItem[] items) {
        return this.itemList.setSelection(APIWrapperManager.getNativeItemArray(items));
    }

    public int getThreadDepth(IItem item) {
        return this.itemList.getThreadDepth(item.getNativeItem());
    }

    public int getThreadDepthAt(int index) {
        return this.itemList.getThreadDepthAt(index);
    }

    public boolean hasChildren(IItem item) {
        return this.itemList.hasChildren(item.getNativeItem());
    }

    public boolean hasChildrenAt(int index) {
        return this.itemList.hasChildrenAt(index);
    }

    public boolean hasUnreadItemInThread(IItem item) {
        return this.itemList.hasUnreadItemInThread(item.getNativeItem());
    }

    public boolean hasUnreadItemInThreadAt(int index) {
        return this.itemList.hasUnreadItemInThreadAt(index);
    }

    public boolean hasTaskListItemsOnly() {
        return this.itemList.hasTaskListItemsOnly();
    }

    public boolean isCollapsed(IItem item) {
        return this.itemList.isCollapsed(item.getNativeItem());
    }

    public boolean isCollapsedAt(int index) {
        return this.itemList.isCollapsedAt(index);
    }

    public boolean isCollapsedAutoDateItem(IItem item) {
        return this.itemList.isCollapsedAutoDateItem(item.getNativeItem());
    }

    public boolean isCollapsedAutoDateItemAt(int index) {
        return this.itemList.isCollapsedAutoDateItemAt(index);
    }

    public boolean isRecurringEntry(IItem item) {
        return this.itemList.isRecurringEntry(item.getNativeItem());
    }

    public boolean isRecurringEntryAt(int index) {
        return this.itemList.isRecurringEntryAt(index);
    }

    public boolean isRecurringEntryRoot(IItem item) {
        return this.itemList.isRecurringEntryRoot(item.getNativeItem());
    }

    public boolean isRecurringEntryRootAt(int index) {
        return this.itemList.isRecurringEntryRootAt(index);
    }

    public boolean isRootMost(IItem item) {
        return this.itemList.isRootMost(item.getNativeItem());
    }

    public boolean isRootMostAt(int index) {
        return this.itemList.isRootMostAt(index);
    }

    public void expand(IItem item) {
        this.itemList.expand(item.getNativeItem());
    }

    public void expandAt(int index) {
        this.itemList.expandAt(index);
    }

    public void collapse(IItem item) {
        this.itemList.collapse(item.getNativeItem());
    }

    public void collapseAt(int index) {
        this.itemList.collapseAt(index);
    }

    public void expandAll() {
        this.itemList.expandAll();
    }

    public void collapseAll() {
        this.itemList.collapseAll();
    }

    public boolean isThreadIgnored() {
        return this.itemList.isThreadIgnored();
    }

    public boolean isThreadIgnored(int index) {
        return this.itemList.isThreadIgnored(index);
    }

    public boolean isThreadIgnored(IItem item) {
        return this.itemList.isThreadIgnored(item.getNativeItem());
    }

    public boolean isThreadWatched() {
        return this.itemList.isThreadWatched();
    }

    public boolean isThreadWatched(int index) {
        return this.itemList.isThreadWatched(index);
    }

    public boolean isThreadWatched(IItem item) {
        return this.itemList.isThreadWatched(item.getNativeItem());
    }

    public boolean canMarkThreadIgnore() {
        return this.itemList.canMarkThreadIgnore();
    }

    public boolean canMarkThreadRead() {
        return this.itemList.canMarkThreadRead();
    }

    public boolean canMarkThreadWatch() {
        return this.itemList.canMarkThreadWatch();
    }

    public void markThreadIgnore() {
        this.itemList.markThreadIgnore();
    }

    public void markThreadRead() {
        this.itemList.markThreadRead();
    }

    public void markThreadWatch() {
        this.itemList.markThreadWatch();
    }

    public boolean canDeleteSelectedItems() {
        return this.itemList.canDeleteSelectedItems();
    }

    public boolean canDeleteItem(IItem item) {
        return this.itemList.canDeleteItem(item.getNativeItem());
    }

    public boolean canDeleteItemAt(int index) {
        return this.itemList.canDeleteItemAt(index);
    }

    public boolean deleteItem(IItem item) {
        return this.itemList.deleteItem(item.getNativeItem());
    }

    public boolean deleteSelectedItems() {
        return this.itemList.deleteSelectedItems();
    }

    public boolean deleteItemAt(int index) {
        return this.itemList.deleteItemAt(index);
    }

    public boolean canDeleteAndEmptyItem(IItem item) {
        return this.itemList.canDeleteAndEmptyItem(item.getNativeItem());
    }

    public boolean canDeleteAndEmptySelectedItems() {
        return this.itemList.canDeleteAndEmptySelectedItems();
    }

    public boolean canDeleteAndEmptyItemAt(int index) {
        return this.itemList.canDeleteAndEmptyItemAt(index);
    }

    public boolean deleteAndEmptyItem(IItem item) {
        return this.itemList.deleteAndEmptyItem(item.getNativeItem());
    }

    public boolean deleteAndEmptySelectedItems() {
        return this.itemList.deleteAndEmptySelectedItems();
    }

    public boolean deleteAndEmptyItemAt(int index) {
        return this.itemList.deleteAndEmptyItemAt(index);
    }

    public boolean canUndeleteItem(IItem item) {
        return this.itemList.canUndeleteItem(item.getNativeItem());
    }

    public boolean canUndeleteSelectedItems() {
        return this.itemList.canUndeleteSelectedItems();
    }

    public boolean canUndeleteItemAt(int index) {
        return this.itemList.canUndeleteItemAt(index);
    }

    public boolean undeleteItem(IItem item) {
        return this.itemList.undeleteItem(item.getNativeItem());
    }

    public boolean undeleteSelectedItems() {
        return this.itemList.undeleteSelectedItems();
    }

    public boolean undeleteItemAt(int index) {
        return this.itemList.undeleteItemAt(index);
    }

    public boolean canMarkItemPrivate(IItem item) {
        return this.itemList.canMarkItemPrivate(item.getNativeItem());
    }

    public boolean canMarkSelectedItemsPrivate() {
        return this.itemList.canMarkSelectedItemsPrivate();
    }

    public boolean canMarkItemPrivateAt(int index) {
        return this.itemList.canMarkItemPrivateAt(index);
    }

    public void markAllItemsRead() {
        this.itemList.markAllItemsRead();
    }

    public boolean markItemPrivate(IItem item) {
        return this.itemList.markItemPrivate(item.getNativeItem());
    }

    public boolean markSelectedItemsPrivate() {
        return this.itemList.markSelectedItemsPrivate();
    }

    public boolean markItemPrivateAt(int index) {
        return this.itemList.markItemPrivateAt(index);
    }

    public boolean canMarkItemRead(IItem item) {
        return this.itemList.canMarkItemRead(item.getNativeItem());
    }

    public boolean canMarkSelectedItemsRead() {
        return this.itemList.canMarkSelectedItemsRead();
    }

    public boolean canMarkItemReadAt(int index) {
        return this.itemList.canMarkItemReadAt(index);
    }

    public boolean markItemRead(IItem item) {
        return this.itemList.markItemRead(item.getNativeItem());
    }

    public boolean markSelectedItemsRead() {
        return this.itemList.markSelectedItemsRead();
    }

    public boolean markItemReadAt(int index) {
        return this.itemList.markItemReadAt(index);
    }

    public boolean canPurgeItem(IItem item) {
        return this.itemList.canPurgeItem(item.getNativeItem());
    }

    public boolean canPurgeSelectedItems() {
        return this.itemList.canPurgeSelectedItems();
    }

    public boolean canPurgeItemAt(int index) {
        return this.itemList.canPurgeItemAt(index);
    }

    public boolean purgeItem(IItem item) {
        return this.itemList.purgeItem(item.getNativeItem());
    }

    public boolean purgeSelectedItems() {
        return this.itemList.purgeSelectedItems();
    }

    public boolean purgeItemAt(int index) {
        return this.itemList.purgeItemAt(index);
    }

    public boolean canRestoreItem(IItem item) {
        return this.itemList.canRestoreItem(item.getNativeItem());
    }

    public boolean canRestoreSelectedItems() {
        return this.itemList.canRestoreSelectedItems();
    }

    public boolean canRestoreItemAt(int index) {
        return this.itemList.canRestoreItemAt(index);
    }

    public boolean restoreItem(IItem item) {
        return this.itemList.restoreItem(item.getNativeItem());
    }

    public boolean restoreSelectedItems() {
        return this.itemList.restoreSelectedItems();
    }

    public boolean restoreItemAt(int index) {
        return this.itemList.restoreItemAt(index);
    }

    public boolean canMarkItemReadLater(IItem item) {
        return this.itemList.canMarkItemReadLater(item.getNativeItem());
    }

    public boolean canMarkSelectedItemsReadLater() {
        return this.itemList.canMarkSelectedItemsReadLater();
    }

    public boolean canMarkItemReadLaterAt(int index) {
        return this.itemList.canMarkItemReadLaterAt(index);
    }

    public boolean markItemReadLater(IItem item) {
        return this.itemList.markItemReadLater(item.getNativeItem());
    }

    public boolean markSelectedItemsReadLater() {
        return this.itemList.markSelectedItemsReadLater();
    }

    public boolean markItemReadLaterAt(int index) {
        return this.itemList.markItemReadLaterAt(index);
    }

    public boolean canShowSelectionInChecklist() {
        return this.itemList.canShowSelectionInChecklist();
    }

    public boolean isSelectionInChecklist() {
        return this.itemList.isSelectionInChecklist();
    }

    public boolean showSelectionInChecklist(boolean bShow) {
        return this.itemList.showSelectionInChecklist(bShow);
    }

    public boolean moveSelectionToChecklist() {
        return this.itemList.moveSelectionToChecklist();
    }

    public boolean canMoveSelectionToChecklist() {
        return this.itemList.canMoveSelectionToChecklist();
    }

    public int findLastUncompletedChecklistItemIndex() {
        return this.itemList.findLastUncompletedChecklistItemIndex();
    }

    public Enumeration getEnumeration() {
        return this.itemList.getEnumeration();
    }

    public void queryStop() {
        this.itemList.queryStop();
    }

    public int indexOf(IItem item) {
        return this.itemList.indexOf(item.getNativeItem());
    }

    public int indexOf(String searchKey) {
        return this.itemList.indexOf(searchKey);
    }

    public int indexOf(String searchKey, int fromIndex) {
        return this.itemList.indexOf(searchKey, fromIndex);
    }

    public boolean canChecklistMoveDown(int iIndex) {
        return this.itemList.canChecklistMoveDown(iIndex);
    }

    public boolean checklistMoveDown(int iIndex) {
        return this.itemList.checklistMoveDown(iIndex);
    }

    public boolean canChecklistMoveUp(int iIndex) {
        return this.itemList.canChecklistMoveUp(iIndex);
    }

    public boolean checklistMoveUp(int iIndex) {
        return this.itemList.checklistMoveUp(iIndex);
    }

    public boolean canChecklistMoveToBottom(int iIndex) {
        return this.itemList.canChecklistMoveToBottom(iIndex);
    }

    public boolean checklistMoveToBottom(int iIndex) {
        return this.itemList.checklistMoveToBottom(iIndex);
    }

    public boolean canChecklistMoveToTop(int iIndex) {
        return this.itemList.canChecklistMoveToTop(iIndex);
    }

    public boolean checklistMoveToTop(int iIndex) {
        return this.itemList.checklistMoveToTop(iIndex);
    }

    public boolean checklistMoveTo(int iIndex, int iToIndex) {
        return this.itemList.checklistMoveTo(iIndex, iToIndex);
    }

    public boolean checklistMoveTo(int iIndex, int iToIndex, boolean bMoveRecurringSubItems) {
        return this.itemList.checklistMoveTo(iIndex, iToIndex, bMoveRecurringSubItems);
    }

    public boolean transferToTasklist(TransferItems transferItems, int itemIndex, boolean shouldMoveBelow, boolean moveInto) {
        return this.itemList.transferToTasklist(transferItems, itemIndex, shouldMoveBelow, moveInto);
    }

    public int handleJunkMailSelectedItems(int listType) {
        return this.itemList.handleJunkMailSelectedItems(listType);
    }

    public boolean canHandleJunkMailSelectedItems(int listType) {
        return this.itemList.canHandleJunkMailSelectedItems(listType);
    }

    public int canHandleJunkMailSelectedItems() {
        return this.itemList.canHandleJunkMailSelectedItems();
    }

    public IItem[] getCalendarItems(Date date) {
        return APIWrapperManager.getItemArray(this.itemList.getCalendarItems(date));
    }

    public IItem[] getCalendarItems(Date startDate, Date endDate) {
        return APIWrapperManager.getItemArray(this.itemList.getCalendarItems(startDate, endDate));
    }

    public IItem[] getCalendarItems(Date date, ItemType itemType) {
        return APIWrapperManager.getItemArray(this.itemList.getCalendarItems(date, itemType.getValue()));
    }

    public IItem[] getCalendarItems(Date startDate, Date endDate, ItemType itemType) {
        return APIWrapperManager.getItemArray(this.itemList.getCalendarItems(startDate, endDate, itemType.getValue()));
    }

    public IItem[] getAllDayEvents(Date date) {
        return APIWrapperManager.getItemArray(this.itemList.getAllDayEvents(date));
    }

    public IItem[] getAllDayEvents(Date startDate, Date endDate) {
        return APIWrapperManager.getItemArray(this.itemList.getAllDayEvents(startDate, endDate));
    }

    public IItem[] getAppointments(Date date) {
        return APIWrapperManager.getItemArray(this.itemList.getAppointments(date));
    }

    public IItem[] getAppointments(Date startDate, Date endDate) {
        return APIWrapperManager.getItemArray(this.itemList.getAppointments(startDate, endDate));
    }

    public IItem[] getNotes(Date date) {
        return APIWrapperManager.getItemArray(this.itemList.getNotes(date));
    }

    public IItem[] getNotes(Date startDate, Date endDate) {
        return APIWrapperManager.getItemArray(this.itemList.getNotes(startDate, endDate));
    }

    public IItem[] getTasks(Date date) {
        return APIWrapperManager.getItemArray(this.itemList.getTasks(date));
    }

    public IItem[] getTasks(Date startDate, Date endDate) {
        return APIWrapperManager.getItemArray(this.itemList.getTasks(startDate, endDate));
    }

    public int getMonthBusyDays(ItemListFilter filter, int year, int month) {
        int busyDays = this.itemList.getMonthBusyDays(filter, year, month);
        return busyDays;
    }

    public boolean canSetCategoriesOnSelection() {
        return this.itemList.canSetCategoriesOnSelection();
    }

    public void setCategories(ICategoryList categoryList, IItem[] items) {
        this.itemList.setCategories(categoryList.getNativeCategoryList(), APIWrapperManager.getNativeItemArray(items));
    }

    public boolean setFilter(ItemListFilter filter) {
        return this.itemList.setFilter(filter);
    }

    public boolean canCreateChecklistItem() {
        return this.itemList.canCreateChecklistItem();
    }

    public boolean canCreateChecklistSubItemAt(int index) {
        return this.itemList.canCreateChecklistSubItemAt(index);
    }

    public boolean canCreateChecklistSubItemAtSelection() {
        return this.itemList.canCreateChecklistSubItemAtSelection();
    }

    public boolean createChecklistItem(String newMessageText, int newItemIndex, int newItemParentIndex, ItemListFilter filter) {
        return this.itemList.createChecklistItem(newMessageText, newItemIndex, newItemParentIndex, filter);
    }

    public boolean createChecklistItem(String newMessageText, int newItemIndex) {
        return this.itemList.createChecklistItem(newMessageText, newItemIndex);
    }

    public boolean createChecklistSubItem(String newMessageText, int newItemIndex, int newItemParentIndex) {
        return this.itemList.createChecklistSubItem(newMessageText, newItemIndex, newItemParentIndex);
    }

    public boolean canChecklistMoveRight(int iIndex) {
        return this.itemList.canChecklistMoveRight(iIndex);
    }

    public boolean checklistMoveRight(int iIndex) {
        return this.itemList.checklistMoveRight(iIndex);
    }

    public boolean canChecklistMoveLeft(int iIndex) {
        return this.itemList.canChecklistMoveLeft(iIndex);
    }

    public boolean checklistMoveLeft(int iIndex) {
        return this.itemList.checklistMoveLeft(iIndex);
    }

    public void dispose() {
        this.itemList.dispose();
    }

    public void contentsChanged(ItemListEvent e) {
        for (IItemListListener listener : this.listeners.toArray(new IItemListListener[this.listeners.size()])) {
            listener.contentsChanged(e);
        }
    }

    public void moreResultsAvailable(ItemListEvent e) {
        for (IItemListListener listener : this.listeners.toArray(new IItemListListener[this.listeners.size()])) {
            listener.moreResultsAvailable(e);
        }
    }

    public void queryResultsDone(ItemListEvent e) {
        for (IItemListListener listener : this.listeners.toArray(new IItemListListener[this.listeners.size()])) {
            listener.queryResultsDone(e);
        }
    }

    public void notifyEmptyList(ItemListEvent e) {
        for (IItemListListener listener : this.listeners.toArray(new IItemListListener[this.listeners.size()])) {
            listener.notifyEmptyList(e);
        }
    }
}

