/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl.message;

import com.novell.gw.ab.DistributionList;
import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.impl.APIWrappingConfigurator;
import com.novell.gw.jclient.api.impl.message.AppointmentImpl;
import com.novell.gw.jclient.api.impl.message.AppointmentImpl_Cached;
import com.novell.gw.jclient.api.impl.message.AttachmentImpl;
import com.novell.gw.jclient.api.impl.message.BusySearchImpl;
import com.novell.gw.jclient.api.impl.message.DelayDeliverInfoImpl;
import com.novell.gw.jclient.api.impl.message.DocumentReferenceImpl;
import com.novell.gw.jclient.api.impl.message.MailImpl;
import com.novell.gw.jclient.api.impl.message.MailImpl_Cached;
import com.novell.gw.jclient.api.impl.message.MessageAttachmentImpl;
import com.novell.gw.jclient.api.impl.message.NoteImpl;
import com.novell.gw.jclient.api.impl.message.NoteImpl_Cached;
import com.novell.gw.jclient.api.impl.message.PhoneMessageImpl;
import com.novell.gw.jclient.api.impl.message.SharedAddressBookNotificationImpl;
import com.novell.gw.jclient.api.impl.message.SharedFolderNotificationImpl;
import com.novell.gw.jclient.api.impl.message.SuggestedBodyImpl;
import com.novell.gw.jclient.api.impl.message.TaskImpl;
import com.novell.gw.jclient.api.impl.message.TaskImpl_Cached;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IAppointment;
import com.novell.gw.jclient.api.interfaces.message.IAttachment;
import com.novell.gw.jclient.api.interfaces.message.IBusySearch;
import com.novell.gw.jclient.api.interfaces.message.IDelayDeliverInfo;
import com.novell.gw.jclient.api.interfaces.message.IDocumentReference;
import com.novell.gw.jclient.api.interfaces.message.IMail;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.INote;
import com.novell.gw.jclient.api.interfaces.message.IPhoneMessage;
import com.novell.gw.jclient.api.interfaces.message.ISuggestedBody;
import com.novell.gw.jclient.api.interfaces.message.ITask;
import com.novell.gw.message.Appointment;
import com.novell.gw.message.Attachment;
import com.novell.gw.message.BusySearch;
import com.novell.gw.message.DocumentReference;
import com.novell.gw.message.Mail;
import com.novell.gw.message.Message;
import com.novell.gw.message.MessageAttachment;
import com.novell.gw.message.Note;
import com.novell.gw.message.PhoneMessage;
import com.novell.gw.message.SharedAddressBookNotification;
import com.novell.gw.message.SharedFolderNotification;
import com.novell.gw.message.Task;
import java.util.Date;

public class APIMessageWrapperManager {
    public static IMessage getMessage(Message message) {
        if (message == null) {
            return null;
        }
        if (message instanceof DocumentReference) {
            return new DocumentReferenceImpl((DocumentReference)message);
        }
        if (message instanceof Mail) {
            return APIMessageWrapperManager.getMail((Mail)message);
        }
        if (message instanceof Note) {
            return APIMessageWrapperManager.getNote((Note)message);
        }
        throw new IllegalStateException("unexpected message type: " + message.getClass().getName());
    }

    public static IAttachment getAttachment(Attachment attachment) {
        if (attachment == null) {
            return null;
        }
        if (attachment instanceof MessageAttachment) {
            return new MessageAttachmentImpl((MessageAttachment)attachment);
        }
        return new AttachmentImpl(attachment);
    }

    public static IMail getMail(Mail mail) {
        if (mail == null) {
            return null;
        }
        if (mail instanceof PhoneMessage) {
            return new PhoneMessageImpl((PhoneMessage)mail);
        }
        if (mail instanceof SharedAddressBookNotification) {
            return new SharedAddressBookNotificationImpl((SharedAddressBookNotification)mail);
        }
        if (mail instanceof SharedFolderNotification) {
            return new SharedFolderNotificationImpl((SharedFolderNotification)mail);
        }
        return APIMessageWrapperManager.wrapMail(mail);
    }

    public static INote getNote(Note note) {
        if (note == null) {
            return null;
        }
        if (note instanceof Task) {
            return APIMessageWrapperManager.wrapTask((Task)note);
        }
        if (note instanceof Appointment) {
            return APIMessageWrapperManager.wrapAppointment((Appointment)note);
        }
        return APIMessageWrapperManager.wrapNote(note);
    }

    public static IDelayDeliverInfo getDelayDeliverInfo(Message.DelayDeliverInfo delayDeliverInfo) {
        if (delayDeliverInfo == null) {
            return null;
        }
        return new DelayDeliverInfoImpl(delayDeliverInfo);
    }

    public static ISuggestedBody getSuggestedBody(Message.SuggestedBody suggestedBody) {
        if (suggestedBody == null) {
            return null;
        }
        return new SuggestedBodyImpl(suggestedBody);
    }

    public static IDocumentReference createDocumentReference(IDataStore dataStore) {
        return new DocumentReferenceImpl(new DocumentReference(dataStore.getNativeDataStore()));
    }

    public static IMail createMail(IDataStore dataStore) throws EngineException {
        return APIMessageWrapperManager.wrapMail(new Mail(dataStore.getNativeDataStore()));
    }

    public static IMail createMail(IDataStore dataStore, IFolder createInFolder) throws EngineException {
        return APIMessageWrapperManager.wrapMail(new Mail(dataStore.getNativeDataStore(), createInFolder.getNativeFolder()));
    }

    public static IPhoneMessage createPhoneMessage(IDataStore dataStore) throws EngineException {
        return new PhoneMessageImpl(new PhoneMessage(dataStore.getNativeDataStore()));
    }

    public static IPhoneMessage createPhoneMessage(IDataStore dataStore, IFolder createInFolder) throws EngineException {
        return new PhoneMessageImpl(new PhoneMessage(dataStore.getNativeDataStore(), createInFolder.getNativeFolder()));
    }

    public static INote createNote(IDataStore dataStore) throws EngineException {
        return APIMessageWrapperManager.wrapNote(new Note(dataStore.getNativeDataStore()));
    }

    public static INote createNote(IDataStore dataStore, IFolder createInFolder) throws EngineException {
        return APIMessageWrapperManager.wrapNote(new Note(dataStore.getNativeDataStore(), createInFolder.getNativeFolder()));
    }

    public static IAppointment createAppointment(IDataStore dataStore) throws EngineException {
        return APIMessageWrapperManager.wrapAppointment(new Appointment(dataStore.getNativeDataStore()));
    }

    public static IAppointment createAppointment(IDataStore dataStore, IFolder createInFolder) throws EngineException {
        return APIMessageWrapperManager.wrapAppointment(new Appointment(dataStore.getNativeDataStore(), createInFolder.getNativeFolder()));
    }

    public static ITask createTask(IDataStore dataStore) throws EngineException {
        return APIMessageWrapperManager.wrapTask(new Task(dataStore.getNativeDataStore()));
    }

    public static ITask createTask(IDataStore dataStore, IFolder createInFolder) throws EngineException {
        return APIMessageWrapperManager.wrapTask(new Task(dataStore.getNativeDataStore(), createInFolder.getNativeFolder()));
    }

    public static IBusySearch createBusySearch() {
        return new BusySearchImpl(new BusySearch());
    }

    public static IBusySearch createBusySearch(IDataStore dataStore, DistributionList dList) throws EngineException {
        return new BusySearchImpl(new BusySearch(dataStore.getNativeDataStore(), dList));
    }

    public static IBusySearch createBusySearch(IDataStore dataStore, Date apptStartTime, Date apptEndTime, DistributionList dList, Date beginSearchTime, int numberDaysToSearch) throws EngineException {
        return new BusySearchImpl(new BusySearch(dataStore.getNativeDataStore(), apptStartTime, apptEndTime, dList, beginSearchTime, numberDaysToSearch));
    }

    public static IDelayDeliverInfo createDelayDeliverInfo(IMessage message, int days, int hours, int minutes) {
        Message message2 = message.getNativeMessage();
        message2.getClass();
        return new DelayDeliverInfoImpl(new Message.DelayDeliverInfo(message2, days, hours, minutes));
    }

    private static IAppointment wrapAppointment(Appointment appointment) {
        assert (appointment != null);
        IAppointment impl = new AppointmentImpl(appointment);
        if (APIWrappingConfigurator.getImplementationMap().get(IAppointment.class) == AppointmentImpl_Cached.class) {
            impl = new AppointmentImpl_Cached(impl);
        }
        return impl;
    }

    private static IMail wrapMail(Mail mail) {
        assert (mail != null);
        IMail impl = new MailImpl(mail);
        if (APIWrappingConfigurator.getImplementationMap().get(IMail.class) == MailImpl_Cached.class) {
            impl = new MailImpl_Cached(impl);
        }
        return impl;
    }

    private static INote wrapNote(Note note) {
        assert (note != null);
        INote impl = new NoteImpl(note);
        if (APIWrappingConfigurator.getImplementationMap().get(INote.class) == NoteImpl_Cached.class) {
            impl = new NoteImpl_Cached(impl);
        }
        return impl;
    }

    private static ITask wrapTask(Task task) {
        assert (task != null);
        ITask impl = new TaskImpl(task);
        if (APIWrappingConfigurator.getImplementationMap().get(ITask.class) == TaskImpl_Cached.class) {
            impl = new TaskImpl_Cached(impl);
        }
        return impl;
    }
}

