/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.api.impl.message;

import com.appframework.cache.ICached;
import com.novell.gw.ab.DistributionList;
import com.novell.gw.ab.UnresolvedAddressException;
import com.novell.gw.account.Account;
import com.novell.gw.engine.EngineException;
import com.novell.gw.engine.SendCallback;
import com.novell.gw.engine.TransferAttachments;
import com.novell.gw.engine.TransferItems;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.api.enums.MessageSentItemStatus;
import com.novell.gw.jclient.api.impl.ItemImpl_Cached;
import com.novell.gw.jclient.api.interfaces.ICategory;
import com.novell.gw.jclient.api.interfaces.ICategoryList;
import com.novell.gw.jclient.api.interfaces.IDataStore;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.message.IAttachment;
import com.novell.gw.jclient.api.interfaces.message.IDelayDeliverInfo;
import com.novell.gw.jclient.api.interfaces.message.IMessage;
import com.novell.gw.jclient.api.interfaces.message.ISuggestedBody;
import com.novell.gw.message.Message;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MessageImpl_Cached
extends ItemImpl_Cached
implements IMessage,
ICached {
    private static final Logger logger = Logger.getLogger(MessageImpl_Cached.class);
    private static Set<CacheKey> cacheKeySet = new HashSet<CacheKey>();
    private Map<CacheKey, Object> cache = new HashMap<CacheKey, Object>();
    private Map<Integer, String> cacheValue = new HashMap<Integer, String>();
    protected IMessage message = (IMessage)this.item;

    protected MessageImpl_Cached(IMessage message) {
        super(message);
    }

    public void clearCachedValues() {
        super.clearCachedValues();
        this.cache.clear();
        this.cacheValue.clear();
    }

    public void clearCachedValue(Object valueKey) {
        super.clearCachedValue(valueKey);
        if (!(valueKey instanceof CacheKey)) {
            throw new IllegalArgumentException();
        }
        this.cache.put((CacheKey)((Object)valueKey), null);
    }

    public String getValue(int fieldId, IFolder selectedFolder) {
        String value = this.cacheValue.get(fieldId);
        if (value == null) {
            value = this.message.getValue(fieldId, selectedFolder);
            if (cacheKeySet.contains((Object)CacheKey.GET_VALUE)) {
                this.cacheValue.put(fieldId, value);
            }
        }
        return value;
    }

    public String getSummaryValue(int areaNum, IFolder selectedFolder, IViewDisplaySettings displaySettings) {
        CacheKey key;
        if (areaNum == 0) {
            key = CacheKey.GET_SUMMARY_VALUE_AREA_0;
        } else if (areaNum == 1) {
            key = CacheKey.GET_SUMMARY_VALUE_AREA_1;
        } else if (areaNum == 2) {
            key = CacheKey.GET_SUMMARY_VALUE_AREA_2;
        } else {
            throw new IllegalArgumentException();
        }
        String value = (String)this.cache.get((Object)key);
        if (value == null) {
            value = this.message.getSummaryValue(areaNum, selectedFolder, displaySettings);
            if (cacheKeySet.contains((Object)key)) {
                this.cache.put(key, value);
            }
        }
        return value;
    }

    public boolean isCompleted() {
        Boolean isCompleted = (Boolean)this.cache.get((Object)CacheKey.IS_COMPLETED);
        if (isCompleted == null) {
            isCompleted = this.message.isCompleted();
            if (cacheKeySet.contains((Object)CacheKey.IS_COMPLETED)) {
                this.cache.put(CacheKey.IS_COMPLETED, isCompleted);
            }
        }
        return isCompleted;
    }

    public boolean isInChecklist() {
        Boolean isInChecklist = (Boolean)this.cache.get((Object)CacheKey.IS_IN_CHECKLIST);
        if (isInChecklist == null) {
            isInChecklist = this.message.isInChecklist();
            if (cacheKeySet.contains((Object)CacheKey.IS_IN_CHECKLIST)) {
                this.cache.put(CacheKey.IS_IN_CHECKLIST, isInChecklist);
            }
        }
        return isInChecklist;
    }

    public ICategoryList getCategories() {
        CacheKey cacheKey = CacheKey.GET_CATEGORIES;
        ICategoryList value = (ICategoryList)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.getCategories();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public boolean isPostedViewName() {
        CacheKey cacheKey = CacheKey.IS_POSTED_VIEW_NAME;
        Boolean value = (Boolean)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.isPostedViewName();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public boolean setPostedViewName(boolean posted) {
        boolean result = this.message.setPostedViewName(posted);
        if (cacheKeySet.contains((Object)CacheKey.IS_POSTED_VIEW_NAME)) {
            this.cache.put(CacheKey.IS_POSTED_VIEW_NAME, result);
        }
        return result;
    }

    public void showInChecklist(boolean bShow) {
        CacheKey cacheKey = CacheKey.IS_IN_CHECKLIST;
        if (cacheKeySet.contains((Object)cacheKey)) {
            this.cache.put(cacheKey, null);
        }
        this.message.showInChecklist(bShow);
    }

    public void setCategories(ICategoryList categories) {
        CacheKey cacheKey = CacheKey.GET_CATEGORIES;
        if (cacheKeySet.contains((Object)cacheKey)) {
            this.cache.put(cacheKey, null);
        }
        if (cacheKeySet.contains((Object)(cacheKey = CacheKey.GET_PRIMARY_CATEGORY))) {
            this.cache.put(cacheKey, null);
        }
        this.message.setCategories(categories);
    }

    public ICategory getPrimaryCategory() {
        CacheKey cacheKey = CacheKey.GET_PRIMARY_CATEGORY;
        ICategory value = (ICategory)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.getPrimaryCategory();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public Date getDueDate() {
        CacheKey cacheKey = CacheKey.GET_DUE_DATE;
        Date value = (Date)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.getDueDate();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public boolean hasPaperclipAttachments() {
        Boolean hasPaperclipAttachments = (Boolean)this.cache.get((Object)CacheKey.HAS_PAPERCLIP_ATTACHMENTS);
        if (hasPaperclipAttachments == null) {
            hasPaperclipAttachments = this.message.hasPaperclipAttachments();
            if (cacheKeySet.contains((Object)CacheKey.HAS_PAPERCLIP_ATTACHMENTS)) {
                this.cache.put(CacheKey.HAS_PAPERCLIP_ATTACHMENTS, hasPaperclipAttachments);
            }
        }
        return hasPaperclipAttachments;
    }

    public void markRead() throws EngineException {
        CacheKey cacheKey = CacheKey.IS_READ;
        if (cacheKeySet.contains((Object)cacheKey)) {
            this.cache.put(cacheKey, null);
        }
        this.message.markRead();
    }

    public void markReadLater() throws EngineException {
        if (cacheKeySet.contains((Object)CacheKey.IS_READ)) {
            this.cache.put(CacheKey.IS_READ, null);
        }
        this.message.markReadLater();
    }

    public void markPrivate(boolean fMarkPrivate) throws EngineException {
        CacheKey cacheKey = CacheKey.IS_PRIVATE;
        if (cacheKeySet.contains((Object)cacheKey)) {
            this.cache.put(cacheKey, null);
        }
        this.message.markPrivate(fMarkPrivate);
    }

    public void markComplete(boolean fCompleted) throws EngineException {
        CacheKey cacheKey = CacheKey.IS_COMPLETED;
        if (cacheKeySet.contains((Object)cacheKey)) {
            this.cache.put(cacheKey, null);
        }
        this.message.markComplete(fCompleted);
    }

    public boolean isPrivate() {
        CacheKey cacheKey = CacheKey.IS_PRIVATE;
        Boolean value = (Boolean)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.isPrivate();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public boolean isRead() {
        CacheKey cacheKey = CacheKey.IS_READ;
        Boolean value = (Boolean)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.isRead();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public boolean isRepliedTo() {
        Boolean isRepliedTo = (Boolean)this.cache.get((Object)CacheKey.IS_REPLIED_TO);
        if (isRepliedTo == null) {
            isRepliedTo = this.message.isRepliedTo();
            if (cacheKeySet.contains((Object)CacheKey.IS_REPLIED_TO)) {
                this.cache.put(CacheKey.IS_REPLIED_TO, isRepliedTo);
            }
        }
        return isRepliedTo;
    }

    public boolean isPersonal() {
        CacheKey cacheKey = CacheKey.IS_PERSONAL;
        Boolean value = (Boolean)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.isPersonal();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public boolean isForwarded() {
        CacheKey cacheKey = CacheKey.IS_FORWARDED;
        Boolean value = (Boolean)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.isForwarded();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public boolean isIMAPDeleted() {
        CacheKey cacheKey = CacheKey.IS_IMAP_DELETED;
        Boolean value = (Boolean)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.isIMAPDeleted();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public boolean isIMAPHeader() {
        CacheKey cacheKey = CacheKey.IS_IMAP_HEADER;
        Boolean value = (Boolean)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.isIMAPHeader();
            if (cacheKeySet.contains((Object)cacheKey)) {
                logger.debug((Object)("CACHE " + (Object)((Object)cacheKey)));
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public boolean isIMAPMessage() {
        CacheKey cacheKey = CacheKey.IS_IMAP_MESSAGE;
        Boolean value = (Boolean)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.isIMAPMessage();
            if (cacheKeySet.contains((Object)cacheKey)) {
                logger.debug((Object)("CACHE " + (Object)((Object)cacheKey)));
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public boolean isChecklistDummyItem() {
        Boolean checklistDummyItem = (Boolean)this.cache.get((Object)CacheKey.IS_CHECKLIST_DUMMY_ITEM);
        if (checklistDummyItem == null) {
            checklistDummyItem = this.message.isChecklistDummyItem();
            if (cacheKeySet.contains((Object)CacheKey.IS_CHECKLIST_DUMMY_ITEM)) {
                this.cache.put(CacheKey.IS_CHECKLIST_DUMMY_ITEM, checklistDummyItem);
            }
        }
        return checklistDummyItem;
    }

    public Date getDate() {
        CacheKey cacheKey = CacheKey.GET_DATE;
        Date value = (Date)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.getDate();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public Date getDeletedDate() {
        CacheKey cacheKey = CacheKey.GET_DELETED_DATE;
        Date value = (Date)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.getDeletedDate();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public Date getCreationDate() {
        CacheKey cacheKey = CacheKey.GET_CREATION_DATE;
        Date value = (Date)this.cache.get((Object)cacheKey);
        if (value == null) {
            value = this.message.getCreationDate();
            if (cacheKeySet.contains((Object)cacheKey)) {
                this.cache.put(cacheKey, value);
            }
        }
        return value;
    }

    public Message getNativeMessage() {
        return this.message.getNativeMessage();
    }

    public int getUID() {
        return this.message.getUID();
    }

    public String getGID() {
        return this.message.getGID();
    }

    public boolean isDraft() {
        return this.message.isDraft();
    }

    public void autoSave() {
        this.message.autoSave();
    }

    public void deleteAutoSaveFile() {
        this.message.deleteAutoSaveFile();
    }

    public boolean canAccept() {
        return this.message.canAccept();
    }

    public boolean canArchive() {
        return this.message.canArchive();
    }

    public boolean canChangeTo(ItemType destItemType) {
        return this.message.canChangeTo(destItemType);
    }

    public boolean canComplete() {
        return this.message.canComplete();
    }

    public boolean canDelete() {
        return this.message.canDelete();
    }

    public boolean canDeleteAndEmpty() {
        return this.message.canDeleteAndEmpty();
    }

    public boolean canDelegate() {
        return this.message.canDelegate();
    }

    public boolean canDialSender() {
        return this.message.canDialSender();
    }

    public boolean canDoInfo() {
        return this.message.canDoInfo();
    }

    public boolean canForward() {
        return this.message.canForward();
    }

    public boolean canMarkPrivate() {
        return this.message.canMarkPrivate();
    }

    public boolean canMarkRead() {
        return this.message.canMarkRead();
    }

    public boolean canMarkReadLater() {
        return this.message.canMarkReadLater();
    }

    public boolean canModify() {
        return this.message.canModify();
    }

    public boolean canPrint() {
        return this.message.canPrint();
    }

    public boolean canEmpty() {
        return this.message.canEmpty();
    }

    public boolean canOpen() {
        return this.message.canOpen();
    }

    public boolean canDecline() {
        return this.message.canDecline();
    }

    public boolean canReply() {
        return this.message.canReply();
    }

    public boolean canReplyToOriginalTopic() {
        return this.message.canReplyToOriginalTopic();
    }

    public boolean canResend() {
        return this.message.canResend();
    }

    public boolean canSave() {
        return this.message.canSave();
    }

    public boolean canSetAllDayEvent() {
        return this.message.canSetAllDayEvent();
    }

    public boolean canShowInChecklist() {
        return this.message.canShowInChecklist();
    }

    public boolean canUndelete() {
        return this.message.canUndelete();
    }

    public boolean canView() {
        return this.message.canView();
    }

    public boolean showHTMLOnlyWarning() {
        return this.message.showHTMLOnlyWarning();
    }

    public InputStreamReader getBodyRtfReader() {
        return this.message.getBodyRtfReader();
    }

    public int indexOf(IAttachment attachment) {
        return this.message.indexOf(attachment);
    }

    public boolean isHTMLMessage() {
        return this.message.isHTMLMessage();
    }

    public boolean saveToFile(String saveFileName, int saveFormatType) {
        return this.message.saveToFile(saveFileName, saveFormatType);
    }

    public String saveBodyHtmlToTempFile() {
        return this.message.saveBodyHtmlToTempFile();
    }

    public String saveBodyHtmlToTempFile(String charSetEncoding) {
        return this.message.saveBodyHtmlToTempFile(charSetEncoding);
    }

    public String getHTMLCharSetEncoding() {
        return this.message.getHTMLCharSetEncoding();
    }

    public String getSenderID() {
        return this.message.getSenderID();
    }

    public MessageSentItemStatus getSentItemStatus() {
        return this.message.getSentItemStatus();
    }

    public int getNotifyWhenDeleted() {
        return this.message.getNotifyWhenDeleted();
    }

    public boolean setNotifyWhenDeleted(int how) {
        return this.message.setNotifyWhenDeleted(how);
    }

    public int getNotifyWhenOpened() {
        return this.message.getNotifyWhenOpened();
    }

    public boolean setNotifyWhenOpened(int how) {
        return this.message.setNotifyWhenOpened(how);
    }

    public boolean setReplyWithinDays(int day) {
        return this.message.setReplyWithinDays(day);
    }

    public boolean setReplyWhenConvenient(boolean set) {
        return this.message.setReplyWhenConvenient(set);
    }

    public boolean setReplyRequested(boolean set) {
        return this.message.setReplyRequested(set);
    }

    public boolean isReplyRequested() {
        return this.message.isReplyRequested();
    }

    public boolean isReplyWithinDays() {
        return this.message.isReplyWithinDays();
    }

    public int getReplyRequestDays() {
        return this.message.getReplyRequestDays();
    }

    public String getSenderEmailAddress() {
        return this.message.getSenderEmailAddress();
    }

    public String getFromText() {
        return this.message.getFromText();
    }

    public boolean setFromText(String from) {
        return this.message.setFromText(from);
    }

    public boolean setMimeEncoding(int mimeEncoding) {
        return this.message.setMimeEncoding(mimeEncoding);
    }

    public int getMimeEncoding() {
        return this.message.getMimeEncoding();
    }

    public String getSubject() {
        return this.message.getSubject();
    }

    public boolean setSubject(String subject) {
        return this.message.setSubject(subject);
    }

    public ItemType getItemType() {
        return this.message.getItemType();
    }

    public TransferAttachments getTransferAttachments(int[] indices) {
        return this.message.getTransferAttachments(indices);
    }

    public int getTransferOptions(TransferAttachments transferAttachs) {
        return this.message.getTransferOptions(transferAttachs);
    }

    public int getTransferOptions(TransferItems transferItems) {
        return this.message.getTransferOptions(transferItems);
    }

    public boolean transfer(TransferAttachments transferAttachs, int action) {
        return this.message.transfer(transferAttachs, action);
    }

    public boolean transfer(TransferItems transferItems, int action) {
        return this.message.transfer(transferItems, action);
    }

    public boolean isAllDayEvent() {
        return this.message.isAllDayEvent();
    }

    public boolean isDeleted() {
        return this.message.isDeleted();
    }

    public boolean isNNTPHeader() {
        return this.message.isNNTPHeader();
    }

    public boolean isNNTPMessage() {
        return this.message.isNNTPMessage();
    }

    public boolean isRSSMessage() {
        return this.message.isRSSMessage();
    }

    public boolean isPseudoItem() {
        return this.message.isPseudoItem();
    }

    public String getRecordID() {
        return this.message.getRecordID();
    }

    public String getViewName() {
        return this.message.getViewName();
    }

    public int getPriority() {
        return this.message.getPriority();
    }

    public boolean setPriority(int priority) {
        return this.message.setPriority(priority);
    }

    public int getSecurity() {
        return this.message.getSecurity();
    }

    public boolean setSecurity(int security) {
        return this.message.setSecurity(security);
    }

    public int getSize() {
        return this.message.getSize();
    }

    public String getDisplaySize() {
        return this.message.getDisplaySize();
    }

    public int getMsgBodyAttachmentSize() {
        return this.message.getMsgBodyAttachmentSize();
    }

    public int getBoxType() {
        return this.message.getBoxType();
    }

    public IFolder getFolder() {
        return this.message.getFolder();
    }

    public IFolder getViewFolder() {
        return this.message.getViewFolder();
    }

    public DistributionList getDistributionList() {
        return this.message.getDistributionList();
    }

    public boolean setDistributionList(DistributionList dlist) {
        return this.message.setDistributionList(dlist);
    }

    public boolean setBodyTextForAutoSave(String bodyText) {
        return this.message.setBodyTextForAutoSave(bodyText);
    }

    public boolean setBodyTextForSend(String bodyText) {
        return this.message.setBodyTextForSend(bodyText);
    }

    public void send(Account account) throws EngineException {
        this.message.send(account);
    }

    public void send(Account account, SendCallback callBack) throws EngineException {
        this.message.send(account, callBack);
    }

    public void post(Account account) throws EngineException, IllegalArgumentException {
        this.message.post(account);
    }

    public void post(Account account, SendCallback callBack) throws EngineException, IllegalArgumentException {
        this.message.post(account, callBack);
    }

    public IMessage changeTo(ItemType itemType) {
        return this.message.changeTo(itemType);
    }

    public IMessage changeTo(ItemType itemType, boolean keepOriginalMessage, boolean keepDistributionList) {
        return this.message.changeTo(itemType, keepOriginalMessage, keepDistributionList);
    }

    public IMessage createSimpleForward() throws EngineException {
        return this.message.createSimpleForward();
    }

    public IMessage createSimpleForward(String partialFwdText) throws EngineException {
        return this.message.createSimpleForward(partialFwdText);
    }

    public IMessage createForward() throws EngineException {
        return this.message.createForward();
    }

    public IMessage createReply(int style, boolean withBody) throws EngineException {
        return this.message.createReply(style, withBody);
    }

    public IMessage createReply(int style, boolean withBody, boolean withAttachments) throws EngineException {
        return this.message.createReply(style, withBody, withAttachments);
    }

    public IMessage createReply(int style, boolean withBody, boolean withAttachments, String partialReplyText) throws EngineException {
        return this.message.createReply(style, withBody, withAttachments, partialReplyText);
    }

    public IMessage createResend(int option) {
        return this.message.createResend(option);
    }

    public void markOpen() throws EngineException {
        this.message.markOpen();
    }

    public void archive() throws EngineException {
        this.message.archive();
    }

    public boolean delete() {
        return this.message.delete();
    }

    public boolean deleteAndEmpty() {
        return this.message.deleteAndEmpty();
    }

    public boolean restore() {
        return this.message.restore();
    }

    public boolean empty() {
        return this.message.empty();
    }

    public void unDelete() throws EngineException {
        this.message.unDelete();
    }

    public boolean deleteAttachment(int index) {
        return this.message.deleteAttachment(index);
    }

    public boolean deleteAttachment(IAttachment attachment) {
        return this.message.deleteAttachment(attachment);
    }

    public boolean addAttachment(String fileName) {
        return this.message.addAttachment(fileName);
    }

    public boolean addAttachment(IMessage msg) {
        return this.message.addAttachment(msg);
    }

    public boolean saveDraft(String where) throws UnresolvedAddressException {
        return this.message.saveDraft(where);
    }

    public boolean saveDraft(String where, SendCallback callBack) throws UnresolvedAddressException {
        return this.message.saveDraft(where, callBack);
    }

    public void modify() throws EngineException {
        this.message.modify();
    }

    public void modify(SendCallback callBack) throws EngineException {
        this.message.modify(callBack);
    }

    public void modify(SendCallback callBack, boolean fPromptRecurring) throws EngineException {
        this.message.modify(callBack, fPromptRecurring);
    }

    public IAttachment[] getAttachments() {
        return this.message.getAttachments();
    }

    public boolean hasSourceAttachment() {
        return this.message.hasSourceAttachment();
    }

    public int findSourceAttachment() {
        return this.message.findSourceAttachment();
    }

    public boolean hasBodyText() {
        return this.message.hasBodyText();
    }

    public void getInfoFile(String sFilename) {
        this.message.getInfoFile(sFilename);
    }

    public void retractItem() {
        this.message.retractItem();
    }

    public ISuggestedBody getSuggestedBody() {
        return this.message.getSuggestedBody();
    }

    public ISuggestedBody getSuggestedBody(boolean htmlMode) {
        return this.message.getSuggestedBody(htmlMode);
    }

    public int getOpenTotals() {
        return this.message.getOpenTotals();
    }

    public int getPercentComplete() {
        return this.message.getPercentComplete();
    }

    public boolean canHandleJunkMailItem(int listType) {
        return this.message.canHandleJunkMailItem(listType);
    }

    public int canHandleJunkMailItem() {
        return this.message.canHandleJunkMailItem();
    }

    public int handleJunkMailItem(int listType) {
        return this.message.handleJunkMailItem(listType);
    }

    public boolean isDigitallySigned() {
        return this.message.isDigitallySigned();
    }

    public boolean isDigitallyClearSigned() {
        return this.message.isDigitallyClearSigned();
    }

    public boolean isDigitallySignedOrEncrypted() {
        return this.message.isDigitallySignedOrEncrypted();
    }

    public boolean isEncrypted() {
        return this.message.isEncrypted();
    }

    public String getPersonalizeNotes() {
        return this.message.getPersonalizeNotes();
    }

    public String getPersonalizeSubject() {
        return this.message.getPersonalizeSubject();
    }

    public boolean canUpdatePersonalizeData() {
        return this.message.canUpdatePersonalizeData();
    }

    public void updatePersonalizeData(String mySubject, String myNotes, ICategoryList categories) {
        this.message.updatePersonalizeData(mySubject, myNotes, categories);
    }

    public boolean canUpdateChecklistData() {
        return this.message.canUpdateChecklistData();
    }

    public void updateChecklistData(boolean bSetDueDate, Date dueDate, boolean bSetPercentComplete, int percentComplete, boolean bIsComplete, IItemList itemList, int newOrderIndex) {
        this.message.updateChecklistData(bSetDueDate, dueDate, bSetPercentComplete, percentComplete, bIsComplete, itemList, newOrderIndex);
    }

    public boolean containsExternalImages() {
        return this.message.containsExternalImages();
    }

    public boolean getUserEnabledImages() {
        return this.message.getUserEnabledImages();
    }

    public void setUserEnabledImages(boolean bEnabled) {
        this.message.setUserEnabledImages(bEnabled);
    }

    public void addVCard(String vCardFileName) {
        this.message.addVCard(vCardFileName);
    }

    public boolean isStubbedOr3rdPartyOnlyItem() {
        return this.message.isStubbedOr3rdPartyOnlyItem();
    }

    public int getSendOptionExpireDays() {
        return this.message.getSendOptionExpireDays();
    }

    public boolean setSendOptionExpireDays(int expireDays) {
        return this.message.setSendOptionExpireDays(expireDays);
    }

    public IDelayDeliverInfo getSendOptionDelayDeliverInfo() {
        return this.message.getSendOptionDelayDeliverInfo();
    }

    public boolean setSendOptionDelayDeliverInfo(IDelayDeliverInfo delay) {
        return this.message.setSendOptionDelayDeliverInfo(delay);
    }

    public boolean getSendOptionNotifyRecipients() {
        return this.message.getSendOptionNotifyRecipients();
    }

    public boolean setSendOptionNotifyRecipients(boolean bEnabled) {
        return this.message.setSendOptionNotifyRecipients(bEnabled);
    }

    public boolean getSendOptionCreateSentItem() {
        return this.message.getSendOptionCreateSentItem();
    }

    public boolean setSendOptionCreateSentItem(boolean bEnabled) {
        return this.message.setSendOptionCreateSentItem(bEnabled);
    }

    public int getSendOptionStatusTracking() {
        return this.message.getSendOptionStatusTracking();
    }

    public boolean setSendOptionStatusTracking(int setting) {
        return this.message.setSendOptionStatusTracking(setting);
    }

    public boolean getSendOptionMailAutoDelete() {
        return this.message.getSendOptionMailAutoDelete();
    }

    public boolean setSendOptionMailAutoDelete(boolean bEnabled) {
        return this.message.setSendOptionMailAutoDelete(bEnabled);
    }

    public int getSendOptionInternetStatusTracking() {
        return this.message.getSendOptionInternetStatusTracking();
    }

    public boolean setSendOptionInternetStatusTracking(int setting) {
        return this.message.setSendOptionInternetStatusTracking(setting);
    }

    public boolean getSendOptionConcealSubject() {
        return this.message.getSendOptionConcealSubject();
    }

    public boolean setSendOptionConcealSubject(boolean bEnabled) {
        return this.message.setSendOptionConcealSubject(bEnabled);
    }

    public boolean isDiscussionItem() {
        return this.message.isDiscussionItem();
    }

    public Account getSendingAccount() {
        return this.message.getSendingAccount();
    }

    public void setSendingAccount(Account account) {
        this.message.setSendingAccount(account);
    }

    public String toString() {
        return this.message.toString();
    }

    public IDataStore getSendingDataStore() {
        return this.message.getSendingDataStore();
    }

    public boolean setSendingDataStore(IDataStore dataStore) {
        return this.message.setSendingDataStore(dataStore);
    }

    static {
        cacheKeySet.add(CacheKey.GET_SUMMARY_VALUE_AREA_0);
        cacheKeySet.add(CacheKey.GET_SUMMARY_VALUE_AREA_1);
        cacheKeySet.add(CacheKey.GET_SUMMARY_VALUE_AREA_2);
        cacheKeySet.add(CacheKey.GET_VALUE);
        cacheKeySet.add(CacheKey.GET_CATEGORIES);
        cacheKeySet.add(CacheKey.IS_COMPLETED);
        cacheKeySet.add(CacheKey.IS_IN_CHECKLIST);
        cacheKeySet.add(CacheKey.IS_READ);
        cacheKeySet.add(CacheKey.HAS_PAPERCLIP_ATTACHMENTS);
        cacheKeySet.add(CacheKey.IS_REPLIED_TO);
        cacheKeySet.add(CacheKey.IS_FORWARDED);
        cacheKeySet.add(CacheKey.IS_CHECKLIST_DUMMY_ITEM);
        cacheKeySet.add(CacheKey.GET_CREATION_DATE);
        cacheKeySet.add(CacheKey.GET_DATE);
        cacheKeySet.add(CacheKey.GET_DELETED_DATE);
        cacheKeySet.add(CacheKey.GET_DUE_DATE);
        cacheKeySet.add(CacheKey.IS_PRIVATE);
        cacheKeySet.add(CacheKey.IS_PERSONAL);
        cacheKeySet.add(CacheKey.IS_POSTED_VIEW_NAME);
        cacheKeySet.add(CacheKey.GET_PRIMARY_CATEGORY);
        cacheKeySet.add(CacheKey.IS_IMAP_DELETED);
        cacheKeySet.add(CacheKey.IS_IMAP_HEADER);
        cacheKeySet.add(CacheKey.IS_IMAP_MESSAGE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CacheKey {
        GET_SUMMARY_VALUE_AREA_0,
        GET_SUMMARY_VALUE_AREA_1,
        GET_SUMMARY_VALUE_AREA_2,
        GET_VALUE,
        GET_CATEGORIES,
        IS_COMPLETED,
        IS_IN_CHECKLIST,
        IS_READ,
        HAS_PAPERCLIP_ATTACHMENTS,
        IS_REPLIED_TO,
        IS_FORWARDED,
        IS_CHECKLIST_DUMMY_ITEM,
        GET_CREATION_DATE,
        GET_DATE,
        GET_DELETED_DATE,
        GET_DUE_DATE,
        IS_PERSONAL,
        IS_PRIVATE,
        IS_POSTED_VIEW_NAME,
        GET_PRIMARY_CATEGORY,
        IS_IMAP_DELETED,
        IS_IMAP_HEADER,
        IS_IMAP_MESSAGE;

    }
}

