/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.Application;
import com.appframework.ApplicationFrame;
import com.appframework.components.htmleditor.GWBrowserFactory;
import com.appframework.components.htmleditor.GWMozillaBrowser;
import com.appframework.drag.DragManager;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.level.LevelManager;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.GlobalCommand;
import com.appframework.selection.SelectionManagersFactory;
import com.appframework.utils.CommandLineUtils;
import com.appframework.utils.OS;
import com.appframework.utils.OSXAdapter;
import com.appframework.utils.UIUtils;
import com.appframework.utils.Utils;
import com.appframework.utils.wait.WaitCursorEventQueue;
import com.novell.gw.account.Account;
import com.novell.gw.engine.Engine;
import com.novell.gw.engine.LoginParameters;
import com.novell.gw.jclient.api.APIFactory;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.ClickAction;
import com.novell.gw.jclient.application.DevModeUtils;
import com.novell.gw.jclient.application.GWClientActionList;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.GWMainAppFrameActionList;
import com.novell.gw.jclient.application.GWSplash;
import com.novell.gw.jclient.application.SettingsMigrator;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionNewMail;
import com.novell.gw.jclient.application.actions.ActionShowWindow;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwtooltips.GWToolTipUI;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.menus.GWMenuBar;
import com.novell.gw.jclient.application.dialogs.AutoSaveDialog;
import com.novell.gw.jclient.application.frames.compose.FrameCompose;
import com.novell.gw.jclient.application.frames.open.FrameOpen;
import com.novell.gw.jclient.application.notify.NotifyController;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.options.mailto.CommandLineOptions;
import com.novell.gw.jclient.application.options.mailto.MailToOptions;
import com.novell.gw.jclient.application.options.mailto.MailToStringParser;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.application.startup.ComposeMailDispatcher;
import com.novell.gw.jclient.application.startup.MailToEvent;
import com.novell.gw.jclient.application.startup.OpenMailEvent;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.eng_impl.GwAWTErrorHandler;
import com.novell.gw.jclient.bl.eng_impl.SSLSetup;
import com.novell.gw.jclient.bl.impl.cache.FoldersCache;
import com.novell.gw.jclient.bl.impl.cache.ItemsCache;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.GWNotify;
import com.novell.gw.jclient.bl.om.GWUserInfo;
import com.novell.gw.jclient.bl.om.PathManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.ItemListsCache;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.options.DateTimeOptions;
import com.novell.gw.jclient.rmi.one_instance.RMIException;
import com.novell.gw.jclient.rmi.one_instance.client.GWClientRMIClient;
import com.novell.gw.jclient.rmi.one_instance.server.GWClientRMIServer;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.File;
import java.lang.ref.WeakReference;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import javax.media.jai.JAI;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class GWClient
extends Application {
    private static Logger logger = Logger.getLogger(GWClient.class);
    private static boolean USE_EXTERNAL_HTML_VIEWER;
    private static Application application;
    private static GWClientActionList gwClientActionList;
    private static final int WINDOW_MENU_ITEMS_COUNT = 2;
    private static WaitCursorEventQueue waitQueue;
    private static GWClientRMIClient rmiClient;
    private static boolean gwClientRunning;
    private static boolean notifierRunning;
    private static WeakReference<NotifyController> notifyController;
    private static boolean notifyStartedWithClient;
    private static boolean performingExit;
    private static boolean inSync;
    private static volatile boolean initialSyncDone;
    private PrepThread m_imageThread = null;
    private static GWClientRMIServer rmiServer;

    public static void setperformingExit(boolean performExit) {
        performingExit = performExit;
    }

    public static boolean isPerformingExit() {
        return performingExit;
    }

    public static boolean isInSync() {
        logger.debug((Object)("inSync: " + inSync));
        return inSync;
    }

    public static void setGwClientRunning(boolean gwClientRunning) {
        GWClient.gwClientRunning = gwClientRunning;
        if (GWClient.gwClientRunning) {
            ComposeMailDispatcher.dispatchRemainedEvents();
        }
    }

    public static void setInSync(boolean inSync) {
        logger.debug((Object)("inSync: " + inSync));
        GWClient.inSync = inSync;
        if (!inSync && !initialSyncDone) {
            initialSyncDone = true;
        }
    }

    public GWClient() {
        this((String[])null);
    }

    public GWClient(String[] args) {
        this.doPrepThread();
        CommandLineOptions cmdOpts = CommandLineUtils.processCommandLineArgs(args);
        boolean startNotifier = cmdOpts.isNotifier();
        GWClient.migrateAndCleanupOldOptions();
        SettingsMigrator.migrateGlobalSettings();
        LoginParameters params = EngineCommandManager.parseCommandLine(args);
        Locale locale = EngineCommandManager.getLocale();
        if (locale != null) {
            try {
                Locale.setDefault(locale);
                OS.setMyLocale(locale);
                System.setProperty("user.language", locale.getLanguage());
                System.setProperty("user.country", locale.getCountry());
            }
            catch (Exception e) {
                logger.error((Object)e);
                logger.debug((Object)e);
            }
        }
        this.beforeCreating();
        PLAFChanger.changePlafWithSettingsFonts();
        PLAFChanger.bindOptionPaneStrings();
        PLAFChanger.bindFileChooserStrings();
        PLAFChanger.bindColorChooserStrings();
        GWSplash splashWindow = GWSplash.getInstance();
        splashWindow.toFront();
        splashWindow.pack();
        UIUtils.centerWindowOnScreen(splashWindow);
        splashWindow.setVisible(true);
        splashWindow.startConnecting();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GWSplash nlSplash = GWSplash.getNonLocalizedInstance();
                if (nlSplash != null) {
                    nlSplash.dispose();
                }
            }
        });
        GWClient.login(params, splashWindow);
        UIUtils.resetOrientation();
        PLAFChanger.bindOptionPaneStrings();
        if (DevModeUtils.useTestResources()) {
            StringResources.initTestStringResources();
        }
        SettingsMigrator.migrateUserSettings();
        GWClient.syncTimeZoneWithOs();
        splashWindow.stopConnecting();
        GWClient.checkWebRendererVerion();
        if (startNotifier) {
            this.startNotifier(true);
        } else {
            this.startGWClient();
        }
        GWClient.afterCreating(cmdOpts);
        if (this.m_imageThread != null) {
            try {
                while (this.m_imageThread.isPrepThreadRunning()) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private static void syncTimeZoneWithOs() {
        OptionManager optionManager;
        DateTimeOptions dateTimeOptions;
        TimeZone osTimeZone = TimeZone.getDefault();
        if (!osTimeZone.equals((dateTimeOptions = (optionManager = OptionManager.getInstance()).getDateTimeOptions()).getTimeZone())) {
            dateTimeOptions.setTimeZone(osTimeZone);
            dateTimeOptions.setWorkstationTimeZoneLabel("");
            logger.debug((Object)("TimeZone synced with OS and is now:" + osTimeZone));
        }
        optionManager.setDateTimeOptions(dateTimeOptions);
    }

    public static void setNotifyStartedWithClient(boolean notifyStartedWithClient) {
        GWClient.notifyStartedWithClient = notifyStartedWithClient;
    }

    public void startNotifier(boolean showSplashScreen) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("method is executed in event dispatching thread");
        }
        if (notifierRunning) {
            logger.debug((Object)"Notifier is already running.");
            return;
        }
        this.waitUntilNotifyCanStart();
        GWNotify.getInstance().setNotificationsEnabled(true);
        GWSplash splashWindow = null;
        if (showSplashScreen && !(splashWindow = GWSplash.getInstance()).isVisible()) {
            splashWindow.pack();
            UIUtils.centerWindowOnScreen(splashWindow);
            splashWindow.setVisible(true);
            splashWindow.toFront();
        }
        notifyController = new WeakReference<NotifyController>(new NotifyController(this.getLevel()));
        if (showSplashScreen) {
            splashWindow.setVisible(false);
            splashWindow.dispose();
        }
        notifierRunning = true;
    }

    private boolean shouldSyncHappenOnStartup() {
        if (EngineCommandManager.getAccountSettings().isStartupSyncEnabled()) {
            for (Account account : EngineCommandManager.getAccounts()) {
                if (!account.getIncludeInFullRetrieve()) continue;
                return true;
            }
        }
        return false;
    }

    private void waitUntilNotifyCanStart() {
        boolean notifyActionDisabled = false;
        boolean isCachingDataStore = GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).isCachingDataStore();
        while (!initialSyncDone && isCachingDataStore && this.shouldSyncHappenOnStartup()) {
            if (!notifyActionDisabled) {
                notifyActionDisabled = true;
                logger.debug((Object)"disabling Notify actions");
                this.processCommand(new GlobalCommand(1745, false));
            }
            try {
                logger.debug((Object)"waiting for initial sync to complete...");
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (notifyActionDisabled) {
            logger.debug((Object)"enabling Notify actions");
            this.processCommand(new GlobalCommand(1745, true));
        }
    }

    public void startGWClient() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("method is executed in event dispatching thread");
        }
        if (gwClientRunning) {
            logger.debug((Object)"GW Client is already running.");
            return;
        }
        GWSplash splashWindow = GWSplash.getInstance();
        if (!splashWindow.isVisible()) {
            splashWindow.pack();
            UIUtils.centerWindowOnScreen(splashWindow);
            splashWindow.setVisible(true);
            splashWindow.toFront();
            splashWindow.startConnecting();
        }
        TimeZone.setDefault(OptionManager.getInstance().getDateTimeOptions().getTimeZone());
        GWMainAppFrame gwApplicationFrame = new GWMainAppFrame();
        GlobalCommand command = new GlobalCommand(480, gwApplicationFrame);
        ((GWMainAppFrameActionList)gwApplicationFrame.getController()).processCommand(command);
        splashWindow.setVisible(false);
        splashWindow.dispose();
        gwApplicationFrame.showMe();
        gwApplicationFrame.toFront();
        GWClient.setGwClientRunning(true);
        if (GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore().getAutoSavedMessagesCount() > 0) {
            AutoSaveDialog autoSaveDialog = new AutoSaveDialog((GWMainAppFrameActionList)gwApplicationFrame.getController());
            autoSaveDialog.showMe();
        }
        if (!notifierRunning && OptionManager.getInstance().getNotifierOptions().isNotificationEnabled()) {
            Thread notifyLauncher = new Thread(new Runnable(){

                public void run() {
                    notifyStartedWithClient = true;
                    GWClient.this.startNotifier(false);
                }
            });
            notifyLauncher.start();
            try {
                notifyLauncher.join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (notifierRunning) {
            GWClient.getGwClientActionList().processCommand(new GlobalCommand(1720));
        }
    }

    public static boolean isGwClientRunning() {
        return gwClientRunning;
    }

    public static boolean isNotifierRunning() {
        return notifierRunning;
    }

    private static void migrateAndCleanupOldOptions() {
        File oldWRDir;
        File oldSpellDir;
        File oldgwuserXMLfile;
        File oldBasePath;
        boolean stat;
        File basePath = new File(PathManager.getBaseOptionsPath());
        if (!basePath.exists()) {
            stat = basePath.mkdirs();
            logger.debug((Object)("Created new base dir: " + stat));
        }
        if ((oldBasePath = new File(PathManager.OLDOPTIONSPATH)).exists()) {
            File[] list;
            File oldTemp = new File(oldBasePath, "Engine");
            if (oldTemp.exists()) {
                Utils.clearDir(oldTemp);
                stat = oldTemp.delete();
                logger.debug((Object)("Deleted old temp Engine dir: " + stat));
            }
            if ((oldTemp = new File(oldBasePath, "XpGWViews")).exists()) {
                Utils.clearDir(oldTemp);
                stat = oldTemp.delete();
                logger.debug((Object)("Deleted old temp XpGWViews dir: " + stat));
            }
            if ((oldTemp = new File(oldBasePath, ".unknown_user")).exists()) {
                Utils.clearDir(oldTemp);
                stat = oldTemp.delete();
                logger.debug((Object)("Deleted old temp .unknown_user dir: " + stat));
            }
            if ((list = oldBasePath.listFiles()).length == 0) {
                stat = oldBasePath.delete();
                logger.debug((Object)("Deleted old .Groupwise dir: " + stat));
            }
        }
        if ((oldgwuserXMLfile = new File(Utils.USER_HOME + File.separator + ".gwuser.xml")).exists()) {
            File gwuserXMLfile = new File(basePath, "gwuser.xml");
            if (!gwuserXMLfile.exists()) {
                stat = oldgwuserXMLfile.renameTo(gwuserXMLfile);
                logger.debug((Object)("Renamed old .gwuser.xml file to new area: " + stat));
            } else {
                stat = oldgwuserXMLfile.delete();
                logger.debug((Object)("Deleted old .gwuser.xml file: " + stat));
            }
        }
        if ((oldSpellDir = new File(Utils.USER_HOME + File.separator + ".spell" + File.separator)).exists()) {
            File spellDir = new File(basePath, "spell" + File.separator);
            if (!spellDir.exists()) {
                stat = oldSpellDir.renameTo(spellDir);
                logger.debug((Object)("Renamed old .spell dir to new area: " + stat));
            } else {
                File[] oldFiles = oldSpellDir.listFiles();
                for (int i = 0; i < oldFiles.length; ++i) {
                    File oldFile = oldFiles[i];
                    File newFile = new File(spellDir, oldFile.getName());
                    if (newFile.exists()) continue;
                    stat = oldFile.renameTo(newFile);
                    logger.debug((Object)("Moved file (" + oldFile.getName() + ") from old spell dir to new spell dir: " + stat));
                }
                Utils.clearDir(oldSpellDir);
                stat = oldSpellDir.delete();
                logger.debug((Object)("Deleted old .spell dir: " + stat));
            }
        }
        if ((oldWRDir = new File(basePath, ".webrenderer" + File.separator)).exists()) {
            Utils.clearDir(oldWRDir);
            stat = oldWRDir.delete();
            logger.debug((Object)("Deleted old .webrenderer dir: " + stat));
        }
    }

    private static void checkWebRendererVerion() {
        String savedWebRendererVersion = OptionManager.getInstance().getGeneralOptions().getWebRendererVersion();
        String currentWebRendererVersion = GWBrowserFactory.getWebrendererVersion();
        if (currentWebRendererVersion == null) {
            logger.warn((Object)"Incorrect WebRenderer version received: [null]");
        } else if (!currentWebRendererVersion.equals(savedWebRendererVersion)) {
            GWMozillaBrowser.SHOW_WEBRENDERER_ABOUT_DIALOG = true;
        }
    }

    private void beforeCreating() {
        GwAWTErrorHandler.init();
        if (OS.isMacOS()) {
            OSXAdapter.registerMacOSXApplication(this);
            OSXAdapter.enablePrefs(true);
        }
        GWToolTipUI.initialize();
        waitQueue = new WaitCursorEventQueue();
        application = this;
        logger.debug((Object)("awt.toolkit=" + Toolkit.getDefaultToolkit()));
    }

    private static void afterCreating(CommandLineOptions options) {
        Thread gwGarbageCollectorThread = new Thread((Runnable)new GarbageCollector(), "GW GarbageCollector");
        gwGarbageCollectorThread.setDaemon(true);
        gwGarbageCollectorThread.start();
        for (File file : options.getFilesToOpen()) {
            ComposeMailDispatcher.dispatchEvent(new OpenMailEvent(file));
        }
    }

    public static boolean USE_EXTERNAL_HTML_VIEWER() {
        return USE_EXTERNAL_HTML_VIEWER;
    }

    public static GWClientActionList getGwClientActionList() {
        if (gwClientActionList == null) {
            gwClientActionList = new GWClientActionList();
        }
        return gwClientActionList;
    }

    public static Application getApplication() {
        return application;
    }

    public static void logout() {
        logger.debug((Object)"logout entered");
        try {
            EngineCommandManager.logoutUser();
        }
        catch (GWCommandException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        logger.debug((Object)"logout exited");
    }

    private static void login(LoginParameters params, GWSplash splashWindow) {
        try {
            GWUserInfo userInfo = EngineCommandManager.loginUser(params);
            if (userInfo == null) {
                splashWindow.stopConnecting();
                GWClient.EXIT();
            }
            PathManager.deleteUserTempDir();
        }
        catch (GWCommandException e) {
            logger.error((Object)e, (Throwable)e);
            splashWindow.stopConnecting();
            GWClient.EXIT();
        }
    }

    protected void initListeners() {
        Level level = LevelManager.getInstance().getGlobalLevel();
        AppEventListener listener = new SYNC_STARTED_listener();
        AppEventListenerDescriptor descriptor = new AppEventListenerDescriptor(level, 830, listener);
        this.addListenerDescriptor(descriptor);
        listener = new SYNC_FINISHED_listener();
        descriptor = new AppEventListenerDescriptor(level, 840, listener);
        this.addListenerDescriptor(descriptor);
        listener = new SYNC_UPDATE_listener();
        descriptor = new AppEventListenerDescriptor(level, 1220, listener);
        this.addListenerDescriptor(descriptor);
        listener = new SYNC_CANCELED_listener();
        descriptor = new AppEventListenerDescriptor(level, 910, listener);
        this.addListenerDescriptor(descriptor);
        listener = new NEW_WINDOW_CREATED_listener();
        descriptor = new AppEventListenerDescriptor(level, 480, listener);
        this.addListenerDescriptor(descriptor);
        listener = new WINDOW_CLOSED_listener();
        descriptor = new AppEventListenerDescriptor(level, 490, listener);
        this.addListenerDescriptor(descriptor);
    }

    public static void relogin() {
        initialSyncDone = false;
        application.processCommand(new GlobalCommand(930));
        if (Application.closeAllFrames()) {
            boolean restartNotify = false;
            if (notifierRunning) {
                restartNotify = true;
                GWClient.exitNotify();
            }
            GWClient.freeResources();
            GWSplash splashWindow = GWSplash.getInstance();
            splashWindow.pack();
            UIUtils.centerWindowOnScreen(splashWindow);
            splashWindow.setVisible(true);
            splashWindow.startConnecting();
            try {
                EngineCommandManager.relogin();
            }
            catch (Exception e) {
                logger.error((Object)e, (Throwable)e);
                splashWindow.stopConnecting();
                GWClient.EXIT();
            }
            OptionManager.saveAndClear();
            splashWindow.stopConnecting();
            GWMainAppFrame gwApplicationFrame = new GWMainAppFrame();
            GlobalCommand command = new GlobalCommand(480, gwApplicationFrame);
            ((GWMainAppFrameActionList)gwApplicationFrame.getController()).processCommand(command);
            if (restartNotify) {
                new Thread(new Runnable(){

                    public void run() {
                        GWClient client = (GWClient)GWClient.getApplication();
                        client.startNotifier(false);
                    }
                }).start();
            }
            splashWindow.setVisible(false);
            splashWindow.dispose();
            gwApplicationFrame.showMe();
        }
    }

    public static void freeResources() {
        OptionManager.clearOptions();
        OptionManager.freeInstance();
        SelectionManagersFactory.getInstance().clearAll();
        DragManager.getInstance().setItem(null);
        ItemsCache.clear();
        FoldersCache.clear();
        ItemListsCache.clear();
    }

    private static void notifyNewWindow(ApplicationFrame theFrame) {
        for (ApplicationFrame appFrame : appFrames) {
            if (theFrame.equals(appFrame)) continue;
            AbstractAction action = ActionShowWindow.spawnActionForFrame(appFrame);
            GWClient.addWindowMenuItem(theFrame, action);
            action = ActionShowWindow.spawnActionForFrame(theFrame);
            GWClient.addWindowMenuItem(appFrame, action);
        }
    }

    private static void notifyCloseWindow(ApplicationFrame theFrame) {
        for (ApplicationFrame appFrame : appFrames) {
            GWMenu windowMenu;
            if (appFrame.equals(theFrame) || (windowMenu = GWClient.getWindowMenu(appFrame)) == null) continue;
            int nCount = windowMenu.getItemCount();
            for (int j = 3; j < nCount; ++j) {
                Action action = windowMenu.getItem(j).getAction();
                if (action == null || !(action instanceof ActionShowWindow) || !((ActionShowWindow)action).getShowFrame().equals(theFrame)) continue;
                windowMenu.remove(j);
                GWClient.rebuildMenu(windowMenu, theFrame);
                break;
            }
            if (windowMenu.getMenuComponentCount() != 3) continue;
            windowMenu.remove(2);
        }
    }

    private static void rebuildMenu(GWMenu menu, ApplicationFrame frame) {
        int i;
        LinkedList<Action> list = new LinkedList<Action>();
        int size = menu.getMenuComponentCount();
        for (i = 3; i < size; ++i) {
            list.add(((JMenuItem)menu.getMenuComponent(3)).getAction());
            menu.remove(3);
        }
        size = list.size();
        for (i = 0; i < size; ++i) {
            GWClient.addWindowMenuItem(menu, (AbstractAction)list.get(i));
        }
    }

    private static void addWindowMenuItem(ApplicationFrame theFrame, AbstractAction theAction) {
        GWClient.addWindowMenuItem(GWClient.getWindowMenu(theFrame), theAction);
    }

    private static void addWindowMenuItem(GWMenu windowMenu, AbstractAction theAction) {
        if (windowMenu != null) {
            if (windowMenu.getMenuComponentCount() == 2) {
                windowMenu.addSeparator();
            }
            JMenuItem item = OS.createMenuItemForAction(theAction);
            if (theAction instanceof ActionShowWindow && ((ActionShowWindow)theAction).getPreferedTitle() != null) {
                item.setText(((ActionShowWindow)theAction).getPreferedTitle());
            }
            String text = Integer.toString(windowMenu.getMenuComponentCount() - 2) + " " + item.getText();
            item.setText(text);
            item.setComponentOrientation(UIUtils.getComponentOrientation());
            windowMenu.add(item);
        }
    }

    private static GWMenu getWindowMenu(ApplicationFrame theFrame) {
        GWMenuBar menuBar;
        if (theFrame != null && (menuBar = theFrame.getGWMenuBar()) != null) {
            int nCount = menuBar.getMenuCount();
            for (int i = 0; i < nCount; ++i) {
                JMenu bar = menuBar.getMenu(i);
                String strName = bar.getName();
                if (!"Menu Window".equals(strName)) continue;
                return (GWMenu)bar;
            }
        }
        return null;
    }

    public static FrameOpen getOpenFrame(AbstractItem theGWItem) {
        for (ApplicationFrame appFrame : appFrames) {
            if (!(appFrame instanceof FrameOpen) || !((FrameOpen)appFrame).getGwItem().equals(theGWItem)) continue;
            return (FrameOpen)appFrame;
        }
        return null;
    }

    public static FrameCompose getComposeFrame(AbstractItem theGWItem) {
        for (ApplicationFrame appFrame : appFrames) {
            AbstractItem item;
            if (!(appFrame instanceof FrameCompose) || (item = ((FrameCompose)appFrame).getGwItem()) == null || !item.equals(theGWItem)) continue;
            return (FrameCompose)appFrame;
        }
        return null;
    }

    public static String getNovellWebSiteLanguageName() {
        String result = "";
        Locale locale = EngineCommandManager.getLocale();
        String lang = locale.getLanguage();
        String country = locale.getCountry();
        if ("en".equals(lang)) {
            result = "";
        } else if ("zh".equals(lang) && "CN".equals(country)) {
            result = "zh-cn";
        } else if ("zh".equals(lang) && "TW".equals(country)) {
            result = "zh-tw";
        } else if ("da".equals(lang)) {
            result = "da-dk";
        } else if ("fi".equals(lang)) {
            result = "fi-fi";
        } else if ("fr".equals(lang)) {
            result = "fr-fr";
        } else if ("de".equals(lang)) {
            result = "de-de";
        } else if ("it".equals(lang)) {
            result = "it-it";
        } else if ("ja".equals(lang)) {
            result = "ja-jp";
        } else if ("ko".equals(lang)) {
            result = "";
        } else if ("no".equals(lang)) {
            result = "no-no";
        } else if ("pl".equals(lang)) {
            result = "pl-pl";
        } else if ("pt".equals(lang)) {
            result = "pt-br";
        } else if ("ru".equals(lang)) {
            result = "ru-ru";
        } else if ("es".equals(lang)) {
            result = "es-es";
        } else if ("sv".equals(lang)) {
            result = "sv-se";
        } else if ("ar".equals(lang)) {
            result = "";
        } else if ("he".equals(lang) || "iw".equals(lang)) {
            result = "";
        } else if ("cs".equals(lang)) {
            result = "cs-cz";
        } else if ("nl".equals(lang)) {
            result = "nl-nl";
        } else if ("hu".equals(lang)) {
            result = "hu-hu";
        }
        return result;
    }

    public static void main(String[] args) {
        Engine.addUrlListener((Engine.UrlListener)new Engine.UrlListener(){

            public void openUrl(String url) {
                MailToOptions mailTo = new MailToStringParser().createMailToOptions(url);
                ComposeMailDispatcher.dispatchEvent(new MailToEvent(mailTo));
            }
        });
        CommandLineOptions cmdOpts = CommandLineUtils.processCommandLineArgs(args);
        if (cmdOpts.isHelp()) {
            System.out.print(cmdOpts.toString());
            System.exit(0);
        }
        GWSplash nlSplash = GWSplash.getNonLocalizedInstance();
        nlSplash.toFront();
        nlSplash.pack();
        UIUtils.centerWindowOnScreen(nlSplash);
        System.setProperty("swing.aatext", Boolean.toString(cmdOpts.isAAFontsEnabled()));
        USE_EXTERNAL_HTML_VIEWER = cmdOpts.isWREnabled();
        if (GWClient.isRmiEnabled()) {
            if (GWClient.instanceExists()) {
                logger.debug((Object)"GW Client instance exists");
                try {
                    if (cmdOpts.isNotifier()) {
                        logger.debug((Object)"Starting Notifier");
                        rmiClient.getRmiServer().startNotifier();
                    } else if (!Utils.isNullOrEmpty(cmdOpts.getMailTo())) {
                        logger.debug((Object)"Showing ComposeMail form");
                        rmiClient.getRmiServer().showComposeNewMailForm(new MailToStringParser().createMailToOptions(cmdOpts.getMailTo()));
                    } else if (cmdOpts.getFilesToOpen().size() > 0) {
                        logger.debug((Object)"Opening files");
                        rmiClient.getRmiServer().openFiles(cmdOpts.getFilesToOpen());
                    } else {
                        nlSplash.setVisible(true);
                        logger.debug((Object)"Starting GW Client");
                        rmiClient.getRmiServer().startGWClient();
                    }
                }
                catch (RemoteException e) {
                    logger.error((Object)e);
                    logger.debug((Object)e, (Throwable)e);
                }
                catch (RMIException e) {
                    logger.error((Object)e);
                    logger.debug((Object)e, (Throwable)e);
                }
                nlSplash.dispose();
                return;
            }
            nlSplash.setVisible(true);
            try {
                GWClient.initializeRMIServer();
            }
            catch (Exception e) {
                // empty catch block
            }
            SSLSetup.overrideTrustManager();
            new GWClient(args);
        } else {
            nlSplash.setVisible(true);
            SSLSetup.overrideTrustManager();
            new GWClient(args);
        }
        nlSplash.dispose();
        if (cmdOpts.getMailTo().length() != 0) {
            MailToOptions mailTo = new MailToStringParser().createMailToOptions(cmdOpts.getMailTo());
            ComposeMailDispatcher.dispatchEvent(new MailToEvent(mailTo));
        }
    }

    private static void initializeRMIServer() {
        if (!GWClient.isRmiEnabled()) {
            return;
        }
        rmiServer = new GWClientRMIServer();
        logger.debug((Object)"Try to initialise RMI Server");
        try {
            rmiServer.initialise();
        }
        catch (RMIException e) {
            logger.debug((Object)("Unable to create RMI Server " + e.getMessage()));
        }
        logger.debug((Object)"RMI Server is Initialized");
    }

    private static boolean isRmiEnabled() {
        return CommandLineOptions.getOptions().isRmiEnabled();
    }

    private static boolean instanceExists() {
        GWClientRMIClient client = new GWClientRMIClient();
        try {
            client.initialise();
            logger.debug((Object)"One instance of GWClient is already started in system...");
            rmiClient = client;
        }
        catch (RMIException e) {
            logger.debug((Object)("GWClient is not started in this system." + e.getMessage()));
            return false;
        }
        return true;
    }

    private static void performNotifyExit() {
        assert (notifierRunning);
        assert (SwingUtilities.isEventDispatchThread());
        logger.debug((Object)"firing EXITING_NOTIFY...");
        GWClient.getApplication().processCommand(new GlobalCommand(1480));
        logger.debug((Object)"...EXITING_NOTIFY processed");
        if (notifyController != null && notifyController.get() != null) {
            LevelManager.getInstance();
            LevelManager.release(((NotifyController)notifyController.get()).getLevel());
            logger.debug((Object)"NotifyController released");
        }
        notifierRunning = false;
        notifyController = null;
        GWClient.processNotifyOrClientExited();
    }

    private static void performClientExit() {
        assert (gwClientRunning);
        assert (SwingUtilities.isEventDispatchThread());
        GWClient.setGwClientRunning(false);
        if (notifierRunning) {
            if (notifyStartedWithClient) {
                GWClient.performNotifyExit();
                return;
            }
            GWClient.getGwClientActionList().processCommand(new GlobalCommand(1710));
        }
        GWClient.processNotifyOrClientExited();
    }

    private static void performNotifyAndClientExit() {
        assert (gwClientRunning || notifierRunning);
        assert (SwingUtilities.isEventDispatchThread());
        if (notifierRunning) {
            GWClient.performNotifyExit();
        }
        if (gwClientRunning) {
            GWClient.performClientExit();
        }
    }

    private static void processNotifyOrClientExited() {
        logger.debug((Object)("Client running: " + gwClientRunning + ", Notifier running: " + notifierRunning));
        if (!notifierRunning && !gwClientRunning) {
            logger.debug((Object)"doExit entered");
            Thread closer = new Thread((Runnable)new Closer(), "GW Closer");
            closer.setDaemon(false);
            closer.start();
            logger.debug((Object)"doExit exited");
        }
    }

    public static void exitNotify() {
        if (!notifierRunning) {
            logger.warn((Object)"Notify is not running");
            return;
        }
        logger.debug((Object)((SwingUtilities.isEventDispatchThread() ? "" : "not ") + "EDT"));
        if (SwingUtilities.isEventDispatchThread()) {
            GWClient.performNotifyExit();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWClient.performNotifyExit();
                }
            });
        }
    }

    public static void exitClient() {
        if (!gwClientRunning) {
            logger.warn((Object)"Client is not running");
            return;
        }
        logger.debug((Object)((SwingUtilities.isEventDispatchThread() ? "" : "not ") + "EDT"));
        if (SwingUtilities.isEventDispatchThread()) {
            GWClient.performClientExit();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWClient.performClientExit();
                }
            });
        }
    }

    public static void exitAll() {
        logger.debug((Object)((SwingUtilities.isEventDispatchThread() ? "" : "not ") + "EDT"));
        if (SwingUtilities.isEventDispatchThread()) {
            GWClient.performNotifyAndClientExit();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    GWClient.performNotifyAndClientExit();
                }
            });
        }
    }

    public static void openEmlFile(File theFile) {
        AppAction appAction = GWClient.getGwClientActionList().getAction(ActionKey.OPEN_EML_ITEM);
        appAction.setMVCModel(theFile);
        GWClient.getGwClientActionList().performAction(ActionKey.OPEN_EML_ITEM);
    }

    public static void actionPreferences() {
        if (notifierRunning && !gwClientRunning) {
            assert (notifyController != null);
            NotifyController notifyController = (NotifyController)GWClient.notifyController.get();
            assert (notifyController != null);
            notifyController.getNotifyActionList().performAction(ActionKey.DISPLAY_NOTIFY_OPTIONS);
        } else if (GWClient.getActiveFrame() != null) {
            ((ActionList)GWClient.getActiveFrame().getController()).performAction(ActionKey.OPTIONS);
        } else {
            ((GWMainAppFrameActionList)GWClient.getLastActiveMainFrame().getController()).performAction(ActionKey.OPTIONS);
        }
    }

    public static NotifyController getNotifyController() {
        if (notifyController != null) {
            return (NotifyController)notifyController.get();
        }
        return null;
    }

    public static void actionExit() {
        GWClient.getGwClientActionList().performAction(ActionKey.EXIT);
    }

    public static void composeMail(MailToOptions mailTo) {
        logger.info((Object)"Performing compose mail action for mailto: ...");
        ActionNewMail actionNewMail = new ActionNewMail((ActionList)Application.getLastActiveMainFrame().getController());
        List<IRecipient> toRcp = ControlsUtils.convertToRecipientsList(mailTo.getToListAsString(), RecipientCopyType.getTo());
        List<IRecipient> ccRcp = ControlsUtils.convertToRecipientsList(mailTo.getCcListAsString(), RecipientCopyType.getCc());
        List<IRecipient> bcRcp = ControlsUtils.convertToRecipientsList(mailTo.getBccListAsString(), RecipientCopyType.getBc());
        actionNewMail.setToRecipients(toRcp);
        actionNewMail.setCCRecipients(ccRcp);
        actionNewMail.setBCRecipients(bcRcp);
        actionNewMail.setSubject(mailTo.getSubject());
        actionNewMail.setMessage(mailTo.getBody());
        actionNewMail.setAttachments(mailTo.getAttachments());
        actionNewMail.actionPerformed(null);
    }

    public static void composeMail(String toRecipients, String[] attachments) {
        logger.info((Object)"Performing compose mail action...");
        ActionNewMail actionNewMail = new ActionNewMail(Application.getGWMainAppFrame().getAppActionList());
        List<IRecipient> recipients = ControlsUtils.convertToRecipientsList(toRecipients, RecipientCopyType.getTo());
        actionNewMail.setToRecipients(recipients);
        actionNewMail.actionPerformed(null);
        int nSize = attachments.length;
        ArrayList<File> files = new ArrayList<File>(attachments.length);
        for (int i = 0; i < nSize; ++i) {
            String attachment = attachments[i];
            File file = new File(attachment);
            if (!file.isFile()) continue;
            files.add(file);
        }
    }

    public static void EXIT() {
        logger.debug((Object)"EXIT entered");
        waitQueue.shutdown();
        PathManager.deleteUserTempDir();
        System.gc();
        System.runFinalization();
        System.gc();
        if (DevModeUtils.isSoftExit()) {
            GWClient.exitSoftly();
        } else {
            logger.debug((Object)"EXIT exiting...");
            logger.debug((Object)"JVM exiting...");
            System.exit(0);
        }
    }

    private static void exitSoftly() {
        Frame[] frames;
        logger.debug((Object)"EXITING SOFTLY");
        for (Frame frame : frames = Frame.getFrames()) {
            logger.debug((Object)("disposing frame: " + frame));
            frame.dispose();
        }
    }

    private void doPrepThread() {
        this.m_imageThread = new PrepThread();
        this.m_imageThread.start();
    }

    static {
        gwClientRunning = false;
        notifierRunning = false;
        notifyController = null;
        notifyStartedWithClient = false;
        performingExit = false;
        inSync = false;
        initialSyncDone = false;
        rmiServer = null;
    }

    private class PrepThread
    extends Thread {
        private boolean m_bPrepRunning = false;

        PrepThread() {
        }

        public boolean isPrepThreadRunning() {
            return this.m_bPrepRunning;
        }

        public void run() {
            this.m_bPrepRunning = true;
            ImageResources.init();
            UIUtils.getSystemFonts();
            JAI.getDefaultInstance().getTileCache().setMemoryCapacity(8000000L);
            this.m_bPrepRunning = false;
        }
    }

    private static class WINDOW_CLOSED_listener
    extends AppEventListener {
        private WINDOW_CLOSED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ApplicationFrame applicationFrame = (ApplicationFrame)theEvent.getData();
            GWClient.notifyCloseWindow(applicationFrame);
            try {
                GWCommandManager.removeFrameRef(applicationFrame.getUserGuid());
            }
            catch (Exception e) {
                logger.warn((Object)("Exception " + e.toString() + " in WINDOW_CLOSED_listener"));
            }
        }
    }

    private static class NEW_WINDOW_CREATED_listener
    extends AppEventListener {
        private NEW_WINDOW_CREATED_listener() {
        }

        public void handle(AppEvent theEvent) {
            ApplicationFrame applicationFrame = (ApplicationFrame)theEvent.getData();
            GWClient.notifyNewWindow(applicationFrame);
            GWCommandManager.addFrameRef(applicationFrame.getUserGuid());
        }
    }

    private static class SYNC_CANCELED_listener
    extends AppEventListener {
        private SYNC_CANCELED_listener() {
        }

        public synchronized void handle(AppEvent theEvent) {
            int nSize = appFrames.size();
            for (int i = 0; i < nSize; ++i) {
                ApplicationFrame frame = (ApplicationFrame)appFrames.get(i);
                if (!(frame instanceof GWMainAppFrame)) continue;
                GWMainAppFrame mainFrame = (GWMainAppFrame)frame;
                mainFrame.stopStatusAnimation();
                mainFrame.setStatusText("");
                if (EngineCommandManager.getCurrentMode() != EngineMode.CACHING) continue;
                mainFrame.setStatusText(Account.getLastConnectedMsg());
            }
        }
    }

    private static class SYNC_FINISHED_listener
    extends AppEventListener {
        private SYNC_FINISHED_listener() {
        }

        public synchronized void handle(AppEvent theEvent) {
            Boolean commandObject = (Boolean)theEvent.getData();
            boolean successfuly = commandObject;
            int nSize = appFrames.size();
            for (int i = 0; i < nSize; ++i) {
                ApplicationFrame frame = (ApplicationFrame)appFrames.get(i);
                if (!(frame instanceof GWMainAppFrame)) continue;
                GWMainAppFrame mainFrame = (GWMainAppFrame)frame;
                if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING) {
                    mainFrame.stopStatusAnimation();
                    mainFrame.setStatusText(Account.getLastConnectedMsg());
                    continue;
                }
                if (successfuly) {
                    mainFrame.stopStatusAnimation();
                    mainFrame.setStatusText("");
                    continue;
                }
                mainFrame.setStatusText(StringResources.ERROR_DURING_UPDATING_MAILBOX);
            }
        }
    }

    private static class SYNC_UPDATE_listener
    extends AppEventListener {
        private SYNC_UPDATE_listener() {
        }

        public synchronized void handle(AppEvent theEvent) {
            int nSize = appFrames.size();
            for (int i = 0; i < nSize; ++i) {
                ApplicationFrame frame = (ApplicationFrame)appFrames.get(i);
                if (!(frame instanceof GWMainAppFrame)) continue;
                GWMainAppFrame mainFrame = (GWMainAppFrame)frame;
                mainFrame.setStatusText(theEvent.getData().toString());
            }
        }
    }

    private static class SYNC_STARTED_listener
    extends AppEventListener {
        private SYNC_STARTED_listener() {
        }

        public synchronized void handle(AppEvent theEvent) {
            int nSize = appFrames.size();
            for (int i = 0; i < nSize; ++i) {
                ApplicationFrame frame = (ApplicationFrame)appFrames.get(i);
                if (!(frame instanceof GWMainAppFrame)) continue;
                GWMainAppFrame mainFrame = (GWMainAppFrame)frame;
                mainFrame.startStatusAnimation(ImageResources.ICON_UPDATING_CACHING, StringResources.ICON_UPDATING_CACHING, new ClickAction(){

                    public void click() {
                        EngineCommandManager.getCallBackListener().getSyncFrame().switchView();
                    }
                });
            }
        }
    }

    static class GarbageCollector
    implements Runnable {
        GarbageCollector() {
        }

        public void run() {
            try {
                while (GWClient.isGwClientRunning() || GWClient.isNotifierRunning()) {
                    Thread.sleep(30000L);
                    System.runFinalization();
                    System.gc();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                logger.error((Object)e, (Throwable)e);
            }
        }
    }

    private static class Closer
    implements Runnable {
        private Closer() {
        }

        public void run() {
            logger.debug((Object)"CLOSER ENTERED");
            GWClient.setperformingExit(true);
            ApplicationOptions.getInstance().saveChanges();
            try {
                OptionManager.getInstance();
                OptionManager.save();
            }
            catch (GWCommandException e) {
                logger.debug((Object)e);
            }
            APIFactory.getEngine().cancelSync();
            GWClient.getApplication().processCommand(new GlobalCommand(910));
            while (GWClient.isInSync()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            logger.debug((Object)"sync done");
            if (EngineCommandManager.canExit()) {
                application.processCommand(new GlobalCommand(930));
                if (Application.closeAllFrames()) {
                    if (GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).isCachingDataStore()) {
                        GWCommandManager.getInstance(EngineCommandManager.getUserGuid()).performBackupOnDB(false, true);
                    }
                    GWClient.freeResources();
                    GWClient.logout();
                    logger.debug((Object)"CLOSER EXITED JVM WILL CLOSE");
                    if (USE_EXTERNAL_HTML_VIEWER) {
                        Runtime.getRuntime().addShutdownHook(new Thread(){

                            public void run() {
                                logger.debug((Object)"Executing shutdown hook...");
                                GWBrowserFactory.destroySpawnedBrowsers();
                                logger.debug((Object)"Shutdown hook finished");
                            }
                        });
                    }
                    GWClient.EXIT();
                } else {
                    GWClient.setGwClientRunning(true);
                }
            }
            GWClient.setperformingExit(false);
        }
    }
}

