/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.plaf.PLAFChanger;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StartupImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.log4j.Logger;

public class GWSplash
extends JFrame {
    private static Logger logger = Logger.getLogger(GWSplash.class);
    private static GWSplash instance = null;
    private static GWSplash m_nonLocalizedInst = null;
    private JLabel imageLabel;
    private JLabel textLabel;
    private Timer pointsTimer;
    private String text;
    private StringBuffer textBuffer = new StringBuffer(100);
    private boolean isLeftToRight = true;

    public static GWSplash getInstance() {
        if (instance == null) {
            instance = new GWSplash();
        }
        return instance;
    }

    public static GWSplash getNonLocalizedInstance() {
        if (m_nonLocalizedInst == null) {
            m_nonLocalizedInst = new GWSplash("", true);
        }
        return m_nonLocalizedInst;
    }

    public GWSplash(String str, boolean bNonLocalized) {
        super(str);
        this.setUndecorated(true);
        this.setIconImage(ImageResources.GW_ICON.getImage());
        try {
            String strBase = bNonLocalized ? "GW_Splash-nonlocalized" : "GW_Splash";
            this.imageLabel = new JLabel(StartupImageResources.getIcon(strBase + ".png"));
        }
        catch (IOException e) {
            // empty catch block
        }
        this.textLabel = new JLabel();
        this.textLabel.setPreferredSize(new Dimension(15, 15));
        this.textLabel.setBackground(Color.WHITE);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBackground(Color.WHITE);
        contentPane.add((Component)this.imageLabel, "Center");
        contentPane.add((Component)this.textLabel, "South");
    }

    private GWSplash() {
        super(StringResources.GROUPWISE_CLIENT + " ");
        this.setUndecorated(true);
        this.setIconImage(ImageResources.GW_ICON.getImage());
        ComponentOrientation co = UIUtils.getComponentOrientation();
        this.isLeftToRight = co.isLeftToRight();
        this.imageLabel = new OrientableLabel(ControlsUtils.getSplashImage());
        this.textLabel = new OrientableLabel();
        this.textLabel.setComponentOrientation(co);
        this.textLabel.setPreferredSize(new Dimension(15, PLAFChanger.getFontSize() + 3));
        this.textLabel.setFont(new Font(PLAFChanger.getFontName(), 0, PLAFChanger.getFontSize() - 2));
        this.textLabel.setBackground(Color.WHITE);
        this.textLabel.setForeground(Color.RED);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBackground(Color.WHITE);
        contentPane.add((Component)this.imageLabel, "Center");
        contentPane.add((Component)this.textLabel, "South");
        this.pointsTimer = new Timer(1000, new TimerListener());
    }

    public void startConnecting() {
        if (SwingUtilities.isEventDispatchThread()) {
            new SetTextRunner().run();
        } else {
            try {
                SwingUtilities.invokeAndWait(new SetTextRunner());
            }
            catch (Exception e) {
                logger.debug((Object)e, (Throwable)e);
            }
        }
        this.pointsTimer.start();
    }

    public void stopConnecting() {
        this.pointsTimer.stop();
    }

    private synchronized void initTextLabel() {
        this.textBuffer.delete(0, this.textBuffer.length());
        this.text = StringResources.CONNECTING;
        this.textLabel.setText(this.text);
    }

    private synchronized void addPoint() {
        if (this.isLeftToRight) {
            this.textBuffer.append(' ');
            this.textBuffer.append('.');
            this.textBuffer.append(' ');
        } else {
            this.textBuffer.insert(0, ' ');
            this.textBuffer.insert(0, '.');
            this.textBuffer.insert(0, ' ');
        }
    }

    private synchronized void updateProgressLabel() {
        this.addPoint();
        FontMetrics fm = this.textLabel.getFontMetrics(this.textLabel.getFont());
        String string = this.textBuffer.toString();
        string = this.text + string;
        if (this.textLabel.getWidth() > fm.stringWidth(string)) {
            this.textLabel.setText(string);
        } else {
            this.initTextLabel();
        }
    }

    public void dispose() {
        try {
            this.finalize();
        }
        catch (Throwable throwable) {
            logger.error((Object)throwable, throwable);
        }
        super.dispose();
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        public void actionPerformed(ActionEvent e) {
            GWSplash.this.updateProgressLabel();
        }
    }

    private class SetTextRunner
    implements Runnable {
        private SetTextRunner() {
        }

        public void run() {
            GWSplash.this.initTextLabel();
        }
    }
}

