/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceMotionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

public class GhostComponent {
    private Component component;
    private Component dndTarget;
    private JLayeredPane layeredPane;
    private JComponent painter;
    private Point dragOrigin;
    private ImageIcon icon;
    private List<Component> bufferedComponents = new LinkedList<Component>();
    private Transferable transferData;
    private int dnDActions;
    private DragSourceMotionListener dragSourceMotionListener = new DSListener();

    public GhostComponent(Component component, Transferable transferData, int dnDActions, Component dndTarget) {
        this.transferData = transferData;
        this.dnDActions = dnDActions;
        this.component = component;
        this.dndTarget = dndTarget;
        this.icon = new ImageIcon(this.component);
        this.init();
    }

    public GhostComponent(Component component, Transferable transferData, int dnDActions) {
        this(component, transferData, dnDActions, component);
    }

    private void init() {
        this.painter = new JComponent(){

            public void paint(Graphics g) {
                ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.3f));
                GhostComponent.this.icon.paintIcon(this, g, 0, 0);
            }
        };
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this.dndTarget, this.dnDActions, new DGListener());
    }

    private void setDoubleBuffered(Component component, boolean b) {
        if (component instanceof Container) {
            Component[] components;
            for (Component comp : components = ((Container)component).getComponents()) {
                this.setDoubleBuffered(comp, b);
            }
            if (component instanceof JComponent) {
                boolean doubleBuffered = component.isDoubleBuffered();
                if (b) {
                    if (this.bufferedComponents.contains(component)) {
                        ((JComponent)component).setDoubleBuffered(b);
                        this.bufferedComponents.remove(component);
                    }
                } else if (doubleBuffered) {
                    ((JComponent)component).setDoubleBuffered(b);
                    this.bufferedComponents.add(component);
                }
            }
        }
    }

    private void initLayeredPane() {
        Window window = SwingUtilities.getWindowAncestor(this.component);
        if (window instanceof RootPaneContainer) {
            this.layeredPane = ((RootPaneContainer)((Object)window)).getLayeredPane();
        }
        this.layeredPane.add(this.painter, JLayeredPane.DRAG_LAYER, 0);
    }

    private static class ImageIcon
    implements Icon {
        private Component component;

        public ImageIcon(Component component) {
            this.component = component;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.component.paint(g.create(x, y, this.getIconWidth(), this.getIconHeight()));
        }

        public int getIconWidth() {
            return this.component.getWidth();
        }

        public int getIconHeight() {
            return this.component.getHeight();
        }
    }

    private class DGListener
    implements DragGestureListener {
        private DGListener() {
        }

        public void dragGestureRecognized(DragGestureEvent dge) {
            GhostComponent.this.dragOrigin = dge.getDragOrigin();
            if ((dge.getDragAction() & GhostComponent.this.dnDActions) != 0) {
                GhostComponent.this.initLayeredPane();
                GhostComponent.this.setDoubleBuffered(GhostComponent.this.component, false);
                dge.startDrag(DragSource.DefaultCopyNoDrop, GhostComponent.this.transferData, new DSListener());
                dge.getDragSource().addDragSourceMotionListener(GhostComponent.this.dragSourceMotionListener);
            }
        }
    }

    private class DSListener
    extends DragSourceAdapter {
        int x;
        int y;

        private DSListener() {
        }

        public void dragMouseMoved(DragSourceDragEvent dsde) {
            Point loc = GhostComponent.this.layeredPane.getLocationOnScreen();
            this.x = dsde.getX() - loc.x - ((GhostComponent)GhostComponent.this).dragOrigin.x;
            this.y = dsde.getY() - loc.y - ((GhostComponent)GhostComponent.this).dragOrigin.y;
            GhostComponent.this.painter.setLocation(this.x, this.y);
            GhostComponent.this.painter.setSize(GhostComponent.this.component.getWidth(), GhostComponent.this.component.getHeight());
            GhostComponent.this.painter.repaint();
        }

        public void dragDropEnd(DragSourceDropEvent dsde) {
            GhostComponent.this.painter.setSize(0, 0);
            GhostComponent.this.layeredPane.repaint();
            dsde.getDragSourceContext().getDragSource().removeDragSourceMotionListener(GhostComponent.this.dragSourceMotionListener);
            GhostComponent.this.layeredPane.remove(GhostComponent.this.painter);
            GhostComponent.this.setDoubleBuffered(GhostComponent.this.component, true);
            GhostComponent.this.bufferedComponents.clear();
        }
    }
}

