/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.Application;
import com.appframework.ApplicationFrame;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.novell.gw.engine.ItemListEvent;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.IItemListListener;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionPrevItem;
import com.novell.gw.jclient.application.actions.componentrelated.ActionMessageTable;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.interfaces.ISelectedItemsInfo;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public abstract class AbstractNavigationAction
extends AppAction
implements ActionMessageTable {
    private static Logger logger = Logger.getLogger(ActionPrevItem.class);
    private NavigationActionItemListener listener = new NavigationActionItemListener();
    private MVCController parentMainFrameController;
    private WeakReference<IItemList> itemList;

    protected AbstractNavigationAction(ActionList actionList, ActionKey actionKey, String name, Icon icon) {
        super(actionList, actionKey, name, icon);
        this.setEnabled(false);
    }

    protected void updateViewFrame(AbstractItem item, AbstractItem nextItem) {
        MessageUtils.doOpenItem(this.getItemList(), nextItem, false, ControlsUtils.getUserGuid(this.getController()));
        Application.disposeFrame(item);
    }

    protected void updateSelection(AbstractItem theItem) {
        MVCController controller = Application.getGWMainAppFrame().getController();
        if (controller != null) {
            Command command = new Command(870, theItem);
            controller.processCommand(command);
        }
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 20, new GWITEM_SELECTED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1070, new MAINFRAME_CONTROLLER_SELECTED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 490, new WINDOW_CLOSED_Listener()));
    }

    public abstract void checkEnabled();

    private void setParentMainFrameController(MVCController theController) {
        this.parentMainFrameController = theController;
        this.checkEnabled();
    }

    protected MVCController getParentMainFrameController() {
        return this.parentMainFrameController;
    }

    public IItemList getItemList() {
        return this.itemList == null ? null : (IItemList)this.itemList.get();
    }

    public void setItemList(IItemList itemList) {
        IItemList oldItemList = this.getItemList();
        if (oldItemList != null) {
            oldItemList.removeItemListListener(this.listener);
        }
        this.itemList = new WeakReference<IItemList>(itemList);
        if (itemList != null) {
            itemList.addItemListListener(this.listener);
        }
    }

    private class WINDOW_CLOSED_Listener
    extends AppEventListener {
        private WINDOW_CLOSED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ApplicationFrame frame = (ApplicationFrame)theEvent.getData();
            if (AbstractNavigationAction.this.getActionList().getMVCView() != frame) {
                return;
            }
            if (frame.getController() == null) {
                return;
            }
            Level frameLevel = frame.getController().getLevel();
            AbstractNavigationAction.this.setItemList(null);
            if (AbstractNavigationAction.this.getParentMainFrameController() != null && AbstractNavigationAction.this.getParentMainFrameController().getLevel().equals(frameLevel)) {
                AbstractNavigationAction.this.setParentMainFrameController(null);
            }
        }
    }

    private class NavigationActionItemListener
    implements IItemListListener {
        private NavigationActionItemListener() {
        }

        public void contentsChanged(ItemListEvent e) {
            AbstractNavigationAction.this.checkEnabled();
        }

        public void moreResultsAvailable(ItemListEvent e) {
            AbstractNavigationAction.this.checkEnabled();
        }

        public void queryResultsDone(ItemListEvent e) {
            AbstractNavigationAction.this.checkEnabled();
        }

        public void notifyEmptyList(ItemListEvent e) {
            AbstractNavigationAction.this.checkEnabled();
        }
    }

    private class MAINFRAME_CONTROLLER_SELECTED_Listener
    extends AppEventListener {
        private MAINFRAME_CONTROLLER_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractNavigationAction.this.setParentMainFrameController((MVCController)theEvent.getData());
        }
    }

    private class GWITEM_SELECTED_Listener
    extends AppEventListener {
        private GWITEM_SELECTED_Listener() {
        }

        public void handle(AppEvent event) {
            ISelectedItemsInfo itemsInfo;
            Object model = event.getData();
            if (model != null && (itemsInfo = (ISelectedItemsInfo)model).hasItemList()) {
                AbstractNavigationAction.this.setItemList(itemsInfo.getItemList());
                if (itemsInfo.hasItems()) {
                    AbstractNavigationAction.this.setMVCModel(itemsInfo.getItem());
                } else {
                    AbstractNavigationAction.this.setMVCModel(null);
                }
                AbstractNavigationAction.this.checkEnabled();
            }
        }
    }
}

