/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.application.actions.AbstractAddressBookAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ActionNewCalendarItem;
import com.novell.gw.jclient.application.controls.gwcalendar.GWCalendarUtils;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import java.util.Date;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNewCalendarItemAction<T extends AbstractCalendarItem>
extends AbstractAddressBookAction
implements ActionNewCalendarItem {
    private boolean calendarView;
    private Date selectedDate;

    protected AbstractNewCalendarItemAction(ActionList actionList, ActionKey actionKey, String name, Icon icon) {
        super(actionList, actionKey, name, icon);
    }

    protected AbstractNewCalendarItemAction(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        ActionNewCalendarItem.NewCalendarItemListener listener = new ActionNewCalendarItem.NewCalendarItemListener(this);
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 70, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 10, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1860, listener));
    }

    protected void applyInitialDates(T newItem) {
        int duratioMin = (Integer)EngineCommandManager.getInstance(EngineCommandManager.getUserGuid()).getCurrentDataStore().getSettings().getAppointmentDefaultLength().getValue();
        if (this.isCalendarView() && this.getSelectedDate() != null) {
            Date startDate = GWCalendarUtils.roundAppointmentStartDate(this.getSelectedDate());
            ((AbstractCalendarItem)newItem).setStartDates(new Date[]{startDate});
            ((AbstractCalendarItem)newItem).setEndDate(new Date(startDate.getTime() + (long)(duratioMin * 60 * 1000)));
        }
    }

    @Override
    public boolean isCalendarView() {
        return this.calendarView;
    }

    @Override
    public void setCalendarView(boolean theCalendarView) {
        this.calendarView = theCalendarView;
    }

    @Override
    public Date getSelectedDate() {
        return this.selectedDate;
    }

    @Override
    public void setSelectedDate(Date theSelectedDate) {
        this.selectedDate = theSelectedDate;
    }
}

