/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.DevModeUtils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ActionAttachFile
extends AppAction {
    private File lastSelectedFile = null;

    public ActionAttachFile(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.ATTACH_FILE, StringResources.ATTACH_FILE_D, ImageResources.ICON_ACT_ATTACH);
        this.setToolTipText(StringResources.DESCRIPTION_ATTACH_FILE);
        this.setAccelerator(KeyStroke.getKeyStroke(76, OS.getMetaKey()));
    }

    protected void performAction(ActionEvent e) {
        ApplicationFrame frame = (ApplicationFrame)this.getActionList().getMVCView();
        if (OS.isMacOS() && !DevModeUtils.isFestRunning()) {
            GWMacFileChooser fileChoser = new GWMacFileChooser((Frame)frame, StringResources.ATTACH_FILE, this.lastSelectedFile, 0);
            UIUtils.centerWindow((Window)fileChoser, frame);
            fileChoser.setVisible(true);
            String selectedFile = fileChoser.getFile();
            if (selectedFile != null) {
                String selecteddirectory = fileChoser.getDirectory();
                this.lastSelectedFile = new File(selecteddirectory + selectedFile);
                if (!this.lastSelectedFile.exists()) {
                    ActionAttachFile.showError(frame, selectedFile);
                } else {
                    File[] selectedFiles = new File[]{this.lastSelectedFile};
                    this.getController().processCommand(new Command(760, Arrays.asList(selectedFiles)));
                }
            }
        } else {
            GWFileChooser fileChoser = new GWFileChooser(frame, StringResources.ATTACH_FILE, this.lastSelectedFile, 0, 0, true);
            UIUtils.centerWindow((Window)fileChoser, frame);
            fileChoser.getChooser().setApproveButtonText(StringResources.OK);
            fileChoser.pack();
            fileChoser.setVisible(true);
            if (!fileChoser.isCanceled() && fileChoser.getResult() != null) {
                String[] fileNames = fileChoser.getResult();
                if (fileNames != null && fileNames.length > 0) {
                    File[] selectedFiles = fileChoser.getChooser().getSelectedFiles();
                    for (int i = 0; i < selectedFiles.length; ++i) {
                        File selectedFile = selectedFiles[i];
                        if (selectedFile.exists()) continue;
                        ActionAttachFile.showError(frame, selectedFile.getName());
                    }
                    this.lastSelectedFile = selectedFiles[selectedFiles.length - 1].getParentFile();
                    this.getController().processCommand(new Command(760, Arrays.asList(selectedFiles)));
                } else {
                    ActionAttachFile.showError(frame, "");
                }
            }
        }
    }

    private static void showError(ApplicationFrame frame, String selectedFile) {
        JOptionPane.showMessageDialog(frame, selectedFile + '\n' + StringResources.FILE_NOT_FOUND);
    }

    public boolean showWithText() {
        return false;
    }
}

