/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.components.customizedbutton.listpopuppane.HeaderGradientButton;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.DataStoreAccessRequestType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.application.actions.AbstractAddressBookAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ToolbarGradientComponent;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.controls.itemedit.ItemEditPanel;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposeMail;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.ItemNotCreatedException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MailItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionNewMail
extends AbstractAddressBookAction
implements ToolbarGradientComponent {
    private static Logger logger = Logger.getLogger(ActionNewMail.class);
    private List toRecipients;
    private List ccRecipients;
    private List bcRecipients;
    private String subject;
    private String message;
    private List<File> attachments;

    public ActionNewMail(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.NEW_MAIL, StringResources.ACTION_MAIL, ImageResources.ICON_ACT_NEW_MAIL);
        this.setToolTipText(StringResources.DESCRIPTION_NEW_MAIL);
        this.setAccelerator(KeyStroke.getKeyStroke(77, OS.getMetaKey()));
    }

    public void setToRecipients(List theToRecipients) {
        this.toRecipients = theToRecipients;
    }

    public void setCCRecipients(List theCcRecipients) {
        this.ccRecipients = theCcRecipients;
    }

    public void setBCRecipients(List theBcRecipients) {
        this.bcRecipients = theBcRecipients;
    }

    public void setSubject(String theSubject) {
        this.subject = theSubject;
    }

    public void setMessage(String theMessage) {
        this.message = theMessage;
    }

    public void setAttachments(List<File> attachments) {
        this.attachments = attachments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void performAction(ActionEvent e) {
        if (!this.validateRecipients()) {
            return;
        }
        try {
            MessageUtils.showBusyCursor(true);
            AbstractItem newMail = GWCommandManager.getInstance(this.getUserGuid()).composeNewItem(MailItem.class);
            FrameComposeMail frameCompose = new FrameComposeMail(newMail, true, ComposeMode.NEW, this.getUserGuid());
            frameCompose.getItemEdit().setSendingFromAddressBook(this.isSendingFromAddressBook);
            this.sendRecipients(frameCompose);
            this.applyPredefinedFields(frameCompose.getItemEdit());
            this.cleanPredefinedFields();
            frameCompose.showMe();
            GlobalCommand command = new GlobalCommand(480, frameCompose);
            ((FrameComposeActionList)frameCompose.getController()).processCommand(command);
        }
        catch (ItemNotCreatedException ex) {
        }
        catch (GWCommandException e1) {
            logger.error((Object)e1, (Throwable)e1);
            ErrorDialog.processGWException(e1);
        }
        finally {
            MessageUtils.showBusyCursor(false);
        }
    }

    private void cleanPredefinedFields() {
        this.toRecipients = null;
        this.ccRecipients = null;
        this.bcRecipients = null;
        this.subject = null;
        this.message = null;
    }

    private void applyPredefinedFields(ItemEditPanel itemEdit) {
        if (this.toRecipients != null) {
            itemEdit.setTo(this.toRecipients);
        }
        if (this.ccRecipients != null) {
            itemEdit.setCC(this.ccRecipients);
        }
        if (this.bcRecipients != null) {
            itemEdit.setBC(this.bcRecipients);
        }
        if (this.subject != null) {
            itemEdit.setSubject(this.subject);
        }
        if (this.message != null) {
            itemEdit.setMessage(this.message);
        }
        if (this.attachments != null && !this.attachments.isEmpty()) {
            itemEdit.addFileAttachments(this.attachments);
        }
    }

    @Override
    public JComponent getToolBarComponent() {
        ListPopupPane buttons = new ListPopupPane(this, StringResources.NEW_MAIL);
        buttons.setToolTipText(this.getToolTipText());
        buttons.addAction(this.getActionList().getAction(ActionKey.NEW_POSTED_MAIL));
        buttons.addSeparator();
        buttons.addAction(this.getActionList().getAction(ActionKey.NEW_MAIL), StringResources.MAIL);
        return buttons;
    }

    @Override
    public JComponent getToolBarGradientComponent() {
        HeaderGradientButton buttons = new HeaderGradientButton(this, StringResources.NEW_MAIL);
        buttons.setToolTipText(this.getToolTipText());
        buttons.setArrowVisible(true);
        buttons.addAction(this.getActionList().getAction(ActionKey.NEW_POSTED_MAIL));
        buttons.addSeparator();
        buttons.addAction(this.getActionList().getAction(ActionKey.NEW_MAIL), StringResources.MAIL);
        return buttons;
    }

    @Override
    protected boolean checkAccess() {
        return GWCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore().checkAccess(DataStoreAccessRequestType.ITEM_CREATE, ItemType.MAIL, 0);
    }
}

