/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.GlobalCommand;
import com.appframework.utils.OS;
import com.novell.gw.jclient.api.enums.DataStoreAccessRequestType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.application.actions.AbstractAddressBookAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposePhone;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.exceptions.ItemNotCreatedException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import com.novell.gw.jclient.bl.om.items.PhoneItem;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class ActionNewPhoneMessage
extends AbstractAddressBookAction {
    private static Logger logger = Logger.getLogger(ActionNewPhoneMessage.class);

    public ActionNewPhoneMessage(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.NEW_PHONEMESSAGE, StringResources.ACTION_PHONE, ImageResources.ICON_ACT_NEW_PHONEMESSAGE);
        this.setToolTipText(StringResources.DESCRIPTION_NEW_PHONE);
        this.setAccelerator(KeyStroke.getKeyStroke(80, 1 + OS.getMetaKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(ActionEvent e) {
        if (!this.validateRecipients()) {
            return;
        }
        try {
            MessageUtils.showBusyCursor(true);
            AbstractItem newItem = GWCommandManager.getInstance(this.getUserGuid()).composeNewItem(PhoneItem.class);
            FrameComposePhone frameCompose = new FrameComposePhone(newItem, true, ComposeMode.NEW, this.getUserGuid());
            this.sendRecipients(frameCompose);
            frameCompose.showMe();
            GlobalCommand command = new GlobalCommand(480, frameCompose);
            ((FrameComposeActionList)frameCompose.getController()).processCommand(command);
        }
        catch (ItemNotCreatedException ex) {
        }
        catch (GWCommandException e1) {
            logger.error((Object)e1, (Throwable)e1);
            ErrorDialog.processGWException(e1);
        }
        finally {
            MessageUtils.showBusyCursor(false);
        }
    }

    protected boolean checkAccess() {
        return GWCommandManager.getInstance(this.getUserGuid()).getCurrentDataStore().checkAccess(DataStoreAccessRequestType.ITEM_CREATE, ItemType.PHONE, 0);
    }

    public boolean showWithText() {
        return true;
    }
}

