/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.ButtonList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.dialogs.proxy.ProxyDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class ActionProxy
extends AppAction {
    private ButtonList buttons = new ButtonList();

    public ActionProxy(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.PROXY, StringResources.ACTION_PROXY, ImageResources.ICON_STORAGE_SWITCH);
        this.setToolTipText(StringResources.DESCRIPTION_PROXY);
    }

    protected void performAction(ActionEvent e) {
        ProxyDialog proxyDialog = new ProxyDialog((ApplicationFrame)this.getActionList().getMVCView());
        proxyDialog.pack();
        proxyDialog.setLocationRelativeTo(null);
        proxyDialog.setVisible(true);
        proxyDialog.dispose();
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = OS.createMenuItem(this);
        this.buttons.add(menuItem);
        return menuItem;
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 750, new PROXY_DATA_STORE_INSTALLED_EventListener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 740, new ACTION_SWITCH_ONLINE_PERFORMED_EventListener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 800, new STORE_MODE_CHANGED_Listener()));
    }

    private class STORE_MODE_CHANGED_Listener
    extends AppEventListener {
        private STORE_MODE_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionProxy.this.setEnabled(((StorageMode)theEvent.getData()).isNormal());
        }
    }

    private class ACTION_SWITCH_ONLINE_PERFORMED_EventListener
    extends AppEventListener {
        private ACTION_SWITCH_ONLINE_PERFORMED_EventListener() {
        }

        public void handle(AppEvent theEvent) {
            ActionProxy.this.buttons.setSelected(false);
        }
    }

    private class PROXY_DATA_STORE_INSTALLED_EventListener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_EventListener() {
        }

        public void handle(AppEvent theEvent) {
            ActionProxy.this.buttons.setSelected(true);
        }
    }
}

