/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.ButtonList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.AbstractMainFrameAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.options.AppearanceSettings;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class ActionQuickViewer
extends AbstractMainFrameAction {
    protected ButtonList buttons = new ButtonList();
    private AbstractFolder folder;

    public ActionQuickViewer(ApplicationFrameActionList appActionList) {
        super((ActionList)appActionList, ActionKey.QUICKVIEWER, StringResources.ACTION_QUICKVIEWER, ImageResources.ICON_QUICKVIEWER);
        this.setToolTipText(StringResources.DISPLAY_OR_HIDE_QUICK_VIEWER);
        this.setType(AppAction.ActionType.CHECKABLE);
        this.setAccelerator(KeyStroke.getKeyStroke(81, OS.getMetaKey()));
        boolean isSelected = this.isQuickViewerVisible();
        this.setSelected(isSelected);
    }

    protected boolean isQuickViewerVisible() {
        if (this.isQuickViewerApplyPerFolder()) {
            return this.folder.getDisplaySettings().isQuickViewerVisible();
        }
        return GWCommandManager.getInstance(this.getUserGuid()).getAppearanceSettings().isQuickViewerVisible();
    }

    protected boolean isQuickViewerApplyPerFolder() {
        return this.folder != null && this.folder.getDisplaySettings().isQuickViewerApplyPerFolder();
    }

    protected void performAction(ActionEvent e) {
        boolean selected;
        boolean bl = selected = !this.isSelected();
        if (this.isQuickViewerApplyPerFolder()) {
            this.folder.getDisplaySettings().setQuickViewerVisible(selected);
        } else {
            AppearanceSettings settings = EngineCommandManager.getInstance(this.getUserGuid()).getAppearanceSettings();
            settings.setQuickViewerVisible(selected);
        }
        this.setSelected(selected);
        this.getController().processCommand(new Command(710, selected));
        this.getController().processCommand(new Command(900));
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = super.getMenuItem();
        this.buttons.add(menuItem);
        return menuItem;
    }

    public JComponent getToolBarComponent() {
        AbstractButton button = (AbstractButton)super.getToolBarComponent();
        this.buttons.add(button);
        return button;
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1090, new OPEN_FOLDER_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1450, new START_TOOL_BAR_CUSTOMIZATION_MODE_listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1460, new FINISH_TOOL_BAR_CUSTOMIZATION_MODE_listener()));
        FOLDER_SETTINGS_CHANGED_listener listener = new FOLDER_SETTINGS_CHANGED_listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1210, listener));
    }

    public void setSelected(boolean bSelect) {
        super.setSelected(bSelect);
        this.buttons.setSelected(bSelect);
    }

    public boolean showWithText() {
        return false;
    }

    private class FOLDER_SETTINGS_CHANGED_listener
    extends AppEventListener {
        private FOLDER_SETTINGS_CHANGED_listener() {
        }

        public void handle(AppEvent theEvent) {
            Object o = theEvent.getData();
            if (o instanceof AbstractFolder) {
                boolean isQuickViewerVisible = EngineCommandManager.getInstance(ActionQuickViewer.this.getUserGuid()).getAppearanceSettings().isQuickViewerVisible();
                AbstractFolder folder = (AbstractFolder)o;
                if (folder.getDisplaySettings().isQuickViewerApplyPerFolder()) {
                    ActionQuickViewer.this.setSelected(folder.getDisplaySettings().isQuickViewerVisible());
                } else if (ActionQuickViewer.this.isSelected() != isQuickViewerVisible) {
                    ActionQuickViewer.this.setSelected(isQuickViewerVisible);
                }
            }
        }
    }

    private class FINISH_TOOL_BAR_CUSTOMIZATION_MODE_listener
    extends AppEventListener {
        private FINISH_TOOL_BAR_CUSTOMIZATION_MODE_listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionQuickViewer.this.setEnabled(true);
        }
    }

    private class START_TOOL_BAR_CUSTOMIZATION_MODE_listener
    extends AppEventListener {
        private START_TOOL_BAR_CUSTOMIZATION_MODE_listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionQuickViewer.this.setEnabled(false);
        }
    }

    private class OPEN_FOLDER_Listener
    extends AppEventListener {
        private OPEN_FOLDER_Listener() {
        }

        public void handle(AppEvent theEvent) {
            Object o = theEvent.getData();
            if (o instanceof AbstractFolder) {
                ActionQuickViewer.this.folder = (AbstractFolder)o;
            }
            ActionQuickViewer.this.setEnabled(true);
            ActionQuickViewer.this.setSelected(ActionQuickViewer.this.isQuickViewerVisible());
        }
    }
}

