/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.components.ButtonList;
import com.appframework.mvc.Command;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class ActionSetResizableADEPane
extends AppAction {
    private static Logger logger = Logger.getLogger(ActionSetResizableADEPane.class);
    protected ButtonList buttons;

    public ActionSetResizableADEPane(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.AUTOSIZE_ALL_DAY_EVENT_ACTIONS, StringResources.AUTOSIZE_ALL_DAY_EVENTS_PANE);
        this.setType(AppAction.ActionType.CHECKABLE);
        boolean isAutosizeAllowed = this.isAutosizeAllowed();
        this.buttons = new ButtonList(isAutosizeAllowed);
        this.setSelected(isAutosizeAllowed);
    }

    public void actionPerformed(ActionEvent e) {
        boolean newState = ((AbstractButton)e.getSource()).isSelected();
        this.buttons.setSelected(newState);
        this.setSelected(newState);
        this.setAutosizeAllowed(newState);
        this.getController().processCommand(new Command(2000, newState));
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = super.getMenuItem();
        this.buttons.add(menuItem);
        return menuItem;
    }

    public JComponent getToolBarComponent() {
        AbstractButton button = (AbstractButton)super.getToolBarComponent();
        this.buttons.add(button);
        return button;
    }

    public boolean isAutosizeAllowed() {
        return ApplicationOptions.getInstance().getBoolean("AUTOSIZE_ALLOWED", true);
    }

    public void setAutosizeAllowed(boolean autosizeAllowed) {
        ApplicationOptions.getInstance().put("AUTOSIZE_ALLOWED", autosizeAllowed);
    }
}

