/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ActionSwitchArchiveStorage
extends AppAction {
    private static Logger logger = Logger.getLogger(ActionSwitchArchiveStorage.class);

    public ActionSwitchArchiveStorage(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.SWITCH_ARCHIVE_STORAGE, StringResources.ARCHIVE, ImageResources.FLD_WORLD);
        this.setType(AppAction.ActionType.CHECKABLE);
    }

    protected void performAction(ActionEvent e) {
        if (!GWCommandManager.getInstance(this.getUserGuid()).isArchive()) {
            try {
                if (!Utils.checkArchivePath(this.getUserGuid())) {
                    return;
                }
                String userGuid = GWCommandManager.getInstance(this.getUserGuid()).switchToArchiveMode();
                Command command = new Command(800, new StorageMode(1, userGuid));
                this.getActionList().processCommand(command);
                this.getActionList().performAction(ActionKey.REFRESH);
            }
            catch (GWCommandException e1) {
                logger.error((Object)e1, (Throwable)e1);
                ErrorDialog.processGWException(e1);
            }
        }
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 750, new PROXY_DATA_STORE_INSTALLED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 800, new STORE_MODE_CHANGED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 740, new ACTION_SWITCH_ONLINE_PERFORMED_Listener()));
    }

    private class STORE_MODE_CHANGED_Listener
    extends AppEventListener {
        private STORE_MODE_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            StorageMode storegeMode = (StorageMode)theEvent.getData();
            if (storegeMode.isNormal()) {
                ActionSwitchArchiveStorage.this.setEnabled(true);
            }
        }
    }

    private class ACTION_SWITCH_ONLINE_PERFORMED_Listener
    extends AppEventListener {
        private ACTION_SWITCH_ONLINE_PERFORMED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionSwitchArchiveStorage.this.setEnabled(true);
        }
    }

    private class PROXY_DATA_STORE_INSTALLED_Listener
    extends AppEventListener {
        private PROXY_DATA_STORE_INSTALLED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionSwitchArchiveStorage.this.setEnabled(false);
        }
    }
}

