/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.GWMainAppFrame;
import com.novell.gw.jclient.application.actions.AbstractSwitchViewAction;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.options.ApplicationOptions;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.event.ActionEvent;
import javax.swing.JMenuItem;

public class ActionSwitchQVToolbar
extends AbstractSwitchViewAction {
    protected JMenuItem menuItemContextItem;

    public ActionSwitchQVToolbar(ActionList appActionList) {
        super(appActionList, ActionKey.SWITCH_QV_TOOLBAR, StringResources.ITEM_CONTEXT_TOOLBAR);
        this.setType(AppAction.ActionType.CHECKABLE);
        this.menuItem = OS.createMenuItem(this);
        this.menuItemContextItem = OS.createMenuItem(this);
        this.menuItemContextItem.setText(StringResources.ITEM_CONTEXT);
        this.menuItemContextItem.setEnabled(true);
        this.setSelected();
    }

    protected void setSelected() {
        boolean isSelected = ApplicationOptions.getInstance().getBoolean("ITEM_CONTEXT_TOOLBAR_VISIBLE", true);
        this.menuItem.setSelected(isSelected);
        this.menuItemContextItem.setSelected(isSelected);
    }

    protected void performAction(ActionEvent e) {
        boolean b = !ApplicationOptions.getInstance().getBoolean("ITEM_CONTEXT_TOOLBAR_VISIBLE", true);
        this.menuItem.setSelected(b);
        ApplicationOptions.getInstance().put("ITEM_CONTEXT_TOOLBAR_VISIBLE", b ? Boolean.TRUE : Boolean.FALSE);
        this.getController().processCommand(new Command(900));
        this.setSelected();
    }

    public void actionPerformed(ActionEvent e) {
        this.performAction(e);
    }

    public JMenuItem getMenuItemContextItem() {
        return this.menuItemContextItem;
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1090, new OPEN_FOLDER_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 710, new ACTION_QUICKVIEWER_PERFORMED_Listener()));
    }

    private class ACTION_QUICKVIEWER_PERFORMED_Listener
    extends AppEventListener {
        private ACTION_QUICKVIEWER_PERFORMED_Listener() {
        }

        public void handle(AppEvent event) {
            if (ActionSwitchQVToolbar.this.getFrame() instanceof GWMainAppFrame) {
                ActionSwitchQVToolbar.this.menuItem.setEnabled((Boolean)event.getData());
            }
        }
    }

    private class OPEN_FOLDER_Listener
    extends AppEventListener {
        private OPEN_FOLDER_Listener() {
        }

        public void handle(AppEvent event) {
            if (ActionSwitchQVToolbar.this.getFrame() instanceof GWMainAppFrame) {
                boolean enabled = ActionSwitchQVToolbar.this.isQuickViewerVisible() && ActionSwitchQVToolbar.this.getActionList().getAction(ActionKey.QUICKVIEWER).isEnabled();
                ActionSwitchQVToolbar.this.menuItem.setEnabled(enabled);
            }
        }
    }
}

