/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrameActionList;
import com.appframework.components.customizedbutton.listpopuppane.HeaderGradientButton;
import com.appframework.components.customizedbutton.listpopuppane.ListPopupPane;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.ToolbarGradientComponent;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewList;
import com.novell.gw.jclient.application.controls.gwcalendar.ToolBarProperties.PropertiesViewListItem;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendar;
import com.novell.gw.jclient.application.frames.calendar.FrameCalendarActionList;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JComponent;

public class ActionViewCalendar
extends AppAction
implements ToolbarGradientComponent {
    public ActionViewCalendar(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.VIEW_CALENDAR, StringResources.NEW_CALENDAR_WINDOW, ImageResources.ICON_ACT_VIEW_CALENDAR);
        this.setToolTipText(StringResources.DESCRIPTION_VIEW_CALENDAR);
    }

    public void setCalendarType(PropertiesViewListItem calendarType) {
        this.setMVCModel(calendarType);
    }

    protected void performAction(ActionEvent e) {
        this.performActionWithDate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performActionWithDate(Date theDate) {
        try {
            PropertiesViewListItem propertiesViewItem;
            MessageUtils.showBusyCursor(true);
            if (this.mvcModel != null) {
                propertiesViewItem = (PropertiesViewListItem)this.mvcModel;
            } else {
                propertiesViewItem = PropertiesViewList.getItemTypesList().get(0);
                this.mvcModel = propertiesViewItem;
            }
            String userGuid = this.getUserGuid();
            FrameCalendar frame = new FrameCalendar(theDate, (AbstractFolder)GWCommandManager.getInstance(userGuid).getCalendarFolder(), userGuid, propertiesViewItem);
            frame.showMe();
            GlobalCommand command = new GlobalCommand(480, frame);
            ((FrameCalendarActionList)frame.getController()).processCommand(command);
        }
        catch (GWCommandException e) {
            ErrorDialog.processGWException(e);
        }
        finally {
            MessageUtils.showBusyCursor(false);
        }
    }

    public boolean showWithText() {
        return false;
    }

    public JComponent getToolBarComponent() {
        ListPopupPane buttons = new ListPopupPane(this);
        buttons.setToolTipText(this.getToolTipText());
        int nSize = PropertiesViewList.getItemTypesList().size();
        for (int i = 0; i < nSize; ++i) {
            buttons.addAction(new CalendarTypeSelectAction(PropertiesViewList.getItemTypesList().get(i)));
        }
        return buttons;
    }

    public JComponent getToolBarGradientComponent() {
        HeaderGradientButton buttons = new HeaderGradientButton(this);
        buttons.setToolTipText(this.getToolTipText());
        buttons.setArrowVisible(true);
        int nSize = PropertiesViewList.getItemTypesList().size();
        for (int i = 0; i < nSize; ++i) {
            buttons.addAction(new CalendarTypeSelectAction(PropertiesViewList.getItemTypesList().get(i)));
        }
        return buttons;
    }

    private class CalendarTypeSelectAction
    extends AbstractAction {
        private PropertiesViewListItem calendarType;

        public CalendarTypeSelectAction(PropertiesViewListItem calendarType) {
            super(calendarType.getName());
            this.calendarType = calendarType;
        }

        public void actionPerformed(ActionEvent e) {
            ActionViewCalendar.this.setCalendarType(this.calendarType);
            ActionViewCalendar.this.performAction(e);
        }
    }
}

