/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.browser;

import com.appframework.ActionList;
import com.appframework.components.htmleditor.GWMozillaBrowser;
import com.appframework.components.htmleditor.encodings.CharsetEncoding;
import com.appframework.components.htmleditor.encodings.CharsetEncodings;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.browser.AbstractWebPageAction;
import com.novell.gw.jclient.application.controls.menus.GWMenu;
import com.novell.gw.jclient.application.controls.orientable.MenuItemFactory;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ActionChangeEncoding
extends AbstractWebPageAction {
    protected JMenu menu = new GWMenu(StringResources.ENCODING);

    public ActionChangeEncoding(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.CHANGE_ENCODING);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.menu.add(this.getEncodingsMenu(StringResources.WEST_EUROPEAN, CharsetEncodings.WEST_EUROPEAN_ENCODINGS, buttonGroup));
        this.menu.add(this.getEncodingsMenu(StringResources.EAST_EUROPEAN, CharsetEncodings.EAST_EUROPEAN_ENCODINGS, buttonGroup));
        this.menu.add(this.getEncodingsMenu(StringResources.MIDDLE_EASTERN, CharsetEncodings.MIDDLE_EASTERN_ENCODINGS, buttonGroup));
        this.menu.add(this.getEncodingsMenu(StringResources.EAST_ASIAN, CharsetEncodings.EAST_ASIAN_ENCODINGS, buttonGroup));
        this.menu.add(this.getEncodingsMenu(StringResources.WEST_ASIAN, CharsetEncodings.WEST_ASIAN_ENCODINGS, buttonGroup));
        this.menu.add(this.getEncodingsMenu(StringResources.UNICODE, CharsetEncodings.UNICODE_ENCODINGS, buttonGroup));
    }

    public void actionPerformed(ActionEvent e) {
        this.performAction(e);
    }

    protected void performAction(ActionEvent e) {
        String command = e.getActionCommand();
        CharsetEncoding seletedEncoding = this.getEncoding(command);
        String path = this.getGWItem().getNativeItem().saveBodyHtmlToTempFile(seletedEncoding.getEncoding());
        try {
            this.browser.setPage(new File(path).toURL());
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
    }

    public JMenu getEncodingsMenu() {
        return this.menu;
    }

    private JMenu getEncodingsMenu(String label, CharsetEncoding[] encodings, ButtonGroup buttonGroup) {
        JMenu menu = new JMenu(label);
        for (CharsetEncoding encoding : encodings) {
            JMenuItem menuItem = MenuItemFactory.createCkeckBoxMenuItem(encoding.toString());
            menu.add(menuItem);
            buttonGroup.add(menuItem);
            menuItem.addActionListener(this);
        }
        return menu;
    }

    protected boolean checkEnableOnSelect() {
        return true;
    }

    private CharsetEncoding getEncoding(String encoding) {
        for (CharsetEncoding charsetEncoding : CharsetEncodings.ENCODINGS) {
            if (!charsetEncoding.equals(encoding)) continue;
            return charsetEncoding;
        }
        return null;
    }

    public void setEncoding(CharsetEncoding encoding) {
        if (encoding == null) {
            return;
        }
        for (int i = 0; i < this.menu.getItemCount(); ++i) {
            JMenu childMenu = (JMenu)this.menu.getItem(i);
            for (int j = 0; j < childMenu.getItemCount(); ++j) {
                JMenuItem item = childMenu.getItem(j);
                item.setSelected(encoding.equals(item.getText()));
            }
        }
    }

    protected void handle_WEB_PAGE_ENCODING_PROMPT(GWMozillaBrowser browser) {
        AbstractItem item = this.getGWItem();
        if (item == null) {
            String encoding = browser.getBrowser().getDocument().getCharSet();
            if (!Utils.isNullOrEmpty(encoding)) {
                this.setEncoding(this.getEncoding(encoding));
            }
        } else {
            this.setEncoding(this.getEncoding(this.getGWItem().getNativeItem().getHTMLCharSetEncoding()));
        }
    }
}

