/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.contact;

import com.appframework.ActionList;
import com.appframework.DlgActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.contact.AbstractContactAction;
import com.novell.gw.jclient.application.controls.addressbook.AbstractAddressSelectorDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public class ActionMoveToRecipientsList
extends AbstractContactAction {
    private RecipientCopyType copyType = RecipientCopyType.getDefault();

    public ActionMoveToRecipientsList(DlgActionList theActionList) {
        super(theActionList, ActionKey.MOVE_TO_RECIPIENTS_LIST, StringResources.MOVE);
    }

    public ActionMoveToRecipientsList(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
    }

    protected boolean checkEnableOnSelect() {
        return this.hasAddressables();
    }

    protected void sendRecipients(RecipientCopyType copyType) {
        if (this.hasAddressables()) {
            ArrayList<IRecipient> recipients = new ArrayList<IRecipient>();
            for (IAddressable addressable : this.getAddressables()) {
                recipients.add(APIAbWrapperManager.createRecipient(addressable, copyType));
            }
            Command command = new Command(380, recipients);
            this.getController().processCommand(command);
        }
    }

    protected void performAction(ActionEvent e) {
        this.sendRecipients(this.copyType);
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        DIRECTORY_SELECTED_Listener listener = new DIRECTORY_SELECTED_Listener();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 360, listener));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 390, listener));
    }

    public void setMVCModel(Object model) {
        if (model instanceof RecipientCopyType) {
            this.copyType = (RecipientCopyType)model;
        }
        super.setMVCModel(model);
    }

    private class DIRECTORY_SELECTED_Listener
    extends AppEventListener {
        private DIRECTORY_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            if (!(ActionMoveToRecipientsList.this.getActionList().getMVCView() instanceof AbstractAddressSelectorDialog) || ActionMoveToRecipientsList.this.getActionList().getMVCView() == AbstractAddressSelectorDialog.getLastInstance()) {
                ActionMoveToRecipientsList.this.setMVCModel((Object)null);
                ActionMoveToRecipientsList.this.setEnabled(false);
            }
        }
    }
}

