/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.edit.text;

import com.appframework.ActionList;
import com.appframework.components.htmleditor.GWMozillaBrowserCanvas;
import com.appframework.mvc.Command;
import com.appframework.utils.OS;
import com.appframework.utils.Utils;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.edit.text.AbstractFindAction;
import com.novell.gw.jclient.application.dialogs.FindTextConditions;
import com.novell.gw.jclient.application.dialogs.FindTextDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public class ActionFindText
extends AbstractFindAction {
    private static Logger logger = Logger.getLogger(ActionFindText.class);
    private FindTextConditions conditions = new FindTextConditions();
    private FindTextDialog findTextDialog;
    private String lastSearchText = "";
    private boolean lastSearchSuccsseful = false;
    private boolean blocked = false;

    public ActionFindText(ActionList theActionList) {
        super(theActionList, ActionKey.FIND_TEXT, StringResources.FIND_TEXT_D, ImageResources.ACT_FIND_TEXT);
        this.setToolTipText(StringResources.DESCRIPTION_FIND_TEXT);
        if (OS.isMacOS()) {
            this.setAccelerator(KeyStroke.getKeyStroke(70, OS.getMetaKey()));
        } else {
            this.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        }
    }

    public void setMVCModel(Object theModel) {
        super.setMVCModel(theModel);
        if (theModel == null) {
            this.lastSearchSuccsseful = false;
            this.lastSearchText = "";
            this.conditions = new FindTextConditions();
            if (this.findTextDialog != null) {
                this.findTextDialog.dispose();
            }
        }
    }

    private String getTargetText() {
        String text = "";
        try {
            Document document = ((JTextComponent)this.getMVCModel()).getDocument();
            text = document.getText(0, document.getLength());
        }
        catch (BadLocationException e) {
            logger.error((Object)e);
            logger.debug((Object)e, (Throwable)e);
        }
        return text;
    }

    public void performFindText() {
        if (this.conditions.getSearchText().length() != 0) {
            boolean result = false;
            Object model = this.getMVCModel();
            if (model instanceof JTextComponent) {
                result = this.searchInTextPane();
            } else if (model instanceof GWMozillaBrowserCanvas) {
                result = this.searchInExternalBrowser();
            }
            if (result) {
                this.getController().processCommand(new Command(1960, model));
            }
        }
    }

    private boolean searchInExternalBrowser() {
        if (this.blocked) {
            return false;
        }
        GWMozillaBrowserCanvas browser = (GWMozillaBrowserCanvas)this.getMVCModel();
        boolean found = browser.findInPage(this.conditions.getSearchText(), this.conditions.isMatchCase(), this.conditions.isMatchWholeWord(), this.conditions.isUpDirection());
        if (found) {
            this.lastSearchSuccsseful = true;
            this.lastSearchText = this.conditions.getSearchText();
            if (this.findTextDialog.isVisible()) {
                this.findTextDialog.toFront();
            }
            return true;
        }
        boolean success = this.lastSearchSuccsseful && this.lastSearchText.equals(this.conditions.getSearchText());
        this.blocked = true;
        this.displayWarningMessage(success);
        this.blocked = false;
        this.lastSearchSuccsseful = false;
        this.lastSearchText = "";
        return false;
    }

    private boolean searchInTextPane() {
        this.definePosition();
        int index = this.search();
        if (index != -1) {
            this.selectMatchedText(index);
            this.lastSearchSuccsseful = true;
            this.lastSearchText = this.conditions.getSearchText();
            if (this.findTextDialog.isVisible()) {
                this.findTextDialog.toFront();
            }
            return true;
        }
        if (this.lastSearchSuccsseful && this.lastSearchText.equals(this.conditions.getSearchText())) {
            this.displayWarningMessage(true);
        } else {
            this.displayWarningMessage(false);
        }
        this.lastSearchSuccsseful = false;
        this.lastSearchText = "";
        return false;
    }

    private void definePosition() {
        JTextComponent editor = (JTextComponent)this.getMVCModel();
        String selectedText = editor.getSelectedText();
        if (!Utils.isNullOrEmpty(selectedText) && selectedText.equalsIgnoreCase(this.conditions.getSearchText())) {
            if (this.conditions.isUpDirection()) {
                this.conditions.setTextIndex(editor.getSelectionStart());
            } else {
                this.conditions.setTextIndex(editor.getSelectionEnd());
            }
        } else {
            this.conditions.setTextIndex(editor.getCaretPosition());
        }
    }

    private void selectMatchedText(int index) {
        JTextComponent tcSearch = (JTextComponent)this.getMVCModel();
        tcSearch.requestFocus();
        tcSearch.select(index, index + this.conditions.getSearchText().length());
    }

    private void displayWarningMessage(boolean success) {
        Window parent = this.findTextDialog != null && this.findTextDialog.isVisible() ? this.findTextDialog : SwingUtilities.getWindowAncestor((Component)this.getMVCModel());
        String text = success ? StringResources.FINISHED_SEARCHING_DOCUMENT : StringResources.CANNOT_FIND + " \"" + this.conditions.getSearchText() + "\".";
        JOptionPane.showMessageDialog(parent, text, StringResources.NOVELL_GROUPWISE, 2);
    }

    private int search() {
        int result;
        String text = this.getTargetText();
        String searchText = this.conditions.getSearchText();
        if (!this.conditions.isMatchCase()) {
            text = text.toLowerCase();
            searchText = searchText.toLowerCase();
        }
        do {
            if ((result = this.conditions.isUpDirection() ? this.searchBackward(text, searchText) : this.searchForward(text, searchText)) == -1) continue;
            this.conditions.setTextIndex(result + searchText.length());
        } while (!this.isWholeWord(result, text, searchText) && result != -1);
        return result;
    }

    private boolean isWholeWord(int index, String text, String searchText) {
        if (index == -1) {
            return false;
        }
        if (!this.conditions.isMatchWholeWord()) {
            return true;
        }
        int startIndex = index;
        int endIndex = index + searchText.length();
        return !(startIndex != 0 && Character.isLetterOrDigit(text.toCharArray()[startIndex - 1]) || endIndex != text.length() && Character.isLetterOrDigit(text.toCharArray()[endIndex]));
    }

    private int searchForward(String theText, String theSearchText) {
        return theText.indexOf(theSearchText, this.conditions.getTextIndex());
    }

    private int searchBackward(String theText, String theSearchText) {
        int endIndex = this.conditions.getTextIndex();
        if (endIndex == -1) {
            endIndex = theText.length();
        }
        String text = theText.substring(0, endIndex);
        return text.lastIndexOf(theSearchText, endIndex);
    }

    public void setConditions(FindTextConditions conditions) {
        this.conditions = conditions;
    }

    public void setUpDirection(boolean b) {
        this.conditions.setUpDirection(b);
    }

    protected void performAction(ActionEvent e) {
        if (!this.isValid()) {
            return;
        }
        Component tcSearch = (Component)this.getMVCModel();
        if (this.findTextDialog != null && this.findTextDialog.isVisible()) {
            this.findTextDialog.requestFocus();
        } else {
            this.findTextDialog = new FindTextDialog((JFrame)SwingUtilities.getWindowAncestor(tcSearch), this.conditions, this);
            this.findTextDialog.pack();
            this.findTextDialog.setLocationRelativeTo(SwingUtilities.getAncestorOfClass(JScrollPane.class, tcSearch));
            this.findTextDialog.setVisible(true);
        }
    }
}

