/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.filter;

import com.appframework.ActionList;
import com.appframework.ApplicationFrame;
import com.appframework.mvc.Command;
import com.novell.gw.ab.AddressBookItemListFilter;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IUserContact;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.filter.AbstractActionContextItemFilter;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.filter.ContactFilter;
import com.novell.gw.jclient.application.controls.filter.ContactFilterDialog;
import com.novell.gw.jclient.application.controls.filter.FilterDialog;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.utils.ColumnInfos;
import com.novell.gw.jclient.bl.om.items.ContactItemDescription;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;

public class ActionContextItemContactFilter
extends AbstractActionContextItemFilter {
    private ContactItemDescription contactItemDescription;

    public ActionContextItemContactFilter(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.CONTEXT_ITEM_CONTACT_FILTER, StringResources.FIND_D, ImageResources.ICON_UNACTIVE_FILTER);
    }

    public void setModel(ContactItemDescription contactItemDescription, String folderName, boolean isInPanel) {
        this.contactItemDescription = contactItemDescription;
        this.folderOrPanelName = folderName;
        this.isInPanel = isInPanel;
    }

    protected void performAction(ActionEvent e) {
        boolean isSystem = ABUtils.isSystemABAbstractFolder(this.actionList);
        ContactFilter filter = new ContactFilter(new AddressBookItemListFilter(isSystem), isSystem);
        if (this.contactItemDescription != null && this.contactItemDescription.getSelectedColumn() != null) {
            ColumnInfos columnInfos = this.contactItemDescription.getColumnInfos();
            IContact contact = this.contactItemDescription.getItem();
            String nameColumn = this.contactItemDescription.getSelectedColumn();
            if (columnInfos.getColumnInfo(88) != null && nameColumn.equals(columnInfos.getColumnInfo(88).getName())) {
                filter.setDisplayName(contact.getDisplayName());
            } else if (columnInfos.getColumnInfo(816) != null && nameColumn.equals(columnInfos.getColumnInfo(816).getName())) {
                filter.setEmailAddress(contact.getEmailAddress());
            } else if (columnInfos.getColumnInfo(278) != null && nameColumn.equals(columnInfos.getColumnInfo(278).getName())) {
                filter.setFirstName(contact.getFirstName());
            } else if (columnInfos.getColumnInfo(279) != null && nameColumn.equals(columnInfos.getColumnInfo(279).getName())) {
                filter.setLastName(contact.getLastName());
            } else if (columnInfos.getColumnInfo(1403) != null && nameColumn.equals(columnInfos.getColumnInfo(1403).getName())) {
                filter.setCategories(contact.getCategories());
            } else if (columnInfos.getColumnInfo(355) != null && nameColumn.equals(columnInfos.getColumnInfo(355).getName())) {
                if (contact instanceof IUserContact && ((IUserContact)contact).getOrganization() != null) {
                    filter.setOrganization(((IUserContact)contact).getOrganization().getDisplayName());
                }
            } else if (columnInfos.getColumnInfo(422) != null && nameColumn.equals(columnInfos.getColumnInfo(422).getName()) && contact instanceof IUserContact) {
                filter.setDepartment(((IUserContact)contact).getDepartment());
            }
        }
        ApplicationFrame applicationFrame = (ApplicationFrame)this.getActionList().getMVCView();
        ContactFilterDialog dialog = new ContactFilterDialog(applicationFrame, filter);
        dialog.setVisible(true);
        if (dialog.isOkActionProcessed()) {
            MessageUtils.showBusyCursor(true);
            Command command = new Command(400, ((FilterDialog)dialog).getFilter());
            applicationFrame.getController().processCommand(command);
            MessageUtils.showBusyCursor(false);
        }
    }
}

