/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.filter;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.filter.FiltersFactory;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.novell.gw.engine.ItemListFilter;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.filter.AbstractFilter;
import com.novell.gw.jclient.application.controls.filter.AdvancedFilter;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.filter.Filter;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;

public class ActionFilterItemsWithAttachments
extends AppAction {
    public ActionFilterItemsWithAttachments(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.FILTER_ITEMS_WITH_ATTACHMENTS, StringResources.ITEMS_WITH_ATTACHMENTS);
        this.setType(AppAction.ActionType.CHECKABLE);
    }

    protected void performAction(ActionEvent e) {
        boolean selected = ((AbstractButton)e.getSource()).isSelected();
        Filter filter = FiltersFactory.getInstance().getFilter(this.getController());
        ItemListFilter itemListFilter = filter == null ? new ItemListFilter() : filter.getItemListFilter();
        itemListFilter.setFilteringAllAttachments(selected);
        AdvancedFilter advancedFilter = new AdvancedFilter(itemListFilter, true);
        if (filter != null) {
            int box = filter.getBoxType();
            advancedFilter.setBoxType(box);
        }
        Command command = new Command(400, advancedFilter);
        this.getController().processCommand(command);
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 400, new FILTER_CHANGED_Listener()));
    }

    private class FILTER_CHANGED_Listener
    extends AppEventListener {
        private FILTER_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            Object data = theEvent.getData();
            if (data == null) {
                ActionFilterItemsWithAttachments.this.setSelected(false);
            } else if (data instanceof Filter) {
                AbstractFilter filter = (AbstractFilter)data;
                ActionFilterItemsWithAttachments.this.setSelected(filter.getItemListFilter().getFilteringAllAttachments());
            }
        }
    }
}

