/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.folder;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.novell.gw.jclient.api.interfaces.folder.IFolder;
import com.novell.gw.jclient.api.interfaces.folder.INntpFolder;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.panelviews.PanelView;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import javax.swing.Icon;

public abstract class AbstractNntpFolderAction
extends AppAction {
    protected AbstractFolder openedFolder = null;
    protected AbstractFolder lightFolder = null;
    protected PanelView selectedPanel = null;

    public AbstractNntpFolderAction(ActionList actionList, ActionKey actionKey) {
        super(actionList, actionKey);
    }

    protected AbstractNntpFolderAction(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
    }

    protected AbstractNntpFolderAction(ActionList actionList, ActionKey actionKey, String name, Icon icon) {
        super(actionList, actionKey, name, icon);
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        if (this.isLight()) {
            this.addListenerDescriptor(new AppEventListenerDescriptor(level, 960, new FOLDER_LIGHT_SELECTED_Listener()));
        } else {
            this.addListenerDescriptor(new AppEventListenerDescriptor(level, 2040, new OPENING_FOLDER_STARTED_Listener()));
            this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1860, new PANEL_SELECTED_Listener()));
        }
    }

    public void setMVCModel(Object model) {
        assert (false) : "currently this method should not be called";
    }

    public Object getMVCModel() {
        assert (false) : "currently this method should not be called";
        return null;
    }

    protected boolean isLight() {
        return false;
    }

    protected boolean checkEnablement() {
        return this.getTargetFolder() instanceof INntpFolder;
    }

    protected IFolder getTargetFolder() {
        IFolder nativeFolder = null;
        if (this.isLight()) {
            nativeFolder = this.lightFolder == null ? null : this.lightFolder.getNativeFolder();
        } else if (this.openedFolder != null) {
            AbstractFolder folder = this.selectedPanel == null ? this.openedFolder : this.selectedPanel.getPanelFolder();
            nativeFolder = folder.getNativeFolder();
        }
        return nativeFolder;
    }

    protected void handle_FOLDER_LIGHT_SELECTED(AppEvent event) {
        this.lightFolder = (AbstractFolder)event.getData();
        this.setEnabled(this.checkEnablement());
    }

    protected void handle_OPENING_FOLDER_STARTED(AppEvent event) {
        this.selectedPanel = null;
        this.openedFolder = (AbstractFolder)event.getData();
        this.checkEnablement();
        this.setEnabled(this.checkEnablement());
    }

    protected void handle_PANEL_SELECTED(AppEvent event) {
        this.selectedPanel = (PanelView)event.getData();
        this.setEnabled(this.checkEnablement());
    }

    private class FOLDER_LIGHT_SELECTED_Listener
    extends AppEventListener {
        private FOLDER_LIGHT_SELECTED_Listener() {
        }

        public void handle(AppEvent event) {
            AbstractNntpFolderAction.this.handle_FOLDER_LIGHT_SELECTED(event);
        }
    }

    private class PANEL_SELECTED_Listener
    extends AppEventListener {
        private PANEL_SELECTED_Listener() {
        }

        public void handle(AppEvent event) {
            AbstractNntpFolderAction.this.handle_PANEL_SELECTED(event);
        }
    }

    private class OPENING_FOLDER_STARTED_Listener
    extends AppEventListener {
        private OPENING_FOLDER_STARTED_Listener() {
        }

        public void handle(AppEvent event) {
            AbstractNntpFolderAction.this.handle_OPENING_FOLDER_STARTED(event);
        }
    }
}

