/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.folder;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.ApplicationFrame;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.utils.OS;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.filechoser.GWFileChooser;
import com.novell.gw.jclient.application.controls.filechoser.GWMacFileChooser;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;

public class ActionExportCalendar
extends AppAction {
    public ActionExportCalendar(ActionList theAppActionList) {
        super(theAppActionList, ActionKey.EXPORT_CALENDAR, StringResources.EXPORT);
    }

    protected void performAction(ActionEvent e) {
        String fileName;
        ApplicationFrame frame = (ApplicationFrame)this.getActionList().getMVCView();
        AbstractFolder abstractFolder = (AbstractFolder)this.getMVCModel();
        if (OS.isMacOS()) {
            GWMacFileChooser gwFileChooser = new GWMacFileChooser((Frame)frame, StringResources.EXPORT, new File(""), 1);
            gwFileChooser.setSelectedFile(new File(abstractFolder.getName()));
            gwFileChooser.setVisible(true);
            fileName = gwFileChooser.getFile();
            if (fileName == null) {
                return;
            }
            fileName = gwFileChooser.getDirectory() + fileName;
        } else {
            GWFileChooser gwFileChooser = new GWFileChooser(frame, StringResources.EXPORT, new File(""), 0, 1, false);
            gwFileChooser.setSelectedFile(new File(abstractFolder.getName()));
            gwFileChooser.setVisible(true);
            if (gwFileChooser.isCanceled() || gwFileChooser.getResult() == null) {
                return;
            }
            fileName = gwFileChooser.getResult()[0];
        }
        if (!fileName.endsWith(".ics")) {
            fileName = fileName + ".ics";
        }
        abstractFolder.getNativeFolder().exportCalendarAsIcal(fileName);
    }

    protected void registerListeners() {
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 10, new FOLDER_SELECTED_Listener()));
    }

    protected class FOLDER_SELECTED_Listener
    extends AppEventListener {
        protected FOLDER_SELECTED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            AbstractFolder folder = (AbstractFolder)theEvent.getData();
            ActionExportCalendar.this.setMVCModel(folder);
        }
    }
}

