/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.actions.AcceptDeclineOptionPane;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.actions.item.AbstractWillOpenNextItemAction;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.items.AbstractCalendarItem;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import com.novell.gw.jclient.bl.om.items.ReminderNote;
import com.novell.gw.jclient.bl.om.items.TaskItem;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class ActionAcceptWithOptions
extends AbstractWillOpenNextItemAction {
    private static Logger logger = Logger.getLogger(ActionAcceptWithOptions.class);

    public ActionAcceptWithOptions(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.ACCEPT_WITH_OPTIONS, StringResources.ACTION_ACCEPT_WITH_OPTIONS, ImageResources.ACT_ACCEPT_WITHOPTIONS);
        this.setToolTipText(StringResources.DESCRIPTION_ACCEPT_WITH_OPTIONS);
    }

    protected void performAction(ActionEvent e) {
        AbstractItem gwItem = this.getItem();
        AcceptDeclineOptionPane.Options result = AcceptDeclineOptionPane.showAcceptWithOptionsOptionPane(this.getActionList().getOwnerComponent(), gwItem);
        if (result == null) {
            return;
        }
        if (gwItem instanceof AppointmentItem) {
            ((AppointmentItem)gwItem).accept(result.getComment(), result.getAcceptLevel(), result.getCalendar());
        } else if (gwItem instanceof TaskItem || gwItem instanceof ReminderNote) {
            ((AbstractCalendarItem)gwItem).accept(result.getComment(), result.getCalendar());
        } else {
            ((AbstractCalendarItem)gwItem).accept(result.getComment());
        }
        UIUtils.closeOpenFrameForItem(gwItem);
        this.openNextIfNeed();
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 800, new STORE_MODE_CHANGED_Listener()));
    }

    protected boolean checkEnableOnSelect() {
        return this.hasItems() && this.getItem().canAccept();
    }

    private class STORE_MODE_CHANGED_Listener
    extends AppEventListener {
        private STORE_MODE_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionAcceptWithOptions.this.setEnabled(((StorageMode)theEvent.getData()).isNormal());
        }
    }
}

