/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.Application;
import com.appframework.ApplicationFrameActionList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.ActionDeleteOrEmptyItem;
import com.novell.gw.jclient.application.options.OptionManager;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class ActionEmptyItem
extends ActionDeleteOrEmptyItem {
    public ActionEmptyItem(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.EMPTY_ITEM, StringResources.ACTION_EMPTY_SELECTED_ITEMS, ImageResources.ICON_ACT_DELETE);
    }

    protected void performAction(ActionEvent e) {
        if (this.isSingleItemModel()) {
            if (this.isDeletingAllowed()) {
                GWEngineUtils.emptyItem(this.getItemList(), this.getItem());
                Application.disableFrames(this.getItems());
            }
        } else if (this.isMultipleItemsModel()) {
            if (this.isDeletingAllowed()) {
                GWEngineUtils.emptyItems(this.getItemList());
                Application.disableFrames(this.getItems());
            }
        } else {
            JOptionPane.showMessageDialog(this.getActionList().getOwnerComponent(), StringResources.NO_ITEM_IS_SELECTED, StringResources.GROUPWISE_CLIENT, 2);
        }
    }

    protected void applyAccelerator(KeyStroke oldValue, KeyStroke newValue) {
        super.applyAccelerator(oldValue, this.canEmpty() ? newValue : null);
    }

    private boolean isDeletingAllowed() {
        int result;
        return !OptionManager.getInstance().getGeneralOptions().isDeleteConfirmationAllowed() || (result = JOptionPane.showConfirmDialog(this.getActionList().getOwnerComponent(), StringResources.ITEMS_EMPTIED_FROM_THE_TRASH, StringResources.EMPTY_SELECTED_ITEMS, 0)) == 0;
    }

    protected boolean checkEnableOnSelect() {
        if (this.isSingleItemModel()) {
            return this.getItem().canEmpty();
        }
        if (this.isMultipleItemsModel()) {
            return this.getItemList().canPurgeSelectedItems();
        }
        return false;
    }

    protected KeyStroke getCustomAccelerator() {
        return KeyStroke.getKeyStroke(OptionManager.getInstance().getGeneralOptions().getItemDeleteKey(), 0);
    }
}

