/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractGWItemAction;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposeMail;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.DocumentItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import org.apache.log4j.Logger;

public class ActionForward
extends AbstractGWItemAction {
    private static Logger logger = Logger.getLogger(ActionForward.class);

    public ActionForward(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.FORWARD, StringResources.FORWARD, ImageResources.ACT_FORWARD);
        this.setToolTipText(StringResources.DESCRIPTION_FORWARD);
    }

    public ActionForward(ActionList actionList, ActionKey actionKey, String name, Icon icon) {
        super(actionList, actionKey, name, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(ActionEvent e) {
        try {
            MessageUtils.showBusyCursor(true);
            AbstractItem newItem = GWEngineUtils.composeForwardItem(this.getItem(), false, ControlsUtils.getSelectedTextFromItemViewer(this.getActionList()));
            FrameComposeMail frameComposeMail = new FrameComposeMail(newItem, true, ComposeMode.FORWARD, this.getUserGuid());
            frameComposeMail.showMe();
            GlobalCommand command = new GlobalCommand(480, frameComposeMail);
            ((FrameComposeActionList)frameComposeMail.getController()).processCommand(command);
        }
        catch (GWCommandException e1) {
            logger.error((Object)e1, (Throwable)e1);
            ErrorDialog.processGWException(e1, this.getActionList().getOwnerComponent());
        }
        finally {
            MessageUtils.showBusyCursor(false);
        }
    }

    protected boolean checkEnableOnSelect() {
        if (this.hasItems()) {
            AbstractItem item = this.getItem();
            return !(item instanceof DocumentItem) && item.canForward();
        }
        return false;
    }
}

