/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.ApplicationFrameActionList;
import com.appframework.event.AppEvent;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractMultipleItemsAction;
import com.novell.gw.jclient.application.controls.itemedit.ComposeMode;
import com.novell.gw.jclient.application.dialogs.error.ErrorDialog;
import com.novell.gw.jclient.application.frames.compose.FrameComposeActionList;
import com.novell.gw.jclient.application.frames.compose.FrameComposeMail;
import com.novell.gw.jclient.application.impl.SelectedItemsInfoImpl;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.GWEngineUtils;
import com.novell.gw.jclient.bl.om.exceptions.GWCommandException;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.MessageUtils;
import java.awt.event.ActionEvent;
import java.util.List;
import org.apache.log4j.Logger;

public class ActionForwardAsAttachment
extends AbstractMultipleItemsAction {
    private static Logger logger = Logger.getLogger(ActionForwardAsAttachment.class);

    public ActionForwardAsAttachment(ApplicationFrameActionList theAppActionList) {
        super((ActionList)theAppActionList, ActionKey.FORWARD_AS_ATTACHMENT, StringResources.ACTION_FORWARD_AS_ATTACHMENT, ImageResources.ACT_FORWARD);
        this.setToolTipText(StringResources.DESCRIPTION_FORWARD_AS_ATTACHMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(ActionEvent e) {
        try {
            MessageUtils.showBusyCursor(true);
            List<AbstractItem> list = this.getItemsInfo().getItems();
            AbstractItem newItem = null;
            for (AbstractItem item : list) {
                if (newItem == null) {
                    if (!item.canForward()) continue;
                    newItem = GWEngineUtils.composeForwardItem(item, true, null);
                    continue;
                }
                if (!item.canForward()) continue;
                newItem.addAttachment(item);
            }
            FrameComposeMail frameComposeMail = new FrameComposeMail(newItem, true, ComposeMode.FORWARD_AS_ATTACHMENT, this.getUserGuid());
            frameComposeMail.showMe();
            GlobalCommand command = new GlobalCommand(480, frameComposeMail);
            ((FrameComposeActionList)frameComposeMail.getController()).processCommand(command);
        }
        catch (GWCommandException e1) {
            logger.error((Object)e1, (Throwable)e1);
            ErrorDialog.processGWException(e1, this.getActionList().getOwnerComponent());
        }
        finally {
            MessageUtils.showBusyCursor(false);
        }
    }

    protected void handle_ATTACHMENT_SELECTED(AppEvent theEvent) {
        if (theEvent.getData() instanceof AbstractItem) {
            AbstractItem item = (AbstractItem)theEvent.getData();
            this.setMVCModel(new SelectedItemsInfoImpl(null, item));
        }
    }

    protected boolean checkEnableOnSelect() {
        if (this.isSingleItemModel() || this.isMultipleItemsModel()) {
            List<AbstractItem> list = this.getItemsInfo().getItems();
            for (AbstractItem item : list) {
                if (!item.canForward()) continue;
                return true;
            }
        }
        return false;
    }
}

