/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.components.ButtonList;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.item.AbstractMultipleItemsAction;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class ActionMoveToTasklist
extends AbstractMultipleItemsAction {
    private ButtonList buttonList = new ButtonList();

    public ActionMoveToTasklist(ActionList actionList) {
        super(actionList, ActionKey.MOVE_TO_TASKLIST, StringResources.MOVE_TO_TASKLIST_FOLDER, ImageResources.MOVE_TO_TASKLIST);
        this.setDescription(StringResources.MOVE_THE_SELECTED_ITEMS_TO_THE_TASKLIST_FOLDER);
        this.setToolTipText(StringResources.MOVE_TO_TASKLIST_FOLDER);
    }

    protected boolean checkEnableOnSelect() {
        return this.hasItemList() && this.getItemList().canMoveSelectionToChecklist();
    }

    public void actionPerformed(ActionEvent e) {
        this.getItemList().moveSelectionToChecklist();
    }

    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        if (this.buttonList != null) {
            this.buttonList.setEnabled(newValue);
        }
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (this.buttonList != null) {
            this.buttonList.setSelected(selected);
        }
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = super.getMenuItem();
        this.buttonList.add(menuItem);
        return menuItem;
    }

    public JComponent getToolBarComponent() {
        JComponent component = super.getToolBarComponent();
        if (component instanceof AbstractButton) {
            this.buttonList.add((AbstractButton)component);
        }
        return component;
    }
}

