/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.GlobalCommand;
import com.novell.gw.jclient.api.enums.AppointmentAcceptLevel;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.StorageMode;
import com.novell.gw.jclient.application.actions.item.AbstractGWItemAction;
import com.novell.gw.jclient.application.impl.SelectedItemsInfoImpl;
import com.novell.gw.jclient.bl.om.items.AbstractItem;
import com.novell.gw.jclient.bl.om.items.AppointmentItem;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenuItem;

public abstract class ActionShowAppointmentAs
extends AbstractGWItemAction {
    private AppointmentAcceptLevel acceptLevel = AppointmentAcceptLevel.BUSY;
    private List<JMenuItem> menuItems = new LinkedList<JMenuItem>();

    protected ActionShowAppointmentAs(ActionList actionList, ActionKey actionKey, String name, AppointmentAcceptLevel acceptLevel) {
        super(actionList, actionKey, name);
        this.acceptLevel = acceptLevel;
        this.setType(AppAction.ActionType.RADIO);
        this.setSelected();
        this.setEnabled(false);
    }

    public AppointmentAcceptLevel getAcceptLevel() {
        return this.acceptLevel;
    }

    protected void performAction(ActionEvent e) {
        if (!this.getMenuItem().isSelected() && this.getItem() instanceof AppointmentItem) {
            AppointmentItem appointmentItem = (AppointmentItem)this.getItem();
            appointmentItem.setShowAsLevel(this.acceptLevel, true);
            this.getController().processCommand(new GlobalCommand(1990, (Object)this.acceptLevel));
        }
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        for (JMenuItem menuItem : this.menuItems) {
            menuItem.setSelected(selected);
        }
    }

    private void setSelected() {
        if (this.getMVCModel() != null && this.hasItems() && this.getItem() instanceof AppointmentItem) {
            AppointmentAcceptLevel showAsLevel = ((AppointmentItem)this.getItem()).getShowAsLevel();
            this.setSelected(showAsLevel.equals((Object)this.acceptLevel));
        }
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = super.getMenuItem();
        this.menuItems.add(menuItem);
        return menuItem;
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getController().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 800, new STORE_MODE_CHANGED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 1990, new ACCEPT_LEVEL_CHANGED_Listener()));
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 2020, new COMPOSE_ITEM_SELECTED_Listener()));
    }

    protected boolean checkEnableOnSelect() {
        this.setSelected();
        return this.hasItems() && this.getItem() instanceof AppointmentItem;
    }

    private class COMPOSE_ITEM_SELECTED_Listener
    extends AppEventListener {
        private COMPOSE_ITEM_SELECTED_Listener() {
        }

        public void handle(AppEvent event) {
            ActionShowAppointmentAs.this.setMVCModel(new SelectedItemsInfoImpl(null, (AbstractItem)event.getData()));
        }
    }

    private class ACCEPT_LEVEL_CHANGED_Listener
    extends AppEventListener {
        private ACCEPT_LEVEL_CHANGED_Listener() {
        }

        public void handle(AppEvent event) {
            ActionShowAppointmentAs.this.setSelected(ActionShowAppointmentAs.this.acceptLevel.equals(event.getData()));
        }
    }

    private class STORE_MODE_CHANGED_Listener
    extends AppEventListener {
        private STORE_MODE_CHANGED_Listener() {
        }

        public void handle(AppEvent theEvent) {
            ActionShowAppointmentAs.this.setEnabled(((StorageMode)theEvent.getData()).isNormal());
        }
    }
}

