/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.item;

import com.appframework.components.AbstractOKAction;
import com.appframework.utils.OS;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.application.controls.BasicDialog;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextArea;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableCheckBox;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.resources.ImageResources;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;

public class RetractFromCalendarDialog
extends BasicDialog {
    private static Logger logger = Logger.getLogger(RetractFromCalendarDialog.class);
    public static final int MY_MAILBOX = 0;
    public static final int ALL_MAILBOX = 1;
    public static final int ACTION_CANCELED = 3;
    private JTextArea taRetractComment;
    private OrientableButton btnOK;
    private OrientableButton btnCancel;
    private int result = -1;
    private JCheckBox chbDeleteFromAll;
    private JLabel lblSubject;
    private JLabel lblItemType;

    private RetractFromCalendarDialog(Dialog parentDialog) {
        super(parentDialog);
        this.buildUI();
    }

    private RetractFromCalendarDialog(Frame parentFrame) {
        super(parentFrame);
        this.buildUI();
    }

    private RetractFromCalendarDialog() {
        this.buildUI();
    }

    private void buildUI() {
        this.setTitle(StringResources.DELETE_ITEM);
        JComponent content = (JComponent)this.getContentPane();
        content.setLayout(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(15, 10, 10, 10));
        content.add((Component)this.buildMainPanel(), "Center");
        content.add((Component)this.buildButtonPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                RetractFromCalendarDialog.this.result = 3;
            }
        });
    }

    private JPanel buildButtonPanel() {
        OrientablePanel buttonPanel = new OrientablePanel(new FlowLayout(4));
        this.btnOK = new OrientableButton(new ButtonOKAction());
        this.btnCancel = new OrientableButton(new ButtonCancelAction());
        OS.addButtons(buttonPanel, this.btnOK, this.btnCancel);
        this.setDefaultButton(this.btnOK);
        this.setCancelButton(this.btnCancel);
        return buttonPanel;
    }

    private JPanel buildMainPanel() {
        OrientablePanel result = new OrientablePanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int yy = 0;
        OrientableLabel lbl = new OrientableLabel(ImageResources.ICON_ALERT);
        c.anchor = 21;
        c.gridheight = 2;
        c.insets = new Insets(0, 0, 0, 10);
        c.gridy = yy++;
        result.add((Component)lbl, c);
        lbl = new OrientableLabel(StringResources.ITEM_TYPE_C);
        c.gridheight = 1;
        c.gridx = 1;
        c.anchor = 21;
        result.add((Component)lbl, c);
        this.lblItemType = new OrientableLabel("lblItemType");
        c.gridx = 2;
        result.add((Component)this.lblItemType, c);
        lbl = new OrientableLabel(StringResources.SUBJECT_C);
        c.gridx = 1;
        c.gridy = yy++;
        c.insets = new Insets(5, 0, 0, 0);
        result.add((Component)lbl, c);
        this.lblSubject = new OrientableLabel("subject");
        c.gridx = 2;
        result.add((Component)this.lblSubject, c);
        this.lblSubject.setPreferredSize(new Dimension(200, this.lblSubject.getPreferredSize().height));
        OrientablePanel pnl = new OrientablePanel();
        pnl.setMinimumSize(new Dimension(2, 2));
        pnl.setPreferredSize(new Dimension(2, 2));
        c.gridx = 0;
        c.gridy = yy++;
        c.gridwidth = 3;
        c.fill = 1;
        c.insets = new Insets(10, 0, 10, 0);
        pnl.setBorder(BorderFactory.createEtchedBorder(1));
        result.add((Component)pnl, c);
        lbl = new OrientableLabel(StringResources.YOU_ORIGINATED_THIS_SCHEDULED_ITEM);
        c.fill = 0;
        c.gridx = 0;
        c.gridy = yy++;
        c.insets = new Insets(5, 0, 0, 0);
        result.add((Component)lbl, c);
        this.chbDeleteFromAll = new OrientableCheckBox(StringResources.DELETE_THIS_ITEM_FROM_ALL_OTHER);
        c.gridy = yy++;
        result.add((Component)this.chbDeleteFromAll, c);
        lbl = new OrientableLabel(StringResources.RETRACT_COMMENT);
        c.gridy = yy++;
        result.add((Component)lbl, c);
        this.taRetractComment = new GWTextArea();
        c.fill = 1;
        c.gridy = yy++;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(5, 0, 5, 0);
        OrientableScrollPane sp = new OrientableScrollPane(this.taRetractComment);
        sp.setVerticalScrollBarPolicy(22);
        sp.setPreferredSize(new Dimension(sp.getPreferredSize().width, 100));
        result.add((Component)sp, c);
        return result;
    }

    public void setSubject(String theSubject) {
        this.lblSubject.setText(theSubject);
    }

    public void setItemType(String theItemType) {
        this.lblItemType.setText(theItemType);
    }

    private int getResultID() {
        return this.result;
    }

    private String getRetractComment() {
        return this.taRetractComment.getText();
    }

    private boolean isDeleteFromAll() {
        return this.chbDeleteFromAll.isSelected();
    }

    public static Result showDialog(Component parentComponent, String theItemType, String theSubject, boolean bDeleteRecipients) {
        Window window = ControlsUtils.getWindowForComponent(parentComponent);
        RetractFromCalendarDialog dd = window instanceof Frame ? new RetractFromCalendarDialog((Frame)parentComponent) : (window instanceof Dialog ? new RetractFromCalendarDialog((Dialog)parentComponent) : new RetractFromCalendarDialog());
        dd.setSubject(theSubject);
        dd.setItemType(theItemType);
        dd.chbDeleteFromAll.setSelected(bDeleteRecipients);
        dd.setModal(true);
        dd.pack();
        UIUtils.centerWindow((Window)dd, parentComponent);
        dd.setVisible(true);
        int resultID = dd.result;
        String retractComment = dd.getRetractComment();
        Result result = new Result(resultID, retractComment);
        return result;
    }

    public static void main(String[] args) {
        StringResources.initTestStringResources();
        RetractFromCalendarDialog.showDialog(new JFrame(), "mail", "ASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDfASFASDFSDf", true);
    }

    private class ButtonCancelAction
    extends AbstractAction {
        public ButtonCancelAction() {
            super(StringResources.CANCEL);
        }

        public void actionPerformed(ActionEvent e) {
            RetractFromCalendarDialog.this.result = 3;
            RetractFromCalendarDialog.this.setVisible(false);
        }
    }

    private class ButtonOKAction
    extends AbstractOKAction {
        private ButtonOKAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (RetractFromCalendarDialog.this.chbDeleteFromAll.isSelected()) {
                RetractFromCalendarDialog.this.result = 1;
            } else {
                RetractFromCalendarDialog.this.result = 0;
            }
            RetractFromCalendarDialog.this.setVisible(false);
        }
    }

    public static class Result {
        private int resultID;
        private String comment = "";

        private Result(int theResultID, String theComment) {
            this.resultID = theResultID;
            this.comment = theComment;
        }

        public String getComment() {
            return this.comment;
        }

        public int getResultID() {
            return this.resultID;
        }
    }
}

