/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.actions.view;

import com.appframework.ActionList;
import com.appframework.AppAction;
import com.appframework.components.ButtonList;
import com.appframework.event.AppEvent;
import com.appframework.event.AppEventListener;
import com.appframework.level.Level;
import com.appframework.mvc.AppEventListenerDescriptor;
import com.appframework.mvc.Command;
import com.novell.gw.jclient.api.interfaces.IViewDisplaySettings;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.actions.view.AbstractTasklistViewAction;
import com.novell.gw.jclient.application.controls.itemlistview.ItemListView;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public abstract class AbstractHideCompletedItemsAction
extends AbstractTasklistViewAction {
    private ButtonList buttonList = new ButtonList();
    protected HideCompletedState selectedState;

    public AbstractHideCompletedItemsAction(ActionList actionList, ActionKey actionKey, String name) {
        super(actionList, actionKey, name);
        this.setType(AppAction.ActionType.RADIO);
    }

    protected void registerListeners() {
        super.registerListeners();
        Level level = this.getActionList().getFrameLevel();
        this.addListenerDescriptor(new AppEventListenerDescriptor(level, 2110, new HIDE_COMPLETED_ITEMS_VALUE_CHANGED_Listener()));
    }

    protected void performAction(ActionEvent e) {
        boolean selected;
        ItemListView itemListView = (ItemListView)this.getMVCModel();
        IViewDisplaySettings viewDisplaySettings = itemListView.getViewDisplaySettings();
        boolean bl = selected = !this.isSelected();
        if (selected) {
            if (this.getState() == HideCompletedState.HIDE_COMPLETED_IMMEDIATELY) {
                viewDisplaySettings.setHideCompleted(true);
                viewDisplaySettings.setHideCompletedAfterADay(false);
            } else if (this.getState() == HideCompletedState.HIDE_COMPLETED_AFTER_A_DAY) {
                viewDisplaySettings.setHideCompleted(false);
                viewDisplaySettings.setHideCompletedAfterADay(true);
            }
        } else {
            viewDisplaySettings.setHideCompleted(false);
            viewDisplaySettings.setHideCompletedAfterADay(false);
        }
        itemListView.refresh();
        this.setSelected(selected);
        this.getActionList().processCommand(new Command(2110));
    }

    protected abstract HideCompletedState getState();

    private void update() {
        ItemListView model = (ItemListView)this.getMVCModel();
        if (model != null) {
            IViewDisplaySettings viewDisplaySettings = model.getViewDisplaySettings();
            boolean hideCompleted = viewDisplaySettings.getHideCompleted();
            boolean hideCompletedAfterADay = viewDisplaySettings.getHideCompletedAfterADay();
            this.selectedState = hideCompleted ? HideCompletedState.HIDE_COMPLETED_IMMEDIATELY : (hideCompletedAfterADay ? HideCompletedState.HIDE_COMPLETED_AFTER_A_DAY : HideCompletedState.SHOW_COMPLETED);
        }
        this.setSelected(this.getState().equals((Object)this.selectedState));
    }

    public void setMVCModel(ItemListView model) {
        super.setMVCModel(model);
        this.update();
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.buttonList.setSelected(selected);
    }

    public void setEnabled(boolean newValue) {
        super.setEnabled(newValue);
        this.buttonList.setEnabled(newValue);
    }

    public JMenuItem getMenuItem() {
        JMenuItem menuItem = super.getMenuItem();
        this.buttonList.add(menuItem);
        return menuItem;
    }

    public JComponent getToolBarComponent() {
        JComponent component = super.getToolBarComponent();
        if (component instanceof AbstractButton) {
            this.buttonList.add((AbstractButton)component);
        }
        return component;
    }

    private class HIDE_COMPLETED_ITEMS_VALUE_CHANGED_Listener
    extends AppEventListener {
        private HIDE_COMPLETED_ITEMS_VALUE_CHANGED_Listener() {
        }

        public void handle(AppEvent event) {
            AbstractHideCompletedItemsAction.this.update();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum HideCompletedState {
        HIDE_COMPLETED_AFTER_A_DAY,
        HIDE_COMPLETED_IMMEDIATELY,
        SHOW_COMPLETED;

    }
}

