/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.enums.EngineMode;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePasswordField;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

public abstract class AbstractPasswordChangePanel
extends OrientablePanel {
    private static Logger logger = Logger.getLogger(AbstractPasswordChangePanel.class);
    protected JPasswordField pfOldPassword = new OrientablePasswordField();
    protected JPasswordField pfNewPassword = new OrientablePasswordField();
    protected JPasswordField pfConfirmNewPassword = new OrientablePasswordField();
    private int iSizeBetweenRows;
    protected boolean changeOnline;
    protected boolean performChange;
    private boolean disableOldPassword = false;
    protected String userGuid;
    protected GridBagConstraints constraints = new GridBagConstraints();
    private boolean oldPasswordValid = false;
    private boolean newPasswordFine = false;

    public AbstractPasswordChangePanel(boolean changeOnline, boolean performChange, boolean disableOldPassword, String userGuid) {
        logger.debug((Object)("changeOnline = " + changeOnline));
        logger.debug((Object)("performChange = " + performChange));
        logger.debug((Object)("disableOldPassword = " + this.disableOldPassword));
        this.userGuid = userGuid;
        this.changeOnline = changeOnline;
        this.performChange = performChange;
        this.oldPasswordValid = this.disableOldPassword = disableOldPassword;
        this.init();
        this.buildComponents();
        this.layoutComponents();
    }

    protected void init() {
    }

    protected void buildComponents() {
        FieldsDocumentListener documentListener = new FieldsDocumentListener();
        this.pfOldPassword.enableInputMethods(true);
        this.pfNewPassword.enableInputMethods(true);
        this.pfConfirmNewPassword.enableInputMethods(true);
        this.pfNewPassword.getDocument().addDocumentListener(documentListener);
        this.pfConfirmNewPassword.getDocument().addDocumentListener(documentListener);
        this.pfOldPassword.setColumns(8);
        this.pfNewPassword.setColumns(8);
        this.pfConfirmNewPassword.setColumns(8);
        this.pfOldPassword.setEnabled(!this.disableOldPassword);
        this.pfOldPassword.setEditable(!this.disableOldPassword);
        ComponentOrientation co = UIUtils.getComponentOrientation();
        this.pfOldPassword.setComponentOrientation(co);
        this.pfNewPassword.setComponentOrientation(co);
        this.pfConfirmNewPassword.setComponentOrientation(co);
        this.pfOldPassword.addFocusListener(new OldPasswordFocusListener());
        this.pfNewPassword.setEnabled(this.oldPasswordValid);
        this.pfConfirmNewPassword.setEnabled(this.oldPasswordValid);
    }

    protected void layoutComponents() {
        this.iSizeBetweenRows = 5;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 5, this.iSizeBetweenRows, 5);
        c.weightx = 0.0;
        this.add((Component)new OrientableLabel(StringResources.OLD_PASSWORD_C), c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.add((Component)this.pfOldPassword, c);
        c.gridx = 0;
        ++c.gridy;
        c.insets = new Insets(5, 5, this.iSizeBetweenRows, 5);
        c.weightx = 0.0;
        this.add((Component)new OrientableLabel(StringResources.NEW_PASSWORD_C), c);
        c.gridx = 1;
        c.weightx = 1.0;
        this.add((Component)this.pfNewPassword, c);
        c.gridx = 0;
        ++c.gridy;
        c.weightx = 0.0;
        this.add((Component)new OrientableLabel(StringResources.CONFIRM_NEW_PASSWORD_C), c);
        c.weightx = 1.0;
        c.gridx = 1;
        this.add((Component)this.pfConfirmNewPassword, c);
        this.constraints = c;
    }

    public boolean isOldPasswordValid() {
        return this.oldPasswordValid;
    }

    public Insets getInsets() {
        return new Insets(4, 6, 6, 6);
    }

    protected void reset(boolean disableOldPassword) {
        this.oldPasswordValid = this.disableOldPassword = disableOldPassword;
        this.pfOldPassword.setText("");
        this.pfOldPassword.setEnabled(!this.disableOldPassword);
        this.pfOldPassword.setEditable(!this.disableOldPassword);
        this.pfNewPassword.setEnabled(this.oldPasswordValid);
        this.pfConfirmNewPassword.setEnabled(this.oldPasswordValid);
        this.clearFields();
    }

    public String getOldPassword() {
        char[] cc = this.pfOldPassword.getPassword();
        return cc == null ? "" : String.valueOf(cc);
    }

    public String getNewPassword() {
        char[] cc = this.pfNewPassword.getPassword();
        return cc == null ? "" : String.valueOf(cc);
    }

    public String getConfirmNewPassword() {
        char[] cc = this.pfConfirmNewPassword.getPassword();
        return cc == null ? "" : String.valueOf(cc);
    }

    protected void clearFields() {
        this.pfNewPassword.setText("");
        this.pfConfirmNewPassword.setText("");
    }

    private void checkFieldsValue() {
        String newPass = this.getNewPassword();
        String newPassConf = this.getConfirmNewPassword();
        if (newPass.length() > 0 && newPassConf.length() > 0 && newPass.equals(newPassConf)) {
            this.newPasswordFine = true;
            this.handleNewPasswordMatch();
        } else {
            this.newPasswordFine = false;
            this.handleNewPasswordDontMatch();
        }
    }

    protected void handleNewPasswordMatch() {
    }

    protected void handleNewPasswordDontMatch() {
    }

    public void setFocusOldPassword() {
        this.pfOldPassword.requestFocus(true);
    }

    public void checkOldPassword() {
        if (this.oldPasswordValid) {
            return;
        }
        GWCommandManager commandManager = GWCommandManager.getInstance(this.userGuid);
        boolean valid = false;
        if (EngineCommandManager.getCurrentMode() == EngineMode.CACHING && this.changeOnline) {
            logger.debug((Object)"checking online password");
            valid = commandManager.validateOnlineMailboxPassword(this.getOldPassword());
        } else {
            logger.debug((Object)"checking password");
            valid = commandManager.validatePassword(this.getOldPassword());
        }
        logger.debug((Object)("valid = " + valid));
        if (valid) {
            this.oldPasswordValid = true;
            this.pfOldPassword.setEnabled(false);
            this.pfNewPassword.setEnabled(true);
            this.pfConfirmNewPassword.setEnabled(true);
            this.pfNewPassword.requestFocusInWindow();
            this.handleOldPasswordValidated();
        }
    }

    protected void handleOldPasswordValidated() {
    }

    public boolean isNewPasswordFine() {
        return this.newPasswordFine;
    }

    public boolean isNewPasswordProvided() {
        return this.getNewPassword().length() != 0 || this.getConfirmNewPassword().length() != 0;
    }

    private class OldPasswordFocusListener
    extends FocusAdapter {
        private OldPasswordFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            AbstractPasswordChangePanel.this.checkOldPassword();
        }
    }

    private class FieldsDocumentListener
    implements DocumentListener {
        private FieldsDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            AbstractPasswordChangePanel.this.checkFieldsValue();
        }

        public void removeUpdate(DocumentEvent e) {
            AbstractPasswordChangePanel.this.checkFieldsValue();
        }

        public void changedUpdate(DocumentEvent e) {
            AbstractPasswordChangePanel.this.checkFieldsValue();
        }
    }
}

