/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import java.awt.Color;
import javax.swing.plaf.UIResource;

public class ColorUtils {
    public static Color revertColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null");
        }
        return new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getRed());
    }

    public static Color unwrapColor(Color color) {
        if (color instanceof UIResource) {
            return new Color(color.getRGB());
        }
        return color;
    }

    public static Color halveColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null");
        }
        return new Color(ColorUtils.halveChanel(color.getRed()), ColorUtils.halveChanel(color.getGreen()), ColorUtils.halveChanel(color.getBlue()));
    }

    private static int halveChanel(int chanel) {
        assert (chanel >= 0 && chanel <= 255) : "illegal chanel value: " + chanel + " (must be in the range 0-255)";
        return (chanel + 255) / 2;
    }
}

