/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls;

import com.appframework.ApplicationFrame;
import com.appframework.mvc.MVCController;
import com.novell.gw.jclient.api.enums.DataStoreAccessRequestType;
import com.novell.gw.jclient.api.enums.ItemType;
import com.novell.gw.jclient.application.actions.folder.ActionDeleteFolder;
import com.novell.gw.jclient.application.actions.folder.ActionNewFolder;
import com.novell.gw.jclient.application.actions.folder.ActionRenameFolder;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialog;
import com.novell.gw.jclient.application.controls.basicdialogs.ApplicationDialogController;
import com.novell.gw.jclient.application.controls.folderstree.EditableFoldersTree;
import com.novell.gw.jclient.application.controls.mnemonic.JMnemonicButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.controls.orientable.OrientableScrollPane;
import com.novell.gw.jclient.application.frames.search.PlainFoldersTree;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.om.GWCommandManager;
import com.novell.gw.jclient.bl.om.folders.AbstractFolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldersDialog
extends ApplicationDialog<ApplicationDialogController> {
    private PlainFoldersTree treeFolders;
    private AbstractFolder folder;
    private String description;
    private AbstractAction actionNewFolder = new NewFolderAction();
    private AbstractAction actionDeleteFolder = new DeleteFolderAction();
    private AbstractAction actionRenameFolder = new RenameFolderAction();
    private AbstractAction actionMoveUPFolder = new MoveUPFolderAction();
    private AbstractAction actionMoveDownFolder = new MoveDownFolderAction();
    private AbstractAction actionMoveLeftFolder = new MoveLeftFolderAction();
    private AbstractAction actionMoveRightFolder = new MoveRightFolderAction();
    private boolean allowModify = false;

    public FoldersDialog(ApplicationFrame applicationFrame, AbstractFolder folder, String description) {
        super((Frame)applicationFrame, applicationFrame.getController(), true);
        this.folder = folder;
        this.description = description;
        this.init();
    }

    public FoldersDialog(JDialog dialog, MVCController parentController, AbstractFolder folder, String description) {
        super((Dialog)dialog, parentController, true);
        this.folder = folder;
        this.description = description;
        this.init();
    }

    @Override
    protected ApplicationDialogController createController(MVCController parentController) {
        return new ApplicationDialogController<FoldersDialog>(this, parentController);
    }

    private void init() {
        this.buildUI();
        if (this.folder != null) {
            this.enableActions(this.folder);
        }
        this.treeFolders.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode selectedNode;
                TreePath selectionPath = e.getNewLeadSelectionPath();
                if (selectionPath != null && (selectedNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent()) != null) {
                    AbstractFolder folder = (AbstractFolder)selectedNode.getUserObject();
                    FoldersDialog.this.folder = folder;
                    FoldersDialog.this.enableActions(folder);
                }
            }
        });
        if (this.folder == null) {
            this.getBtnOk().setEnabled(false);
        } else {
            this.treeFolders.scrollFolderToBottom(this.folder);
        }
    }

    private void enableActions(AbstractFolder folder) {
        if (this.allowModify) {
            this.actionNewFolder.setEnabled(folder.canHaveChildren());
            this.actionRenameFolder.setEnabled(folder.canRename());
            this.actionDeleteFolder.setEnabled(folder.canDelete());
        } else {
            this.actionNewFolder.setEnabled(false);
            this.actionRenameFolder.setEnabled(false);
            this.actionDeleteFolder.setEnabled(false);
        }
        this.treeFolders.enableActions(this.folder, this.actionMoveUPFolder, this.actionMoveDownFolder, this.actionMoveRightFolder, this.actionMoveLeftFolder);
    }

    public AbstractFolder getSelectedFolder() {
        return this.treeFolders.getSelectedFolder();
    }

    @Override
    protected void doBeforeDispose() {
        this.treeFolders.clear();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (!b) {
            this.dispose();
        }
    }

    private void buildUI() {
        this.setTitle(StringResources.FOLDERS);
        JPanel pnlContent = (JPanel)this.getContentPane();
        pnlContent.removeAll();
        pnlContent.setLayout(new BorderLayout(5, 5));
        pnlContent.add((Component)new OrientableLabel(this.description), "North");
        pnlContent.add((Component)this.buildButtonsPane(), "After");
        OrientablePanel pnlFolders = new OrientablePanel(new BorderLayout());
        pnlFolders.add((Component)new OrientableLabel(StringResources.FOLDER_LIST_C), "North");
        String userGuid = ((ApplicationFrame)SwingUtilities.getAncestorOfClass(ApplicationFrame.class, this)).getUserGuid();
        this.treeFolders = new EditableFoldersTree((MVCController)this.getController(), userGuid);
        pnlFolders.add((Component)new OrientableScrollPane(this.treeFolders), "Center");
        if (this.folder != null) {
            this.treeFolders.selectFolder(this.folder);
        }
        pnlContent.add((Component)pnlFolders, "Center");
        pnlContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.allowModify = GWCommandManager.getInstance(userGuid).getCurrentDataStore().checkAccess(DataStoreAccessRequestType.ITEM_CREATE, ItemType.FOLDER, 0);
    }

    private Container buildButtonsPane() {
        OrientablePanel buttonPanel = new OrientablePanel(new GridLayout(0, 1, 0, 10));
        buttonPanel.add(this.getBtnOk());
        buttonPanel.add(this.getBtnCancel());
        buttonPanel.add(new JMnemonicButton(this.actionNewFolder));
        buttonPanel.add(new JMnemonicButton(this.actionRenameFolder));
        buttonPanel.add(new JMnemonicButton(this.actionDeleteFolder));
        buttonPanel.add(new JMnemonicButton(this.actionMoveUPFolder));
        buttonPanel.add(new JMnemonicButton(this.actionMoveDownFolder));
        buttonPanel.add(new JMnemonicButton(this.actionMoveRightFolder));
        buttonPanel.add(new JMnemonicButton(this.actionMoveLeftFolder));
        OrientablePanel pnlTemp = new OrientablePanel(new BorderLayout());
        pnlTemp.add((Component)buttonPanel, "North");
        return pnlTemp;
    }

    private class MoveLeftFolderAction
    extends AbstractAction {
        public MoveLeftFolderAction() {
            super(StringResources.MOVE_LEFT);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            FoldersDialog.this.treeFolders.moveLeftFolder(FoldersDialog.this.folder);
            FoldersDialog.this.enableActions(FoldersDialog.this.folder);
            FoldersDialog.this.getBtnCancel().setText(StringResources.CLOSE);
        }
    }

    private class MoveRightFolderAction
    extends AbstractAction {
        public MoveRightFolderAction() {
            super(StringResources.MOVE_RIGHT);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            FoldersDialog.this.treeFolders.moveRightFolder(FoldersDialog.this.folder);
            FoldersDialog.this.enableActions(FoldersDialog.this.folder);
            FoldersDialog.this.getBtnCancel().setText(StringResources.CLOSE);
        }
    }

    private class MoveDownFolderAction
    extends AbstractAction {
        public MoveDownFolderAction() {
            super(StringResources.MOVE_DOWN);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            FoldersDialog.this.treeFolders.moveDownFolder(FoldersDialog.this.folder);
            FoldersDialog.this.enableActions(FoldersDialog.this.folder);
            FoldersDialog.this.getBtnCancel().setText(StringResources.CLOSE);
        }
    }

    private class MoveUPFolderAction
    extends AbstractAction {
        public MoveUPFolderAction() {
            super(StringResources.MOVE_UP);
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            FoldersDialog.this.treeFolders.moveUpFolder(FoldersDialog.this.folder);
            FoldersDialog.this.enableActions(FoldersDialog.this.folder);
            FoldersDialog.this.getBtnCancel().setText(StringResources.CLOSE);
        }
    }

    private class DeleteFolderAction
    extends AbstractAction {
        public DeleteFolderAction() {
            super(StringResources.DELETE);
        }

        public void actionPerformed(ActionEvent e) {
            ActionDeleteFolder.doPerformAction(FoldersDialog.this.folder, FoldersDialog.this, ControlsUtils.getUserGuid(FoldersDialog.this.getController()));
            FoldersDialog.this.getBtnCancel().setText(StringResources.CLOSE);
        }
    }

    private class RenameFolderAction
    extends AbstractAction {
        public RenameFolderAction() {
            super(StringResources.RENAME);
        }

        public void actionPerformed(ActionEvent e) {
            ActionRenameFolder.doPerformActionForTree(FoldersDialog.this.folder, FoldersDialog.this.treeFolders);
            FoldersDialog.this.getBtnCancel().setText(StringResources.CLOSE);
        }
    }

    private class NewFolderAction
    extends AbstractAction {
        public NewFolderAction() {
            super(StringResources.NEW);
        }

        public void actionPerformed(ActionEvent e) {
            JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, FoldersDialog.this);
            ActionNewFolder.doPerformAction(frame, FoldersDialog.this.folder);
            FoldersDialog.this.getBtnCancel().setText(StringResources.CLOSE);
        }
    }
}

