/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.mvc.Command;
import com.appframework.mvc.MVCController;
import com.appframework.utils.UIUtils;
import com.novell.gw.jclient.api.enums.RecipientCopyType;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.actions.ActionKey;
import com.novell.gw.jclient.application.controls.addressbook.AbstractAddressSelectorDialog;
import com.novell.gw.jclient.application.controls.addressbook.DistributionListRenderer;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.addressbook.list.RecipientsList;
import com.novell.gw.jclient.application.controls.addressbook.table.AddressSelectorEntriesTable;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import com.novell.gw.jclient.bl.impl.dnd.GWFlavors;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutFocusTraversalPolicy;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLSelectorDialog
extends AbstractAddressSelectorDialog {
    private static Logger logger = Logger.getLogger(DLSelectorDialog.class);
    private JToggleButton tbTo;
    private JToggleButton tbCC;
    private JToggleButton tbBC;
    private static final String NAME = "DL Selector Dialog";

    public DLSelectorDialog(JFrame theParentFrame, List theRecipients, MVCController theParentController) {
        super(theParentFrame, theParentController);
        this.init(theRecipients);
    }

    public DLSelectorDialog(JDialog theParentDialog, List theRecipients, MVCController theParentController) {
        super(theParentDialog, theParentController);
        this.init(theRecipients);
    }

    private void init(List theRecipients) {
        Command command = new Command(380, theRecipients);
        ((MVCController)this.getController()).processCommand(command);
        this.toggleSizeSaving(NAME);
        this.setFocusTraversalPolicy(new ABFocusTraversalPolicy());
    }

    @Override
    protected void init() {
        this.listRecipients = new RecipientsList((MVCController)this.getController());
        this.listRecipients.setCellRenderer(new DistributionListRenderer());
        this.tableAddressList = new AddressSelectorEntriesTable((MVCController)this.getController(), this.tfSearch);
        this.tableAddressList.setName("DLSelectorDialog_tableAddressList");
        super.init();
        this.buildRightPane();
        this.getContentPane().add((Component)this.pnlRight, "After");
        this.pack();
    }

    @Override
    protected void processOkAction(ActionEvent event) {
        super.processOkAction(event);
        Command command = new Command(700, this.listRecipients.getRecipientList());
        ((MVCController)this.getController()).processCommand(command);
        this.dispose();
    }

    public List<IRecipient> getSelectedRecipients() {
        return this.listRecipients.getRecipientList();
    }

    public List<IRecipient> getToRecipients() {
        return this.getRecipientsByCopyType(RecipientCopyType.getTo());
    }

    public List<IRecipient> getCCRecipients() {
        return this.getRecipientsByCopyType(RecipientCopyType.getCc());
    }

    public List<IRecipient> getBCRecipients() {
        return this.getRecipientsByCopyType(RecipientCopyType.getBc());
    }

    private List<IRecipient> getRecipientsByCopyType(RecipientCopyType theCopyType) {
        List<IRecipient> recipients = this.listRecipients.getRecipientList();
        ArrayList<IRecipient> result = new ArrayList<IRecipient>();
        int nSize = recipients.size();
        for (int i = 0; i < nSize; ++i) {
            IRecipient recipient = recipients.get(i);
            if (!recipient.getCopyType().hasRecipientCopyType(theCopyType)) continue;
            result.add(recipient);
        }
        return result;
    }

    @Override
    protected JPanel buildToggleButtons() {
        OrientablePanel pnlContent = new OrientablePanel(new GridBagLayout());
        GridBagAdapter gridBagAdapter = new GridBagAdapter(pnlContent);
        gridBagAdapter.setColumnCount(3);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.tbTo = new DropToggleButton(new ButtonToAction());
        UIUtils.setText(this.tbTo, StringResources.TO);
        this.tbTo.setSelected(true);
        gridBagAdapter.setInsets(new Insets(0, 0, 0, 0));
        gridBagAdapter.setAnchor(21);
        gridBagAdapter.setFill(0);
        gridBagAdapter.addComponent(this.tbTo);
        buttonGroup.add(this.tbTo);
        this.tbCC = new DropToggleButton(new ButtonCcAction());
        UIUtils.setText(this.tbCC, StringResources.CC);
        gridBagAdapter.setInsets(new Insets(0, 20, 0, 20));
        gridBagAdapter.setFill(0);
        gridBagAdapter.setAnchor(10);
        gridBagAdapter.setWidthX(1);
        gridBagAdapter.addComponent(this.tbCC);
        buttonGroup.add(this.tbCC);
        this.tbBC = new DropToggleButton(new ButtonBcAction());
        UIUtils.setText(this.tbBC, StringResources.BC);
        gridBagAdapter.setAnchor(13);
        gridBagAdapter.setFill(0);
        gridBagAdapter.setInsets(new Insets(0, 0, 0, 0));
        gridBagAdapter.addComponent(this.tbBC);
        buttonGroup.add(this.tbBC);
        this.tbTo.setName("DLSelectorDialog_tbTo");
        this.tbCC.setName("DLSelectorDialog_tbCC");
        this.tbBC.setName("DLSelectorDialog_tbBC");
        return pnlContent;
    }

    private class ABFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private ABFocusTraversalPolicy() {
        }

        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(DLSelectorDialog.this.tableAddressList)) {
                return DLSelectorDialog.this.tbTo;
            }
            return super.getComponentAfter(focusCycleRoot, aComponent);
        }

        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            if (aComponent.equals(DLSelectorDialog.this.tbTo)) {
                return DLSelectorDialog.this.tableAddressList;
            }
            return super.getComponentBefore(focusCycleRoot, aComponent);
        }
    }

    private class DropToggleButton
    extends JToggleButton {
        public DropToggleButton(Action a) {
            super(a);
            this.setDropTarget(new DropTarget(this, 3, new DTDTListener()));
        }

        private class DTDTListener
        extends DropTargetAdapter {
            private DTDTListener() {
            }

            public void dragOver(DropTargetDragEvent dtde) {
            }

            public void drop(DropTargetDropEvent dtde) {
                if (!dtde.isLocalTransfer()) {
                    return;
                }
                try {
                    if (dtde.getTransferable().getTransferData(GWFlavors.contactsFlavor) instanceof IContact[]) {
                        if (DropToggleButton.this.getAction() instanceof ButtonToAction) {
                            ((MVCController)DLSelectorDialog.this.getController()).getActionList().performAction(ActionKey.MOVE_TO_RECIPIENTS_LIST_TO);
                        } else if (DropToggleButton.this.getAction() instanceof ButtonCcAction) {
                            ((MVCController)DLSelectorDialog.this.getController()).getActionList().performAction(ActionKey.MOVE_TO_RECIPIENTS_LIST_CC);
                        } else if (DropToggleButton.this.getAction() instanceof ButtonBcAction) {
                            ((MVCController)DLSelectorDialog.this.getController()).getActionList().performAction(ActionKey.MOVE_TO_RECIPIENTS_LIST_BC);
                        }
                    } else {
                        dtde.rejectDrop();
                    }
                }
                catch (UnsupportedFlavorException e) {
                    logger.error((Object)e);
                    logger.debug((Object)e, (Throwable)e);
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    logger.debug((Object)e, (Throwable)e);
                }
            }
        }
    }

    private class ButtonBcAction
    extends AbstractAction {
        private ButtonBcAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DLSelectorDialog.this.setCopyType(RecipientCopyType.getBc());
            ((MVCController)DLSelectorDialog.this.getController()).getActionList().performAction(ActionKey.MOVE_TO_RECIPIENTS_LIST_BC);
        }
    }

    private class ButtonCcAction
    extends AbstractAction {
        private ButtonCcAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DLSelectorDialog.this.setCopyType(RecipientCopyType.getCc());
            ((MVCController)DLSelectorDialog.this.getController()).getActionList().performAction(ActionKey.MOVE_TO_RECIPIENTS_LIST_CC);
        }
    }

    private class ButtonToAction
    extends AbstractAction {
        private ButtonToAction() {
        }

        public void actionPerformed(ActionEvent e) {
            DLSelectorDialog.this.setCopyType(RecipientCopyType.getTo());
            ((MVCController)DLSelectorDialog.this.getController()).getActionList().performAction(ActionKey.MOVE_TO_RECIPIENTS_LIST_TO);
        }
    }
}

