/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IRecipient;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.ABUtils;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.apache.log4j.Logger;

public class DistributionListRenderer
implements ListCellRenderer {
    private static Logger logger = Logger.getLogger(DistributionListRenderer.class);
    private JLabel lbTo = new OrientableLabel(StringResources.TO_C);
    private JLabel lbCc = new OrientableLabel(StringResources.CC_C);
    private JLabel lbBc = new OrientableLabel(StringResources.BC_C);
    private int titleWidth;
    private JLabel lbLeft;
    private JPanel pnlItem;
    private JPanel pnlContent;
    private JLabel lbRight;

    public DistributionListRenderer() {
        this.titleWidth = Math.max(Math.max(this.lbTo.getPreferredSize().width, this.lbCc.getPreferredSize().width), this.lbBc.getPreferredSize().width) + 5;
        this.lbLeft = new OrientableLabel();
        this.pnlItem = new OrientablePanel(new GridBagLayout());
        this.pnlItem.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.pnlContent = new OrientablePanel(new BorderLayout());
        this.lbRight = new OrientableLabel();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        IRecipient recipient = (IRecipient)value;
        this.setTitle(recipient, index, list);
        this.lbLeft.setPreferredSize(new Dimension(this.titleWidth, this.lbLeft.getPreferredSize().height));
        this.setText(recipient);
        this.setIcon(value);
        this.pnlItem.removeAll();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 21;
        constraints.fill = 0;
        this.pnlItem.add((Component)this.lbLeft, constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        this.pnlItem.add((Component)this.lbRight, constraints);
        if (isSelected) {
            this.pnlItem.setBackground(list.getSelectionBackground());
            this.pnlItem.setForeground(list.getSelectionForeground());
        } else {
            this.pnlItem.setBackground(list.getBackground());
            this.pnlItem.setForeground(list.getForeground());
        }
        int listSize = list.getModel().getSize();
        if (index + 1 < listSize && !DistributionListRenderer.hasSameCopyType(DistributionListRenderer.getRecipientAt(list, index + 1), recipient)) {
            this.pnlContent.removeAll();
            this.pnlContent.add((Component)this.pnlItem, "Center");
            this.pnlContent.setBorder(BorderFactory.createEmptyBorder(0, 0, this.pnlItem.getPreferredSize().height, 0));
            this.pnlContent.setBackground(list.getBackground());
            return this.pnlContent;
        }
        return this.pnlItem;
    }

    private void setTitle(IRecipient recipient, int index, JList list) {
        this.lbLeft.setText("");
        if (index == 0 || !DistributionListRenderer.hasSameCopyType(DistributionListRenderer.getRecipientAt(list, index - 1), recipient)) {
            if (recipient.getCopyType().hasTo()) {
                this.lbLeft.setText(StringResources.TO_C);
            } else if (recipient.getCopyType().hasCc()) {
                this.lbLeft.setText(StringResources.CC_C);
            } else if (recipient.getCopyType().hasBc()) {
                this.lbLeft.setText(StringResources.BC_C);
            }
        }
    }

    private void setText(IRecipient value) {
        this.lbRight.setText(ControlsUtils.recipientToString(value));
    }

    private static boolean hasSameCopyType(IRecipient recipient1, IRecipient recipient2) {
        return recipient1.getCopyType().equals(recipient2.getCopyType());
    }

    private static IRecipient getRecipientAt(JList theList, int theIndex) {
        return (IRecipient)theList.getModel().getElementAt(theIndex);
    }

    private void setIcon(Object value) {
        IAddressable recipient = ((IRecipient)value).getAddressable();
        this.lbRight.setIcon(ABUtils.getIcon(recipient));
    }
}

