/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.appframework.ApplicationFrame;
import com.appframework.components.ActionEnablerTextField;
import com.novell.gw.jclient.application.controls.addressbook.dialogs.GridBagAdapter;
import com.novell.gw.jclient.application.controls.orientable.OrientableButton;
import com.novell.gw.jclient.application.controls.orientable.OrientableLabel;
import com.novell.gw.jclient.application.controls.orientable.OrientablePanel;
import com.novell.gw.jclient.application.dialogs.GWDialog;
import com.novell.gw.jclient.application.resources.StringResources;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class SaveAsBookDialog
extends GWDialog {
    private static Logger logger = Logger.getLogger(SaveAsBookDialog.class);
    private JTextField tfName;
    private String oldDirectoryName;
    public static final String NAME = "Name";

    public SaveAsBookDialog(ApplicationFrame theFrame, String theDirectoryName) {
        super(theFrame);
        this.btnOK = new OrientableButton(new OkAction());
        this.setDefaultButton(this.btnOK);
        this.tfName = new ActionEnablerTextField(this.btnOK.getAction());
        this.setTitle(StringResources.SAVE_AS_ADDRESS_BOOK);
        this.oldDirectoryName = theDirectoryName;
        this.buildUI();
        this.tfName.requestFocusInWindow();
    }

    private void buildUI() {
        OrientablePanel pnlContent = new OrientablePanel(new GridBagLayout());
        GridBagAdapter adapter = new GridBagAdapter(pnlContent);
        adapter.setColumnCount(2);
        adapter.setResizableColumn(0);
        adapter.setAnchor(13);
        adapter.addComponent(new OrientableLabel(StringResources.SAVE_AS_ADDRESS_BOOK_C));
        adapter.addComponent(this.btnOK);
        adapter.addComponent(this.tfName);
        adapter.addComponent(this.btnCancel);
        this.tfName.requestFocus();
        this.panCenterPanel.add((Component)pnlContent, "Center");
        this.setNames();
    }

    private void setNames() {
        this.tfName.setName(NAME);
    }

    public String getDirectoryName() {
        return this.tfName.getText();
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            super(StringResources.OK);
        }

        public void actionPerformed(ActionEvent e) {
            if (SaveAsBookDialog.this.oldDirectoryName.equals(SaveAsBookDialog.this.getDirectoryName())) {
                JOptionPane.showMessageDialog(SaveAsBookDialog.this, StringResources.formatString(StringResources.AN_ADDRESS_BOOK_NAMED, SaveAsBookDialog.this.getDirectoryName()));
            } else {
                SaveAsBookDialog.this.setActionCompleteSuccessfully(true);
                SaveAsBookDialog.disposeDialog(SaveAsBookDialog.this);
            }
        }
    }
}

