/*
 * Decompiled with CFR 0.152.
 */
package com.novell.gw.jclient.application.controls.addressbook;

import com.novell.gw.engine.EngineException;
import com.novell.gw.jclient.api.impl.APIWrapperManager;
import com.novell.gw.jclient.api.impl.ab.APIAbWrapperManager;
import com.novell.gw.jclient.api.interfaces.IItemList;
import com.novell.gw.jclient.api.interfaces.ab.IAddressable;
import com.novell.gw.jclient.api.interfaces.ab.IContact;
import com.novell.gw.jclient.application.controls.ControlsUtils;
import com.novell.gw.jclient.application.controls.addressbook.SearchEvent;
import com.novell.gw.jclient.application.controls.addressbook.SearchResultListener;
import com.novell.gw.jclient.application.controls.gwcomponent.GWTextField;
import com.novell.gw.jclient.application.controls.popedit.DisambiguationDialog;
import com.novell.gw.jclient.application.controls.popedit.StringParser;
import com.novell.gw.jclient.bl.eng_impl.EngineCommandManager;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.Timer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

@Deprecated
public class SearchTextField
extends GWTextField {
    private static Logger logger = Logger.getLogger(SearchTextField.class);
    public static final char[] DELIMETERS = new char[]{';', ','};
    private static final String[] STR_DELIMETERS;
    private TimerAction timerAction = new TimerAction();
    private Timer timer = new Timer(400, this.timerAction);
    protected List foundContacts;
    private int contactIndex;
    protected IContact foundContact;
    private SearchResultListener listener;
    private DisambiguationDialog dialog;
    protected boolean processFocusEvents = true;

    public SearchTextField() {
        this.setDocument(new SearchDocument());
        this.addKeyListener(new PEKeyListener());
        this.timer.setRepeats(false);
    }

    public void setListener(SearchResultListener listener) {
        this.listener = listener;
    }

    public boolean addToRecipiensList() {
        String text = this.getText();
        if (text.trim().length() != 0) {
            if (this.timer.isRunning()) {
                this.timer.stop();
                this.timerAction.actionPerformed(null);
            }
            IAddressable contact = this.foundContacts == null ? APIAbWrapperManager.createAddress(text, text) : (IContact)this.foundContacts.get(this.contactIndex);
            boolean b = this.addToList(contact);
            this.clearSearchResult();
            this.timerAction.searchText = "";
            this.setText("");
            return b;
        }
        return false;
    }

    private void removeSameContacts(IContact theContact) {
        if (this.foundContacts != null && this.foundContacts.size() > 1) {
            int nSize = this.foundContacts.size();
            String strDisplayName = theContact.getDisplayName();
            for (int i = 0; i < nSize; ++i) {
                try {
                    IContact contact = (IContact)this.foundContacts.get(i);
                    if (!contact.getDisplayName().equalsIgnoreCase(strDisplayName) || contact.equals(theContact)) continue;
                    this.foundContacts.remove(contact);
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getLocalizedMessage());
                }
            }
        }
    }

    private boolean addToList(IAddressable addressable) {
        boolean result = false;
        if (addressable instanceof IContact) {
            List sameContacts = this.getSameContacts((IContact)addressable);
            if (!(sameContacts.size() <= 1 || this.dialog != null && this.dialog.isShowing())) {
                Window parent = ControlsUtils.getWindowForComponent(this);
                this.dialog = parent instanceof Frame ? new DisambiguationDialog((JFrame)parent, sameContacts) : new DisambiguationDialog((JDialog)parent, sameContacts);
                this.processFocusEvents = false;
                this.dialog.showMe();
                this.processFocusEvents = true;
                if (this.dialog.isActionCompleteSuccessfully()) {
                    addressable = this.dialog.getSelectedContact();
                    this.removeSameContacts((IContact)addressable);
                    if (this.listener != null) {
                        this.listener.searchFinished(new SearchEvent(addressable));
                    }
                    result = true;
                }
            } else {
                if (this.listener != null) {
                    this.listener.searchFinished(new SearchEvent(addressable));
                }
                result = true;
            }
        } else {
            if (this.listener != null) {
                this.listener.searchFinished(new SearchEvent(addressable));
            }
            result = true;
        }
        return result;
    }

    public void setText(String t) {
        SearchDocument document = (SearchDocument)this.getDocument();
        document.setParseString(false);
        super.setText(t);
        document.setParseString(true);
    }

    public void clearAndSetText(String t) {
        this.foundContact = null;
        this.setText(t);
    }

    private boolean isLastContactBeginWith(String thePrefix) {
        return this.foundContacts != null && ((IContact)this.foundContacts.get(this.contactIndex)).getDisplayName().toLowerCase().startsWith(thePrefix.toLowerCase());
    }

    public void insertString(int nOffset, String str, AttributeSet a) throws BadLocationException {
        SearchDocument document = (SearchDocument)this.getDocument();
        document.insertString(nOffset, str, a);
    }

    public IContact getFoundContact() {
        return this.foundContact;
    }

    public void updateListener() {
        this.addToRecipiensList();
    }

    private List getSameContacts(IContact theContact) {
        ArrayList<IContact> result = new ArrayList<IContact>();
        if (this.foundContacts != null && this.foundContacts.size() > 1) {
            int nSize = this.foundContacts.size();
            String strDisplayName = theContact.getDisplayName();
            for (int i = 0; i < nSize; ++i) {
                IContact contact = (IContact)this.foundContacts.get(i);
                if (!contact.getDisplayName().equalsIgnoreCase(strDisplayName)) continue;
                result.add(contact);
            }
            int foundSize = result.size();
            if (foundSize > 1) {
                boolean bIdentical = true;
                IContact firstContact = (IContact)result.get(0);
                String strAddr = firstContact.getEmailAddress();
                for (int i = 1; i < foundSize; ++i) {
                    IContact nextContact = (IContact)result.get(i);
                    if (strAddr.equalsIgnoreCase(nextContact.getEmailAddress())) continue;
                    bIdentical = false;
                    break;
                }
                if (bIdentical) {
                    result.clear();
                    result.add(firstContact);
                }
            }
        }
        return result;
    }

    private IContact getPrevContact() {
        this.contactIndex = this.contactIndex == 0 ? this.foundContacts.size() - 1 : --this.contactIndex;
        return (IContact)this.foundContacts.get(this.contactIndex);
    }

    private IContact getNextContact() {
        this.contactIndex = this.contactIndex == this.foundContacts.size() - 1 ? 0 : ++this.contactIndex;
        return (IContact)this.foundContacts.get(this.contactIndex);
    }

    protected IAddressable search(String theSearchText) {
        IAddressable result = null;
        this.clearSearchResult();
        try {
            if (theSearchText.trim().equals("*")) {
                result = APIAbWrapperManager.createAddress("*", "*");
            } else {
                logger.debug((Object)("inside search. findContactsByName performed theSearchText ==" + theSearchText + "the end"));
                IItemList list = APIWrapperManager.getItemList(EngineCommandManager.getAddressBookManager().findContactsByName(theSearchText));
                if (list != null) {
                    this.foundContacts = ControlsUtils.itemListToList(list);
                    result = (IContact)this.foundContacts.get(0);
                }
            }
        }
        catch (EngineException e) {
            logger.error((Object)e);
        }
        if (result == null) {
            try {
                logger.debug((Object)("inside search. findContactByEmail performed theSearchText == " + theSearchText + "the end"));
                result = APIAbWrapperManager.getContact(EngineCommandManager.getAddressBookManager().findContactByEmail(theSearchText));
            }
            catch (EngineException e) {
                logger.error((Object)e);
            }
        }
        if (result == null) {
            result = APIAbWrapperManager.createAddress(theSearchText, theSearchText);
        }
        return result;
    }

    private boolean isContactLastName(String theStr) {
        if (this.foundContacts == null) {
            return false;
        }
        boolean result = false;
        int nSize = this.foundContacts.size();
        String strLower = theStr.toLowerCase();
        for (int i = 0; i < nSize; ++i) {
            if (!(this.foundContacts.get(i) instanceof IContact)) continue;
            IContact contact = (IContact)this.foundContacts.get(i);
            boolean bl = result = contact.getDisplayName().indexOf(44) != -1 && contact.getLastName().toLowerCase().equals(strLower);
            if (!result) continue;
            this.contactIndex = i;
            break;
        }
        return result;
    }

    protected String parseString(String theStrRecipients) {
        List<String> tokens = StringParser.getAllTokens(theStrRecipients, DELIMETERS);
        String lastToken = theStrRecipients;
        int nSize = tokens.size();
        for (int i = 0; i < nSize; ++i) {
            String token = tokens.get(i).toString().trim();
            if (this.listener != null && i > 0) {
                if (this.foundContacts != null && !this.foundContacts.isEmpty()) {
                    this.addToList((IAddressable)this.foundContacts.get(this.contactIndex));
                } else {
                    lastToken = lastToken.trim();
                    this.addToList(APIAbWrapperManager.createAddress(lastToken, lastToken));
                }
            }
            this.clearSearchResult();
            lastToken = tokens.get(i).toString();
            if (token.length() == 0) continue;
            this.search(token);
            if (i >= tokens.size() - 1 || !this.isContactLastName(token)) continue;
            String nextToken = tokens.get(i + 1).toString();
            ++i;
            lastToken = token + ',' + nextToken;
            if (this.isContact(lastToken)) continue;
            this.clearSearchResult();
        }
        return lastToken;
    }

    private boolean isContact(String token) {
        if (this.foundContacts != null) {
            int nSize = this.foundContacts.size();
            String strLower = token.toLowerCase();
            for (int i = 0; i < nSize; ++i) {
                IContact contact = (IContact)this.foundContacts.get(i);
                if (!contact.getDisplayName().toLowerCase().startsWith(strLower)) continue;
                this.foundContact = contact;
                this.contactIndex = i;
                return true;
            }
        }
        return false;
    }

    protected void clearSearchResult() {
        this.foundContacts = null;
        this.contactIndex = 0;
    }

    public void setTextToParse(String theText) {
        super.setText(theText);
    }

    public IContact getContact() {
        if (this.foundContacts != null) {
            return (IContact)this.foundContacts.get(0);
        }
        return null;
    }

    static {
        Arrays.sort(DELIMETERS);
        STR_DELIMETERS = new String[]{";", ",", System.getProperty("line.separator")};
    }

    private class TimerAction
    implements ActionListener {
        private String searchText = "";

        private TimerAction() {
        }

        public void setSearchText(String searchText) {
            this.searchText = searchText;
            if (this.searchText.length() == 0) {
                SearchTextField.this.clearSearchResult();
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this.searchText.length() > 0 && SearchTextField.this.isEditable()) {
                String lastToken = SearchTextField.this.parseString(this.searchText);
                if (!lastToken.equals(this.searchText)) {
                    SearchTextField.this.setText(lastToken);
                }
                if (SearchTextField.this.foundContacts != null) {
                    String text = lastToken;
                    IContact contact = (IContact)SearchTextField.this.foundContacts.get(SearchTextField.this.contactIndex);
                    String displayName = contact.getDisplayName();
                    if (displayName.toLowerCase().startsWith(lastToken.toLowerCase())) {
                        text = displayName;
                    }
                    SearchTextField.this.setText(text);
                    SearchTextField.this.setCaretPosition(lastToken.length());
                    SearchTextField.this.select(lastToken.length(), displayName.length());
                }
            }
        }
    }

    private class PEKeyListener
    extends KeyAdapter {
        private PEKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            int start;
            int ch = e.getKeyCode();
            if (ch == 38 && SearchTextField.this.foundContacts != null) {
                SearchTextField.this.foundContact = SearchTextField.this.getPrevContact();
                start = SearchTextField.this.getSelectionStart();
                SearchTextField.this.setText(SearchTextField.this.foundContact.getDisplayName());
                SearchTextField.this.select(start, SearchTextField.this.foundContact.getDisplayName().length());
            }
            if (ch == 40 && SearchTextField.this.foundContacts != null) {
                SearchTextField.this.foundContact = SearchTextField.this.getNextContact();
                start = SearchTextField.this.getSelectionStart();
                SearchTextField.this.setText(SearchTextField.this.foundContact.getDisplayName());
                SearchTextField.this.select(start, SearchTextField.this.foundContact.getDisplayName().length());
            }
            if (ch == 127) {
                SearchTextField.this.clearSearchResult();
            }
        }
    }

    class SearchDocument
    extends PlainDocument {
        private boolean parseString = true;

        SearchDocument() {
        }

        public void remove(int offs, int len) throws BadLocationException {
            int start = SearchTextField.this.getSelectionStart();
            int length = SearchTextField.this.getSelectionEnd() - start;
            super.remove(offs, len);
            if (this.parseString && (start != offs || length != len || len <= 0)) {
                SearchTextField.this.timer.restart();
                SearchTextField.this.timerAction.setSearchText(SearchTextField.this.getText());
            }
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            SearchTextField comboEdit = SearchTextField.this;
            String prefix = comboEdit.getText().substring(0, offs);
            String text = prefix + str;
            boolean b = offs >= comboEdit.getText().length();
            super.insertString(offs, str, a);
            SearchTextField.this.timerAction.setSearchText(comboEdit.getText());
            if (!b) {
                SearchTextField.this.clearSearchResult();
            }
            if (this.parseString && b) {
                if (SearchTextField.this.isLastContactBeginWith(SearchTextField.this.getText())) {
                    SearchTextField.this.timer.stop();
                    super.remove(offs, str.length());
                    IContact contact = (IContact)SearchTextField.this.foundContacts.get(SearchTextField.this.contactIndex);
                    String postfix = contact.getDisplayName().substring(text.length() - 1);
                    super.insertString(offs, postfix, a);
                    SearchTextField.this.select(offs + str.length(), contact.getDisplayName().length());
                } else if (Arrays.asList(STR_DELIMETERS).contains(str)) {
                    SearchTextField.this.timer.restart();
                    SearchTextField.this.timerAction.setSearchText(comboEdit.getText());
                    super.remove(offs, 1);
                    SearchTextField.this.timer.stop();
                    if (SearchTextField.this.foundContacts == null) {
                        SearchTextField.this.timerAction.actionPerformed(null);
                    } else {
                        SearchTextField.this.addToRecipiensList();
                    }
                } else {
                    SearchTextField.this.timer.restart();
                    SearchTextField.this.timerAction.setSearchText(SearchTextField.this.getText());
                }
            }
            if (offs == 0 && str.length() == 0) {
                SearchTextField.this.foundContacts = null;
                SearchTextField.this.timer.stop();
            }
        }

        public void setParseString(boolean parseString) {
            this.parseString = parseString;
        }
    }
}

